/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;

public class BasicOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    protected boolean hasCustomComponents;
    protected Component initialFocusComponent;
    protected JComponent inputComponent;
    protected Dimension minimumSize;
    protected PropertyChangeListener propertyChangeListener;
    protected JOptionPane optionPane;
    private static final int iconSize = 36;
    private transient Color messageForeground;
    private transient Border messageBorder;
    private transient Border buttonBorder;
    private static final String OK_STRING = "OK";
    private static final String YES_STRING = "Yes";
    private static final String NO_STRING = "No";
    private static final String CANCEL_STRING = "Cancel";
    transient Container messageAreaContainer;
    transient Container buttonContainer;
    private static MessageIcon errorIcon;
    private static MessageIcon infoIcon;
    private static MessageIcon warningIcon;
    private static MessageIcon questionIcon;

    private /* synthetic */ void finit$() {
        this.hasCustomComponents = false;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BasicOptionPaneUI() {
        this.finit$();
    }

    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Component component;
            if (objectArray[i] == null) continue;
            if (objectArray[i] instanceof Component) {
                component = (Component)objectArray[i];
            } else {
                component = objectArray[i] instanceof Icon ? new JButton((Icon)objectArray[i]) : new JButton(objectArray[i].toString());
                this.hasCustomComponents = true;
            }
            if (component instanceof JButton) {
                ((JButton)component).addActionListener(this.createButtonActionListener(i));
            }
            if (i == n) {
                this.initialFocusComponent = component;
            }
            container.add(component);
        }
        this.selectInitialValue(this.optionPane);
    }

    protected void addIcon(Container container) {
        JLabel jLabel = null;
        Icon icon = this.getIcon();
        if (icon != null) {
            jLabel = new JLabel(icon);
            container.add((Component)jLabel, "West");
        }
    }

    private static GridBagConstraints createConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        return gridBagConstraints;
    }

    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        this.hasCustomComponents = bl;
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                this.addMessageComponents(container, gridBagConstraints, objectArray[i], n, bl);
            }
            return;
        }
        if (object instanceof Component) {
            container.add((Component)object, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else if (object instanceof Icon) {
            container.add((Component)new JLabel((Icon)object), gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else if (object.toString().length() > n) {
            Box box = new Box(1);
            this.burstStringInto(box, object.toString(), n);
            this.addMessageComponents(container, gridBagConstraints, box, n, true);
        } else {
            this.addMessageComponents(container, gridBagConstraints, new JLabel(object.toString()), n, true);
        }
    }

    protected void burstStringInto(Container container, String string, int n) {
        if (string == null || container == null) {
            return;
        }
        JLabel jLabel = new JLabel(string);
        container.add(jLabel);
    }

    public boolean containsCustomComponents(JOptionPane jOptionPane) {
        return this.hasCustomComponents;
    }

    protected ActionListener createButtonActionListener(int n) {
        return new ButtonActionListener(this, n);
    }

    protected Container createButtonArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.createLayoutManager());
        this.addButtonComponents(jPanel, this.getButtons(), this.getInitialValueIndex());
        return jPanel;
    }

    protected LayoutManager createLayoutManager() {
        return new ButtonAreaLayout(this.getSizeButtonsToSameWidth(), 6);
    }

    protected Container createMessageArea() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.addIcon(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = BasicOptionPaneUI.createConstraints();
        this.addMessageComponents(jPanel2, gridBagConstraints, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        if (this.optionPane.getWantsInput()) {
            Object[] objectArray = this.optionPane.getSelectionValues();
            this.inputComponent = objectArray == null ? new JTextField(15) : (objectArray.length < 20 ? new JComboBox(objectArray) : new JList(objectArray));
            if (this.inputComponent != null) {
                this.addMessageComponents(jPanel2, gridBagConstraints, this.inputComponent, this.getMaxCharactersPerLineCount(), false);
                this.resetSelectedValue();
                this.selectInitialValue(this.optionPane);
            }
        }
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected Container createSeparator() {
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOptionPaneUI();
    }

    protected Object[] getButtons() {
        if (this.optionPane.getOptions() != null) {
            return this.optionPane.getOptions();
        }
        switch (this.optionPane.getOptionType()) {
            case 0: {
                return new Object[]{YES_STRING, NO_STRING};
            }
            case 1: {
                return new Object[]{YES_STRING, NO_STRING, CANCEL_STRING};
            }
            case 2: {
                return new Object[]{OK_STRING, CANCEL_STRING};
            }
            case -1: {
                if (this.optionPane.getWantsInput()) {
                    return new Object[]{OK_STRING, CANCEL_STRING};
                }
                if (this.optionPane.getMessageType() == 3) {
                    return new Object[]{YES_STRING, NO_STRING, CANCEL_STRING};
                }
                return new Object[]{OK_STRING};
            }
        }
        return null;
    }

    protected Icon getIcon() {
        if (this.optionPane.getIcon() != null) {
            return this.optionPane.getIcon();
        }
        return this.getIconForType(this.optionPane.getMessageType());
    }

    protected Icon getIconForType(int n) {
        MessageIcon messageIcon = null;
        switch (n) {
            case 0: {
                messageIcon = errorIcon;
                break;
            }
            case 1: {
                messageIcon = infoIcon;
                break;
            }
            case 2: {
                messageIcon = warningIcon;
                break;
            }
            case 3: {
                messageIcon = questionIcon;
            }
        }
        return messageIcon;
    }

    protected int getInitialValueIndex() {
        Object[] objectArray = this.getButtons();
        if (objectArray == null) {
            return -1;
        }
        Object object = this.optionPane.getInitialValue();
        for (int i = 0; i < objectArray.length; ++i) {
            if (object != objectArray[i]) continue;
            return i;
        }
        return 0;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected Object getMessage() {
        return this.optionPane.getMessage();
    }

    public Dimension getMinimumOptionPaneSize() {
        return this.minimumSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.optionPane.getLayout().preferredLayoutSize(this.optionPane);
        Dimension dimension2 = this.getMinimumOptionPaneSize();
        int n = Math.max(dimension.width, dimension2.width);
        int n2 = Math.max(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected void installComponents() {
        Container container;
        Container container2;
        this.hasCustomComponents = false;
        Container container3 = this.createMessageArea();
        if (container3 != null) {
            ((JComponent)container3).setBorder(this.messageBorder);
            container3.setForeground(this.messageForeground);
            this.messageAreaContainer = container3;
            this.optionPane.add(container3);
        }
        if ((container2 = this.createSeparator()) != null) {
            this.optionPane.add(container2);
        }
        if ((container = this.createButtonArea()) != null) {
            ((JComponent)container).setBorder(this.buttonBorder);
            this.buttonContainer = container;
            this.optionPane.add(container);
        }
        this.optionPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.optionPane.invalidate();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.optionPane.setOpaque(true);
        this.messageBorder = UIManager.getBorder("OptionPane.messageAreaBorder");
        this.messageForeground = UIManager.getColor("OptionPane.messageForeground");
        this.buttonBorder = UIManager.getBorder("OptionPane.buttonAreaBorder");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JOptionPane) {
            this.optionPane = (JOptionPane)jComponent;
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    protected void resetInputValue() {
        if (this.optionPane.getWantsInput() && this.inputComponent != null) {
            Object object = null;
            if (this.inputComponent instanceof JTextField) {
                object = ((JTextField)this.inputComponent).getText();
            } else if (this.inputComponent instanceof JComboBox) {
                object = ((JComboBox)this.inputComponent).getSelectedItem();
            } else if (this.inputComponent instanceof JList) {
                object = ((JList)this.inputComponent).getSelectedValue();
            }
            if (object != null) {
                this.optionPane.setInputValue(object);
            }
        }
    }

    public void selectInitialValue(JOptionPane jOptionPane) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
            return;
        }
        if (this.initialFocusComponent != null) {
            this.initialFocusComponent.requestFocus();
        }
    }

    void resetSelectedValue() {
        if (this.inputComponent != null) {
            Object object = this.optionPane.getInitialSelectionValue();
            if (object == null) {
                return;
            }
            if (this.inputComponent instanceof JTextField) {
                ((JTextField)this.inputComponent).setText((String)object);
            } else if (this.inputComponent instanceof JComboBox) {
                ((JComboBox)this.inputComponent).setSelectedItem(object);
            } else if (this.inputComponent instanceof JList) {
                // empty if block
            }
        }
    }

    protected void uninstallComponents() {
        this.optionPane.removeAll();
        this.buttonContainer = null;
        this.messageAreaContainer = null;
    }

    protected void uninstallDefaults() {
        this.optionPane.setFont(null);
        this.optionPane.setForeground(null);
        this.optionPane.setBackground(null);
        this.minimumSize = null;
        this.messageBorder = null;
        this.buttonBorder = null;
        this.messageForeground = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    static {
        OK_STRING = OK_STRING;
        YES_STRING = YES_STRING;
        NO_STRING = NO_STRING;
        CANCEL_STRING = CANCEL_STRING;
        errorIcon = new MessageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = basicOptionPaneUI;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Polygon polygon = new Polygon(new int[]{0, 0, 9, 27, 36, 36, 27, 9}, new int[]{9, 27, 36, 36, 27, 9, 0, 0}, 8);
                graphics.translate(n, n2);
                Color color = graphics.getColor();
                graphics.setColor(Color.RED);
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(13, 16, 10, 4);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
        infoIcon = new MessageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = basicOptionPaneUI;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.translate(n, n2);
                Color color = graphics.getColor();
                graphics.setColor(Color.RED);
                graphics.fillOval(0, 0, 36, 36);
                graphics.setColor(Color.BLACK);
                graphics.drawOval(16, 6, 4, 4);
                Polygon polygon = new Polygon(new int[]{15, 15, 13, 13, 23, 23, 21, 21}, new int[]{12, 28, 28, 30, 30, 28, 28, 12}, 8);
                graphics.drawPolygon(polygon);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
        warningIcon = new MessageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = basicOptionPaneUI;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.translate(n, n2);
                Color color = graphics.getColor();
                graphics.setColor(Color.YELLOW);
                Polygon polygon = new Polygon(new int[]{0, 18, 36}, new int[]{36, 0, 36}, 3);
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.BLACK);
                Polygon polygon2 = new Polygon(new int[]{15, 16, 20, 21}, new int[]{8, 26, 26, 8}, 4);
                graphics.drawPolygon(polygon2);
                graphics.drawOval(16, 30, 4, 4);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
        questionIcon = new MessageIcon(null){
            private /* synthetic */ BasicOptionPaneUI this$0;
            {
                this.this$0 = basicOptionPaneUI;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.translate(n, n2);
                Color color = graphics.getColor();
                graphics.setColor(Color.GREEN);
                graphics.fillRect(0, 0, 36, 36);
                graphics.setColor(Color.BLACK);
                graphics.drawOval(11, 2, 16, 16);
                graphics.drawOval(14, 5, 10, 10);
                graphics.setColor(Color.GREEN);
                graphics.fillRect(0, 10, 36, 26);
                graphics.setColor(Color.BLACK);
                graphics.drawLine(11, 10, 14, 10);
                graphics.drawLine(24, 10, 17, 22);
                graphics.drawLine(27, 10, 20, 22);
                graphics.drawLine(17, 22, 20, 22);
                graphics.drawOval(17, 25, 3, 3);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
    }

    private static class MessageIcon
    implements Icon {
        public int getIconWidth() {
            return 36;
        }

        public int getIconHeight() {
            return 36;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        MessageIcon() {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicOptionPaneUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("icon") || propertyChangeEvent.getPropertyName().equals("messageType")) {
                this.this$0.addIcon(this.this$0.messageAreaContainer);
            } else if (propertyChangeEvent.getPropertyName().equals("initialSelectionValue")) {
                this.this$0.resetSelectedValue();
            } else if (propertyChangeEvent.getPropertyName().equals("initialValue") || propertyChangeEvent.getPropertyName().equals("options") || propertyChangeEvent.getPropertyName().equals("optionType")) {
                Container container = this.this$0.createButtonArea();
                this.this$0.optionPane.remove(this.this$0.buttonContainer);
                this.this$0.optionPane.add(container);
                this.this$0.buttonContainer = container;
            } else if (propertyChangeEvent.getPropertyName().equals("message") || propertyChangeEvent.getPropertyName().equals("wantsInput") || propertyChangeEvent.getPropertyName().equals("selectionValues")) {
                this.this$0.optionPane.remove(this.this$0.messageAreaContainer);
                this.this$0.messageAreaContainer = this.this$0.createMessageArea();
                this.this$0.optionPane.add(this.this$0.messageAreaContainer);
                Container container = this.this$0.createButtonArea();
                this.this$0.optionPane.remove(this.this$0.buttonContainer);
                this.this$0.optionPane.add(container);
                this.this$0.buttonContainer = container;
                this.this$0.optionPane.add(this.this$0.buttonContainer);
            }
            this.this$0.optionPane.invalidate();
            this.this$0.optionPane.repaint();
        }

        public PropertyChangeHandler(BasicOptionPaneUI basicOptionPaneUI) {
            this.this$0 = basicOptionPaneUI;
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean centersChildren;
        protected int padding;
        protected boolean syncAllWidths;
        private transient int widthOfWidestButton;
        private transient int tallestButton;

        private /* synthetic */ void finit$() {
            this.centersChildren = true;
        }

        public ButtonAreaLayout(boolean bl, int n) {
            this.finit$();
            this.syncAllWidths = bl;
            this.padding = n;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public int getPadding() {
            return this.padding;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            int n = container.getInsets().left;
            if (this.getCentersChildren()) {
                n += (int)((double)container.getSize().width / 2.0 - (double)this.buttonRowLength(container) / 2.0);
            }
            for (int i = 0; i < componentArray.length; ++i) {
                Dimension dimension = componentArray[i].getPreferredSize();
                if (this.syncAllWidths) {
                    componentArray[i].setBounds(n, 0, this.widthOfWidestButton, dimension.height);
                    n += this.widthOfWidestButton + this.getPadding();
                    continue;
                }
                componentArray[i].setBounds(n, 0, dimension.width, dimension.height);
                n += dimension.width + this.getPadding();
            }
        }

        private int buttonRowLength(Container container) {
            Cloneable cloneable;
            int n;
            Component[] componentArray = container.getComponents();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (n = 0; n < componentArray.length; ++n) {
                cloneable = componentArray[n].getPreferredSize();
                n2 += cloneable.width + this.getPadding();
                n3 = Math.max(n3, cloneable.width);
                n4 = Math.max(n4, cloneable.height);
            }
            this.widthOfWidestButton = n3;
            this.tallestButton = n4;
            n = this.getSyncAllWidths() ? n3 * componentArray.length + this.getPadding() * (componentArray.length - 1) : n2;
            cloneable = container.getInsets();
            return n += ((Insets)cloneable).left + ((Insets)cloneable).right;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.buttonRowLength(container);
            return new Dimension(n, this.tallestButton);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void setCentersChildren(boolean bl) {
            this.centersChildren = bl;
        }

        public void setPadding(int n) {
            this.padding = n;
        }

        public void setSyncAllWidths(boolean bl) {
            this.syncAllWidths = bl;
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        private /* synthetic */ BasicOptionPaneUI this$0;
        protected int buttonIndex;

        public ButtonActionListener(BasicOptionPaneUI basicOptionPaneUI, int n) {
            this.this$0 = basicOptionPaneUI;
            this.buttonIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame;
            Object object;
            Integer n = new Integer(-1);
            Object[] objectArray = this.this$0.optionPane.getOptions();
            if (objectArray != null) {
                n = new Integer(this.buttonIndex);
            } else {
                object = ((JButton)actionEvent.getSource()).getText();
                if (((String)object).equals(BasicOptionPaneUI.OK_STRING)) {
                    n = new Integer(0);
                }
                if (((String)object).equals(BasicOptionPaneUI.CANCEL_STRING)) {
                    n = new Integer(2);
                }
                if (((String)object).equals(BasicOptionPaneUI.YES_STRING)) {
                    n = new Integer(0);
                }
                if (((String)object).equals(BasicOptionPaneUI.NO_STRING)) {
                    n = new Integer(1);
                }
            }
            this.this$0.optionPane.setValue(n);
            this.this$0.resetInputValue();
            object = SwingUtilities.windowForComponent(this.this$0.optionPane);
            if (object instanceof JDialog) {
                ((JDialog)object).dispose();
            }
            if ((jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(BasicOptionPaneUI.class$("javax.swing.JInternalFrame"), this.this$0.optionPane)) != null) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

