/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.ListUI;

public class BasicListUI
extends ListUI {
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    protected FocusListener focusListener;
    protected ListDataListener listDataListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseInputListener mouseInputListener;
    protected PropertyChangeListener propertyChangeListener;
    private ComponentListener componentListener;
    protected JList list;
    protected int cellHeight;
    protected int cellWidth;
    protected int[] cellHeights;
    protected int updateLayoutStateNeeded = 1;
    protected CellRendererPane rendererPane = new CellRendererPane();
    ListAction action;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicListUI();
    }

    protected int getRowHeight(int n) {
        int n2 = this.cellHeights == null ? this.cellHeight : (n < 0 || n >= this.cellHeights.length ? -1 : this.cellHeights[n]);
        return n2;
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        if (jList != this.list || this.cellWidth == -1) {
            return null;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        Point point = this.indexToLocation(this.list, n3);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.cellWidth, this.getRowHeight(n3));
        for (int i = n3 + 1; i <= n4; ++i) {
            Point point2 = this.indexToLocation(this.list, i);
            Rectangle rectangle2 = new Rectangle(point2.x, point2.y, this.cellWidth, this.getRowHeight(i));
            rectangle = rectangle.union(rectangle2);
        }
        return rectangle;
    }

    protected int convertRowToY(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.getRowHeight(i);
            if (n3 == -1) {
                return -1;
            }
            n2 += n3;
        }
        return n2;
    }

    protected int convertYToRow(int n) {
        if (this.list.getModel().getSize() == 0) {
            return -1;
        }
        if (n < 0) {
            return this.list.getModel().getSize() - 1;
        }
        this.maybeUpdateLayoutState();
        int n2 = this.list.getModel().getSize() - 1;
        if (this.cellHeight > 0) {
            n2 = Math.min(n / this.cellHeight, n2);
        } else {
            int n3 = 0;
            for (int i = 0; i < this.cellHeights.length; ++i) {
                if (n >= (n3 += this.cellHeights[i])) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    protected void updateLayoutState() {
        Serializable serializable;
        int n;
        int n2 = this.list.getModel().getSize();
        this.cellHeight = -1;
        this.cellWidth = -1;
        if (this.cellHeights == null || this.cellHeights.length != n2) {
            this.cellHeights = new int[n2];
        }
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        int n3 = this.list.getFixedCellHeight();
        if (n3 > 0) {
            this.cellHeight = n3;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            for (n = 0; n < n2; ++n) {
                Component component = listCellRenderer.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(n), n, this.list.isSelectedIndex(n), this.list.getSelectionModel().getAnchorSelectionIndex() == n);
                serializable = component.getPreferredSize();
                this.cellHeights[n] = ((Dimension)serializable).height;
            }
        }
        n = this.list.getFixedCellWidth();
        if (n > 0) {
            this.cellWidth = n;
        } else {
            for (int i = 0; i < n2; ++i) {
                serializable = listCellRenderer.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(i), i, this.list.isSelectedIndex(i), this.list.getSelectionModel().getAnchorSelectionIndex() == i);
                Dimension dimension = ((Component)serializable).getPreferredSize();
                this.cellWidth = Math.max(this.cellWidth, dimension.width);
            }
            if (this.list.getLayoutOrientation() == 0) {
                this.cellWidth = Math.max(this.cellWidth, this.list.getSize().width);
            }
        }
    }

    void damageLayout() {
        this.updateLayoutStateNeeded = 1;
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        this.list.setOpaque(true);
    }

    protected void uninstallDefaults() {
        this.list.setForeground(null);
        this.list.setBackground(null);
        this.list.setSelectionForeground(null);
        this.list.setSelectionBackground(null);
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.list.addFocusListener(this.focusListener);
        if (this.listDataListener == null) {
            this.listDataListener = this.createListDataListener();
        }
        this.list.getModel().addListDataListener(this.listDataListener);
        if (this.listSelectionListener == null) {
            this.listSelectionListener = this.createListSelectionListener();
        }
        this.list.addListSelectionListener(this.listSelectionListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        this.componentListener = new ComponentHandler(this);
        this.list.addComponentListener(this.componentListener);
    }

    protected void uninstallListeners() {
        this.list.removeFocusListener(this.focusListener);
        this.list.getModel().removeListDataListener(this.listDataListener);
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("List.focusInputMap");
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        this.action = new ListAction(this);
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            KeyStroke keyStroke = keyStrokeArray[i];
            String string = (String)inputMap.get(keyStroke);
            inputMapUIResource.put(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), keyStroke.getModifiers()), string);
            actionMapUIResource.put(string, new ActionListenerProxy(this.action, string));
        }
        inputMapUIResource.setParent(this.list.getInputMap().getParent());
        actionMapUIResource.setParent(this.list.getActionMap().getParent());
        this.list.getInputMap().setParent(inputMapUIResource);
        this.list.getActionMap().setParent(actionMapUIResource);
    }

    protected void uninstallKeyboardActions() {
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.list = (JList)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.maybeUpdateLayoutState();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.list = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = this.list.getModel().getSize();
        if (n == 0) {
            return new Dimension(0, 0);
        }
        int n2 = this.list.getVisibleRowCount();
        int n3 = this.list.getLayoutOrientation();
        Rectangle rectangle = this.getCellBounds(this.list, 0, this.list.getModel().getSize() - 1);
        Dimension dimension = rectangle.getSize();
        Container container = this.list.getParent();
        if (n2 == -1 && container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            if (n3 == 2) {
                int n4 = jViewport.getSize().height;
                int n5 = n4 / this.cellHeight;
                int n6 = n / n5 * this.cellWidth;
                dimension = new Dimension(n6, n4);
            } else if (n3 == 1) {
                int n7 = jViewport.getSize().width;
                int n8 = Math.max(n7 / this.cellWidth, 1);
                int n9 = n / n8 * this.cellHeight;
                dimension = new Dimension(n7, n9);
            }
        }
        return dimension;
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        boolean bl = this.list.isSelectedIndex(n);
        boolean bl2 = this.list.getLeadSelectionIndex() == n && this.list.hasFocus();
        Component component = listCellRenderer.getListCellRendererComponent(this.list, listModel.getElementAt(n), 0, bl, bl2);
        this.rendererPane.paintComponent(graphics, component, this.list, rectangle);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.list.getModel().getSize();
        if (n == 0) {
            return;
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        ListModel listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        int n2 = listSelectionModel.getLeadSelectionIndex();
        Rectangle rectangle = graphics.getClipBounds();
        int n3 = this.list.locationToIndex(new Point(rectangle.x, rectangle.y));
        int n4 = this.list.locationToIndex(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        for (int i = n3; i <= n4; ++i) {
            Rectangle rectangle2 = this.getCellBounds(this.list, i, i);
            if (!rectangle2.intersects(rectangle)) continue;
            this.paintCell(graphics, i, rectangle2, listCellRenderer, listModel, listSelectionModel, n2);
        }
    }

    public int locationToIndex(JList jList, Point point) {
        int n = jList.getLayoutOrientation();
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.convertYToRow(point.y);
                break;
            }
            case 2: {
                int n3 = jList.getVisibleRowCount();
                int n4 = -1;
                int n5 = jList.getModel().getSize();
                Dimension dimension = jList.getSize();
                if (n3 <= 0) {
                    try {
                        n4 = dimension.width / this.cellWidth;
                    }
                    catch (ArithmeticException arithmeticException) {
                        n4 = 1;
                    }
                } else {
                    n4 = n5 / n3 + 1;
                }
                int n6 = n5 / n4 + 1;
                int n7 = Math.min(point.x / this.cellWidth, n4 - 1);
                int n8 = Math.min(point.y / this.cellHeight, n6);
                n2 = n7 + n8 * n4;
                break;
            }
            case 1: {
                int n9 = jList.getVisibleRowCount();
                if (n9 <= 0) {
                    Dimension dimension = jList.getSize();
                    n9 = dimension.height / this.cellHeight;
                }
                int n10 = jList.getModel().getSize();
                int n11 = n10 / n9 + 1;
                int n12 = Math.min(point.x / this.cellWidth, n11 - 1);
                int n13 = Math.min(point.y / this.cellHeight, n9);
                n2 = n13 + n12 * n9;
            }
        }
        return n2;
    }

    public Point indexToLocation(JList jList, int n) {
        int n2 = jList.getLayoutOrientation();
        Point point = null;
        switch (n2) {
            case 0: {
                point = new Point(0, this.convertRowToY(n));
                break;
            }
            case 2: {
                int n3 = jList.getVisibleRowCount();
                int n4 = -1;
                if (n3 <= 0) {
                    Dimension dimension = jList.getSize();
                    n4 = Math.max(dimension.width / this.cellWidth, 1);
                } else {
                    int n5 = jList.getModel().getSize();
                    n4 = n5 / n3 + 1;
                }
                int n6 = n % n4;
                int n7 = n / n4;
                int n8 = n6 * this.cellWidth;
                int n9 = n7 * this.cellHeight;
                point = new Point(n8, n9);
                break;
            }
            case 1: {
                int n10 = jList.getVisibleRowCount();
                if (n10 <= 0) {
                    Dimension dimension = jList.getSize();
                    n10 = dimension.height / this.cellHeight;
                }
                if (n10 > 0) {
                    int n11 = n % n10;
                    int n12 = n / n10;
                    int n13 = n12 * this.cellWidth;
                    int n14 = n11 * this.cellHeight;
                    point = new Point(n13, n14);
                    break;
                }
                point = new Point(0, this.convertRowToY(n));
            }
        }
        return point;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler(this);
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler(this);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectionModel().getLeadSelectionIndex();
        if (n < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(++n);
        }
        this.list.ensureIndexIsVisible(n);
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectionModel().getLeadSelectionIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
        }
        this.list.ensureIndexIsVisible(n);
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicListUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.this$0.list) {
                if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getOldValue() instanceof ListModel) {
                    ((ListModel)propertyChangeEvent.getOldValue()).removeListDataListener(this.this$0.listDataListener);
                }
                if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof ListModel) {
                    ((ListModel)propertyChangeEvent.getNewValue()).addListDataListener(this.this$0.listDataListener);
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                ++this.this$0.updateLayoutStateNeeded;
            } else if (propertyChangeEvent.getPropertyName().equals("selectionModel")) {
                this.this$0.updateLayoutStateNeeded += 2;
            } else if (propertyChangeEvent.getPropertyName().equals("font")) {
                this.this$0.updateLayoutStateNeeded += 4;
            } else if (propertyChangeEvent.getPropertyName().equals("fixedCellWidth")) {
                this.this$0.updateLayoutStateNeeded += 8;
            } else if (propertyChangeEvent.getPropertyName().equals("fixedCellHeight")) {
                this.this$0.updateLayoutStateNeeded += 16;
            } else if (propertyChangeEvent.getPropertyName().equals("prototypeCellValue")) {
                this.this$0.updateLayoutStateNeeded += 32;
            } else if (propertyChangeEvent.getPropertyName().equals("cellRenderer")) {
                this.this$0.updateLayoutStateNeeded += 64;
            }
            this.this$0.damageLayout();
        }

        public PropertyChangeHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicListUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.this$0.locationToIndex(this.this$0.list, point);
            if (n == -1) {
                return;
            }
            if (mouseEvent.isShiftDown()) {
                if (this.this$0.list.getSelectionMode() == 0) {
                    this.this$0.list.setSelectedIndex(n);
                } else if (this.this$0.list.getSelectionMode() == 1) {
                    this.this$0.list.setSelectionInterval(this.this$0.list.getAnchorSelectionIndex(), n);
                } else if (this.this$0.list.isSelectedIndex(this.this$0.list.getAnchorSelectionIndex())) {
                    this.this$0.list.getSelectionModel().setLeadSelectionIndex(n);
                } else {
                    this.this$0.list.addSelectionInterval(this.this$0.list.getAnchorSelectionIndex(), n);
                }
            } else if (mouseEvent.isControlDown()) {
                if (this.this$0.list.getSelectionMode() == 0) {
                    this.this$0.list.setSelectedIndex(n);
                } else if (this.this$0.list.isSelectedIndex(n)) {
                    this.this$0.list.removeSelectionInterval(n, n);
                } else {
                    this.this$0.list.addSelectionInterval(n, n);
                }
            } else {
                this.this$0.list.setSelectedIndex(n);
            }
            this.this$0.list.ensureIndexIsVisible(this.this$0.list.getLeadSelectionIndex());
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public MouseInputHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    class ListAction
    extends AbstractAction {
        private /* synthetic */ BasicListUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.this$0.list.getLeadSelectionIndex();
            int n2 = this.this$0.list.getModel().getSize() - 1;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this.this$0.list.getSelectionModel();
            String string = actionEvent.getActionCommand();
            if (n2 == -1) {
                return;
            }
            if (string.equals("selectNextRow")) {
                this.this$0.selectNextIndex();
            } else if (string.equals("selectPreviousRow")) {
                this.this$0.selectPreviousIndex();
            } else if (string.equals("clearSelection")) {
                this.this$0.list.clearSelection();
            } else if (string.equals("selectAll")) {
                this.this$0.list.setSelectionInterval(0, n2);
                this.this$0.list.addSelectionInterval(n, n);
            } else if (string.equals("selectLastRow")) {
                this.this$0.list.setSelectedIndex(this.this$0.list.getModel().getSize() - 1);
            } else if (string.equals("selectLastRowChangeLead")) {
                defaultListSelectionModel.moveLeadSelectionIndex(this.this$0.list.getModel().getSize() - 1);
            } else if (string.equals("scrollDownExtendSelection")) {
                int n3 = n == this.this$0.list.getLastVisibleIndex() ? Math.min(n2, n + (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getLastVisibleIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollDownChangeLead")) {
                int n4 = n == this.this$0.list.getLastVisibleIndex() ? Math.min(n2, n + (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getLastVisibleIndex();
                defaultListSelectionModel.moveLeadSelectionIndex(n4);
            } else if (string.equals("scrollUpExtendSelection")) {
                int n5 = n == this.this$0.list.getFirstVisibleIndex() ? Math.max(0, n - (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getFirstVisibleIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n5);
            } else if (string.equals("scrollUpChangeLead")) {
                int n6 = n == this.this$0.list.getFirstVisibleIndex() ? Math.max(0, n - (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getFirstVisibleIndex();
                defaultListSelectionModel.moveLeadSelectionIndex(n6);
            } else if (string.equals("selectNextRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.min(n + 1, n2));
            } else if (string.equals("selectFirstRow")) {
                this.this$0.list.setSelectedIndex(0);
            } else if (string.equals("selectFirstRowChangeLead")) {
                defaultListSelectionModel.moveLeadSelectionIndex(0);
            } else if (string.equals("selectFirstRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(0);
            } else if (string.equals("selectPreviousRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.max(0, n - 1));
            } else if (string.equals("scrollUp")) {
                int n7 = n == this.this$0.list.getFirstVisibleIndex() ? Math.max(0, n - (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getFirstVisibleIndex();
                this.this$0.list.setSelectedIndex(n7);
            } else if (string.equals("selectLastRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(this.this$0.list.getModel().getSize() - 1);
            } else if (string.equals("scrollDown")) {
                int n8 = n == this.this$0.list.getLastVisibleIndex() ? Math.min(n2, n + (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getLastVisibleIndex();
                this.this$0.list.setSelectedIndex(n8);
            } else if (string.equals("selectNextRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    this.this$0.selectNextIndex();
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.min(n2, n + 1));
                }
            } else if (string.equals("selectPreviousRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    this.this$0.selectPreviousIndex();
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.max(0, n - 1));
                }
            } else if (string.equals("addToSelection")) {
                this.this$0.list.addSelectionInterval(n, n);
            } else if (string.equals("extendTo")) {
                defaultListSelectionModel.setSelectionInterval(defaultListSelectionModel.getAnchorSelectionIndex(), n);
            } else if (string.equals("toggleAndAnchor")) {
                if (!this.this$0.list.isSelectedIndex(n)) {
                    this.this$0.list.addSelectionInterval(n, n);
                } else {
                    this.this$0.list.removeSelectionInterval(n, n);
                }
                defaultListSelectionModel.setAnchorSelectionIndex(n);
            }
            this.this$0.list.ensureIndexIsVisible(this.this$0.list.getLeadSelectionIndex());
        }

        ListAction(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        private /* synthetic */ BasicListUI this$0;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            Rectangle rectangle = this.this$0.getCellBounds(this.this$0.list, n, n2);
            this.this$0.list.repaint(rectangle);
        }

        public ListSelectionHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicListUI this$0;

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.this$0.damageLayout();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.this$0.damageLayout();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.this$0.damageLayout();
        }

        public ListDataHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicListUI this$0;

        public void focusGained(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        protected void repaintCellFocus() {
        }

        public FocusHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private /* synthetic */ BasicListUI this$0;

        public void componentResized(ComponentEvent componentEvent) {
            this.this$0.damageLayout();
        }

        ComponentHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }
}

