/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicLabelUI
extends LabelUI
implements PropertyChangeListener {
    protected static BasicLabelUI labelUI;

    public static ComponentUI createUI(JComponent jComponent) {
        if (labelUI == null) {
            labelUI = new BasicLabelUI();
        }
        return labelUI;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Insets insets = jLabel.getInsets();
        FontMetrics fontMetrics = jLabel.getToolkit().getFontMetrics(jLabel.getFont());
        this.layoutCL(jLabel, fontMetrics, jLabel.getText(), jLabel.getIcon(), rectangle, rectangle2, rectangle3);
        Rectangle rectangle4 = rectangle3.union(rectangle2);
        return new Dimension(insets.left + rectangle4.width + insets.right, insets.top + rectangle4.height + insets.bottom);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JLabel jLabel = (JLabel)jComponent;
        Font font = graphics.getFont();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font2 = jComponent.getFont();
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics(font2);
        rectangle3 = SwingUtilities.calculateInnerArea(jComponent, rectangle3);
        if (rectangle3.width < 0) {
            rectangle3.width = 0;
        }
        if (rectangle3.height < 0) {
            rectangle3.height = 0;
        }
        Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
        String string = this.layoutCL(jLabel, fontMetrics, jLabel.getText(), icon, rectangle3, rectangle2, rectangle);
        if (icon != null) {
            icon.paintIcon(jLabel, graphics, rectangle2.x, rectangle2.y);
        }
        if (string != null && !string.equals("")) {
            if (jLabel.isEnabled()) {
                this.paintEnabledText(jLabel, graphics, string, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                this.paintDisabledText(jLabel, graphics, string, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        }
        graphics.setFont(font);
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(jLabel.getBackground().brighter());
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
        graphics.setColor(jLabel.getBackground().darker());
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n + 1, n2 + 1);
        } else {
            graphics.drawString(string, n + 1, n2 + 1);
        }
        graphics.setColor(color);
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(jLabel.getForeground());
        int n3 = jLabel.getDisplayedMnemonicIndex();
        if (n3 != -1) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n3, n, n2);
        } else {
            graphics.drawString(string, n, n2);
        }
        graphics.setColor(color);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            this.installComponents(jLabel);
            this.installDefaults(jLabel);
            this.installListeners(jLabel);
            this.installKeyboardActions(jLabel);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (jComponent instanceof JLabel) {
            JLabel jLabel = (JLabel)jComponent;
            this.uninstallKeyboardActions(jLabel);
            this.uninstallListeners(jLabel);
            this.uninstallDefaults(jLabel);
            this.uninstallComponents(jLabel);
        }
    }

    protected void installComponents(JLabel jLabel) {
    }

    protected void uninstallComponents(JLabel jLabel) {
    }

    protected void installDefaults(JLabel jLabel) {
        LookAndFeel.installColorsAndFont(jLabel, "Label.background", "Label.foreground", "Label.font");
    }

    protected void uninstallDefaults(JLabel jLabel) {
        jLabel.setForeground(null);
        jLabel.setBackground(null);
        jLabel.setFont(null);
    }

    protected void installKeyboardActions(JLabel jLabel) {
    }

    protected void uninstallKeyboardActions(JLabel jLabel) {
    }

    protected void installListeners(JLabel jLabel) {
        jLabel.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JLabel jLabel) {
        jLabel.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

