/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicDirectoryModel;

public class BasicFileChooserUI
extends FileChooserUI {
    protected int cancelButtonMnemonic;
    protected String cancelButtonText;
    protected String cancelButtonToolTipText;
    protected Icon computerIcon;
    protected Icon detailsViewIcon;
    protected Icon directoryIcon;
    protected int directoryOpenButtonMnemonic;
    protected String directoryOpenButtonText;
    protected String directoryOpenButtonToolTipText;
    protected Icon fileIcon;
    protected Icon floppyDriveIcon;
    protected Icon hardDriveIcon;
    protected int helpButtonMnemonic;
    protected String helpButtonText;
    protected String helpButtonToolTipText;
    protected Icon homeFolderIcon;
    protected Icon listViewIcon;
    protected Icon newFolderIcon;
    protected int openButtonMnemonic;
    protected String openButtonText;
    protected String openButtonToolTipText;
    protected int saveButtonMnemonic;
    protected String saveButtonText;
    protected String saveButtonToolTipText;
    protected int updateButtonMnemonic;
    protected String updateButtonText;
    protected String updateButtonToolTipText;
    protected Icon upFolderIcon;
    JFileChooser filechooser;
    JList filelist;
    JComboBox filters;
    BasicDirectoryModel model;
    FileFilter acceptAll;
    FileView fv;
    static final int ICON_SIZE = 24;
    JComboBox parents;
    String filename;
    JButton accept;
    JButton cancel;
    JButton upFolderButton;
    JButton newFolderButton;
    JButton homeFolderButton;
    JPanel accessoryPanel;
    PropertyChangeListener propertyChangeListener;
    String acceptAllFileFilterText;
    String dirDescText;
    String fileDescText;
    boolean dirSelected;
    File currDir;
    JPanel bottomPanel;
    JPanel closePanel;
    JTextField entry;
    String parentPath;

    private /* synthetic */ void finit$() {
        this.computerIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }
        };
        this.detailsViewIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                graphics.setColor(Color.GRAY);
                graphics.drawRect(1, 1, 15, 20);
                graphics.drawLine(17, 6, 23, 6);
                graphics.drawLine(17, 12, 23, 12);
                graphics.drawLine(17, 18, 23, 18);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
        this.directoryIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                Point point = new Point(3, 7);
                Point point2 = new Point(3, 21);
                Point point3 = new Point(21, 21);
                Point point4 = new Point(21, 12);
                Point point5 = new Point(16, 12);
                Point point6 = new Point(13, 7);
                Polygon polygon = new Polygon(new int[]{point.x, point2.x, point3.x, point4.x, point5.x, point6.x}, new int[]{point.y, point2.y, point3.y, point4.y, point5.y, point6.y}, 6);
                graphics.setColor(new Color(153, 204, 255));
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.BLACK);
                graphics.drawPolygon(polygon);
                graphics.translate(-n, -n2);
                graphics.setColor(color);
            }
        };
        this.fileIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                Point point = new Point(5, 4);
                Point point2 = new Point(5, 20);
                Point point3 = new Point(19, 20);
                Point point4 = new Point(19, 7);
                Point point5 = new Point(16, 4);
                Polygon polygon = new Polygon(new int[]{point.x, point2.x, point3.x, point4.x, point5.x}, new int[]{point.y, point2.y, point3.y, point4.y, point5.y}, 5);
                graphics.setColor(Color.WHITE);
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.BLACK);
                graphics.drawPolygon(polygon);
                graphics.drawLine(16, 4, 14, 6);
                graphics.drawLine(14, 6, 19, 7);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
        this.floppyDriveIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }
        };
        this.hardDriveIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            }
        };
        this.homeFolderIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                Point point = new Point(12, 3);
                Point point2 = new Point(4, 10);
                Point point3 = new Point(20, 10);
                Polygon polygon = new Polygon(new int[]{point.x, point2.x, point3.x}, new int[]{point.y, point2.y, point3.y}, 3);
                graphics.setColor(new Color(104, 51, 0));
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.BLACK);
                graphics.drawPolygon(polygon);
                graphics.setColor(Color.WHITE);
                graphics.fillRect(8, 10, 8, 10);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(8, 10, 8, 10);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
        this.listViewIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            private void paintPartial(Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                graphics.setColor(Color.GRAY);
                graphics.drawRect(1, 1, 7, 10);
                graphics.drawLine(8, 6, 11, 6);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                this.paintPartial(graphics, 0, 0);
                this.paintPartial(graphics, 12, 0);
                this.paintPartial(graphics, 0, 12);
                this.paintPartial(graphics, 12, 12);
                graphics.setColor(color);
                graphics.translate(-n, -n2);
            }
        };
        this.newFolderIcon = this.directoryIcon;
        this.upFolderIcon = new Icon(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public int getIconHeight() {
                return 24;
            }

            public int getIconWidth() {
                return 24;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.translate(n, n2);
                Point point = new Point(3, 7);
                Point point2 = new Point(3, 21);
                Point point3 = new Point(21, 21);
                Point point4 = new Point(21, 12);
                Point point5 = new Point(16, 12);
                Point point6 = new Point(13, 7);
                Polygon polygon = new Polygon(new int[]{point.x, point2.x, point3.x, point4.x, point5.x, point6.x}, new int[]{point.y, point2.y, point3.y, point4.y, point5.y, point6.y}, 6);
                graphics.setColor(new Color(153, 204, 255));
                graphics.fillPolygon(polygon);
                graphics.setColor(Color.BLACK);
                graphics.drawPolygon(polygon);
                point = new Point(12, 15);
                point2 = new Point(9, 18);
                point3 = new Point(15, 18);
                Polygon polygon2 = new Polygon(new int[]{point.x, point2.x, point3.x}, new int[]{point.y, point2.y, point3.y}, 3);
                graphics.fillPolygon(polygon2);
                graphics.drawLine(12, 15, 12, 22);
                graphics.translate(-n, -n2);
                graphics.setColor(color);
            }
        };
        this.acceptAll = new AcceptAllFileFilter(this);
        this.fv = new BasicFileView(this);
        this.dirSelected = false;
        this.currDir = null;
    }

    void closeDialog() {
        Window window = SwingUtilities.windowForComponent(this.filechooser);
        if (window instanceof JDialog) {
            ((JDialog)window).dispose();
        }
    }

    public BasicFileChooserUI(JFileChooser jFileChooser) {
        this.finit$();
        this.filechooser = jFileChooser;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicFileChooserUI((JFileChooser)jComponent);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JFileChooser) {
            JFileChooser jFileChooser = (JFileChooser)jComponent;
            jFileChooser.resetChoosableFileFilters();
            this.createModel();
            this.clearIconCache();
            this.installDefaults(jFileChooser);
            this.installComponents(jFileChooser);
            this.installListeners(jFileChooser);
            File file = this.filechooser.getCurrentDirectory();
            if (file != null) {
                this.parentPath = ((Object)file).toString().substring(((Object)file).toString().lastIndexOf("/"));
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.model = null;
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        this.filechooser = null;
    }

    void boxEntries() {
        ArrayList arrayList = new ArrayList();
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            file = this.filechooser.getFileSystemView().getDefaultDirectory();
        }
        while (file != null) {
            String string = file.getName();
            if (string.equals("")) {
                string = file.getAbsolutePath();
            }
            arrayList.add(arrayList.size(), string);
            file = file.getParentFile();
        }
        if (arrayList.size() == 0) {
            return;
        }
        if (this.parents.getItemCount() > 0) {
            this.parents.removeAllItems();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            this.parents.addItem(arrayList.get(i));
        }
        this.parents.setSelectedIndex(arrayList.size() - 1);
        this.parents.revalidate();
        this.parents.repaint();
    }

    private ItemListener createBoxListener() {
        return new ItemListener(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                if (this.this$0.parents.getItemCount() - 1 == this.this$0.parents.getSelectedIndex()) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i <= this.this$0.parents.getSelectedIndex(); ++i) {
                    stringBuffer.append(this.this$0.parents.getItemAt(i));
                    stringBuffer.append(File.separatorChar);
                }
                this.this$0.filechooser.setCurrentDirectory(this.this$0.filechooser.getFileSystemView().createFileObject(stringBuffer.toString()));
            }
        };
    }

    private ItemListener createFilterListener() {
        return new ItemListener(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = this.this$0.filters.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                this.this$0.filechooser.setFileFilter(this.this$0.filechooser.getChoosableFileFilters()[n]);
            }
        };
    }

    void filterEntries() {
        FileFilter[] fileFilterArray = this.filechooser.getChoosableFileFilters();
        if (this.filters.getItemCount() > 0) {
            this.filters.removeAllItems();
        }
        int n = -1;
        String string = this.filechooser.getFileFilter().getDescription();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            if (string.equals(fileFilterArray[i].getDescription())) {
                n = i;
            }
            this.filters.addItem(fileFilterArray[i].getDescription());
        }
        this.filters.setSelectedIndex(n);
        this.filters.revalidate();
        this.filters.repaint();
    }

    public void installComponents(JFileChooser jFileChooser) {
        JLabel jLabel = new JLabel("Look In:");
        this.parents = new JComboBox();
        this.parents.setRenderer(new BasicComboBoxRenderer());
        this.boxEntries();
        jLabel.setLabelFor(this.parents);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(this.parents);
        JPanel jPanel2 = new JPanel();
        this.upFolderButton = new JButton();
        this.upFolderButton.setIcon(this.upFolderIcon);
        jPanel2.add(this.upFolderButton);
        this.homeFolderButton = new JButton();
        this.homeFolderButton = new JButton(this.homeFolderIcon);
        jPanel2.add(this.homeFolderButton);
        this.newFolderButton = new JButton();
        this.newFolderButton.setIcon(this.newFolderIcon);
        jPanel2.add(this.newFolderButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(this.listViewIcon);
        buttonGroup.add(jToggleButton);
        jPanel2.add(jToggleButton);
        JToggleButton jToggleButton2 = new JToggleButton();
        jToggleButton2.setIcon(this.detailsViewIcon);
        buttonGroup.add(jToggleButton2);
        jPanel2.add(jToggleButton2);
        JPanel jPanel3 = new JPanel();
        jPanel.add(jPanel2);
        jPanel3.setLayout(new FlowLayout(0, 0, 0));
        jPanel3.add(jPanel);
        this.accessoryPanel = new JPanel();
        if (this.filechooser.getAccessory() != null) {
            this.accessoryPanel.add((Component)this.filechooser.getAccessory(), "Center");
        }
        this.filelist = new JList(this.model);
        this.filelist.setVisibleRowCount(6);
        JScrollPane jScrollPane = new JScrollPane(this.filelist);
        jScrollPane.setPreferredSize(new Dimension(400, 175));
        this.filelist.setBackground(Color.WHITE);
        this.filelist.setLayoutOrientation(1);
        this.filelist.setCellRenderer(new ListLabelRenderer(this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel4.add((Component)this.accessoryPanel, gridBagConstraints);
        JLabel jLabel2 = new JLabel("File Name:");
        JLabel jLabel3 = new JLabel("Files of Type:");
        this.entry = new JTextField();
        this.filters = new JComboBox();
        this.filterEntries();
        jLabel2.setLabelFor(this.entry);
        jLabel2.setHorizontalTextPosition(2);
        jLabel3.setLabelFor(this.filters);
        jLabel3.setHorizontalTextPosition(2);
        this.closePanel = new JPanel();
        this.accept = this.getApproveButton(this.filechooser);
        this.cancel = new JButton(this.cancelButtonText);
        this.cancel.setMnemonic(this.cancelButtonMnemonic);
        this.cancel.setToolTipText(this.cancelButtonToolTipText);
        this.closePanel.add(this.accept);
        this.closePanel.add(this.cancel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new GridBagLayout());
        this.bottomPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.bottomPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bottomPanel.add((Component)this.entry, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.bottomPanel.add((Component)this.filters, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.bottomPanel.add((Component)this.closePanel, gridBagConstraints);
        this.filechooser.setLayout(new BorderLayout());
        this.filechooser.add((Component)jPanel3, "North");
        this.filechooser.add((Component)jPanel4, "Center");
        this.filechooser.add((Component)this.bottomPanel, "South");
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        this.parents = null;
        this.accept = null;
        this.cancel = null;
        this.upFolderButton = null;
        this.homeFolderButton = null;
        this.newFolderButton = null;
        this.filelist = null;
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(this.filechooser);
        this.filechooser.addPropertyChangeListener(this.propertyChangeListener);
        this.accept.addActionListener(this.getApproveSelectionAction());
        this.cancel.addActionListener(this.getCancelSelectionAction());
        this.upFolderButton.addActionListener(this.getChangeToParentDirectoryAction());
        this.homeFolderButton.addActionListener(this.getGoHomeAction());
        this.newFolderButton.addActionListener(this.getNewFolderAction());
        this.filters.addItemListener(this.createFilterListener());
        this.filelist.addMouseListener(this.createDoubleClickListener(this.filechooser, this.filelist));
        this.filelist.addListSelectionListener(this.createListSelectionListener(this.filechooser));
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        this.filechooser.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallStrings(jFileChooser);
        this.uninstallIcons(jFileChooser);
    }

    protected void installIcons(JFileChooser jFileChooser) {
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
    }

    protected void installStrings(JFileChooser jFileChooser) {
        this.acceptAllFileFilterText = UIManager.getString("FileChooser.acceptAllFileFilterText");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.cancelButtonToolTipText = UIManager.getString("FileChooser.cancelButtonToolTipText");
        this.dirDescText = UIManager.getString("FileChooser.directoryDescriptionText");
        this.fileDescText = UIManager.getString("FileChooser.fileDescriptionText");
        this.helpButtonMnemonic = UIManager.getInt("FileChooser.helpButtonMnemonic");
        this.helpButtonText = UIManager.getString("FileChooser.helpButtonText");
        this.helpButtonToolTipText = UIManager.getString("FileChooser.helpButtonToolTipText");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.openButtonText = UIManager.getString("FileChooser.openButtonText");
        this.openButtonToolTipText = UIManager.getString("FileChooser.openButtonToolTipText");
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.saveButtonText = UIManager.getString("FileChooser.saveButtonText");
        this.saveButtonToolTipText = UIManager.getString("FileChooser.saveButtonToolTipText");
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.acceptAllFileFilterText = null;
        this.cancelButtonMnemonic = 0;
        this.cancelButtonText = null;
        this.cancelButtonToolTipText = null;
        this.dirDescText = null;
        this.fileDescText = null;
        this.helpButtonMnemonic = 0;
        this.helpButtonText = null;
        this.helpButtonToolTipText = null;
        this.openButtonMnemonic = 0;
        this.openButtonText = null;
        this.openButtonToolTipText = null;
        this.saveButtonMnemonic = 0;
        this.saveButtonText = null;
        this.saveButtonToolTipText = null;
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.filechooser);
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(this){
            private /* synthetic */ BasicFileChooserUI this$0;
            {
                this.this$0 = basicFileChooserUI;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty")) {
                    if (this.this$0.filechooser.getSelectedFile() == null) {
                        this.this$0.setFileName(null);
                    } else {
                        this.this$0.setFileName(this.this$0.filechooser.getSelectedFile().toString());
                    }
                    int n = -1;
                    File file = this.this$0.filechooser.getSelectedFile();
                    for (n = 0; n < this.this$0.model.getSize() && !((File)this.this$0.model.getElementAt(n)).equals(file); ++n) {
                    }
                    if (n == -1) {
                        return;
                    }
                    this.this$0.filelist.setSelectedIndex(n);
                    this.this$0.filelist.ensureIndexIsVisible(n);
                    this.this$0.filelist.revalidate();
                    this.this$0.filelist.repaint();
                } else if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
                    this.this$0.filelist.clearSelection();
                    this.this$0.filelist.revalidate();
                    this.this$0.filelist.repaint();
                    this.this$0.setDirectorySelected(false);
                    this.this$0.setDirectory(this.this$0.filechooser.getCurrentDirectory());
                    this.this$0.boxEntries();
                } else if (propertyChangeEvent.getPropertyName().equals("ChoosableFileFilterChangedProperty") || propertyChangeEvent.getPropertyName().equals("fileFilterChanged")) {
                    this.this$0.filterEntries();
                } else if (propertyChangeEvent.getPropertyName().equals("DialogTypeChangedProperty") || propertyChangeEvent.getPropertyName().equals("DialogTitleChangedProperty")) {
                    Window window = SwingUtilities.windowForComponent(this.this$0.filechooser);
                    if (window instanceof JDialog) {
                        ((JDialog)window).setTitle(this.this$0.getDialogTitle(this.this$0.filechooser));
                    }
                    this.this$0.accept.setText(this.this$0.getApproveButtonText(this.this$0.filechooser));
                    this.this$0.accept.setToolTipText(this.this$0.getApproveButtonToolTipText(this.this$0.filechooser));
                    this.this$0.accept.setMnemonic(this.this$0.getApproveButtonMnemonic(this.this$0.filechooser));
                } else if (propertyChangeEvent.getPropertyName().equals("ApproveButtonTextChangedProperty")) {
                    this.this$0.accept.setText(this.this$0.getApproveButtonText(this.this$0.filechooser));
                } else if (propertyChangeEvent.getPropertyName().equals("ApproveButtonToolTipTextChangedProperty")) {
                    this.this$0.accept.setToolTipText(this.this$0.getApproveButtonToolTipText(this.this$0.filechooser));
                } else if (propertyChangeEvent.getPropertyName().equals("ApproveButtonMnemonicChangedProperty")) {
                    this.this$0.accept.setMnemonic(this.this$0.getApproveButtonMnemonic(this.this$0.filechooser));
                } else if (propertyChangeEvent.getPropertyName().equals("ControlButtonsAreShownChangedProperty")) {
                    if (this.this$0.filechooser.getControlButtonsAreShown()) {
                        GridBagConstraints gridBagConstraints = new GridBagConstraints();
                        gridBagConstraints.gridy = 1;
                        this.this$0.bottomPanel.add((Component)this.this$0.filters, gridBagConstraints);
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.gridy = 2;
                        gridBagConstraints.anchor = 13;
                        this.this$0.bottomPanel.add((Component)this.this$0.closePanel, gridBagConstraints);
                        this.this$0.bottomPanel.revalidate();
                        this.this$0.bottomPanel.repaint();
                        this.this$0.bottomPanel.doLayout();
                    } else {
                        this.this$0.bottomPanel.remove(this.this$0.closePanel);
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("acceptAllFileFilterUsedChanged")) {
                    if (this.this$0.filechooser.isAcceptAllFileFilterUsed()) {
                        this.this$0.filechooser.addChoosableFileFilter(this.this$0.getAcceptAllFileFilter(this.this$0.filechooser));
                    } else {
                        this.this$0.filechooser.removeChoosableFileFilter(this.this$0.getAcceptAllFileFilter(this.this$0.filechooser));
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("AccessoryChangedProperty")) {
                    JComponent jComponent;
                    JComponent jComponent2 = (JComponent)propertyChangeEvent.getOldValue();
                    if (jComponent2 != null) {
                        this.this$0.getAccessoryPanel().remove(jComponent2);
                    }
                    if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                        this.this$0.getAccessoryPanel().add(jComponent);
                    }
                }
                if (propertyChangeEvent.getPropertyName().equals("directoryChanged") || propertyChangeEvent.getPropertyName().equals("fileFilterChanged") || propertyChangeEvent.getPropertyName().equals("FileHidingChanged")) {
                    this.this$0.rescanCurrentDirectory(this.this$0.filechooser);
                }
                this.this$0.filechooser.revalidate();
                this.this$0.filechooser.repaint();
            }
        };
    }

    public String getFileName() {
        return this.filename;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public void setDirectoryName(String string) {
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
        this.filelist.revalidate();
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    public JButton getApproveButton(JFileChooser jFileChooser) {
        this.accept = new JButton(this.getApproveButtonText(jFileChooser));
        this.accept.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.accept.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        return this.accept;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonToolTipText() != null) {
            return jFileChooser.getApproveButtonToolTipText();
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return this.openButtonToolTipText;
    }

    public void clearIconCache() {
        if (this.fv instanceof BasicFileView) {
            ((BasicFileView)this.fv).clearIconCache();
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener(this);
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(this, jList);
    }

    protected boolean isDirectorySelected() {
        return this.dirSelected;
    }

    protected void setDirectorySelected(boolean bl) {
        this.dirSelected = bl;
    }

    protected File getDirectory() {
        return this.currDir;
    }

    protected void setDirectory(File file) {
        this.currDir = file;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAll;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fv;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string != null) {
            return string;
        }
        switch (jFileChooser.getDialogType()) {
            case 0: {
                string = this.openButtonText;
                break;
            }
            case 1: {
                string = this.saveButtonText;
                break;
            }
            default: {
                string = jFileChooser.getApproveButtonText();
            }
        }
        if (string == null) {
            string = this.openButtonText;
        }
        return string;
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonMnemonic() != 0) {
            return jFileChooser.getApproveButtonMnemonic();
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return this.openButtonMnemonic;
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        if (jFileChooser.getApproveButtonText() != null) {
            return jFileChooser.getApproveButtonText();
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return this.openButtonText;
    }

    public Action getNewFolderAction() {
        return new NewFolderAction(this);
    }

    public Action getGoHomeAction() {
        return new GoHomeAction(this);
    }

    public Action getChangeToParentDirectoryAction() {
        return new ChangeToParentDirectoryAction(this);
    }

    public Action getApproveSelectionAction() {
        return new ApproveSelectionAction(this);
    }

    public Action getCancelSelectionAction() {
        return new CancelSelectionAction(this);
    }

    public Action getUpdateAction() {
        return new UpdateAction(this);
    }

    private class ListLabelRenderer
    extends JLabel
    implements ListCellRenderer {
        private /* synthetic */ BasicFileChooserUI this$0;
        final Color selected;

        private /* synthetic */ void finit$() {
            this.selected = new Color(153, 204, 255);
        }

        public ListLabelRenderer(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
            this.finit$();
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setHorizontalAlignment(2);
            File file = (File)object;
            this.setText(this.this$0.filechooser.getName(file));
            this.setIcon(this.this$0.filechooser.getIcon(file));
            this.setBackground(bl ? this.selected : Color.WHITE);
            this.setForeground(Color.BLACK);
            return this;
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        private /* synthetic */ BasicFileChooserUI this$0;

        protected UpdateAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        private /* synthetic */ BasicFileChooserUI this$0;

        protected SelectionListener(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object = this.this$0.filelist.getSelectedValue();
            if (object == null) {
                return;
            }
            File file = this.this$0.filechooser.getFileSystemView().createFileObject(object.toString());
            if (!this.this$0.filechooser.isTraversable(file)) {
                this.this$0.filechooser.setSelectedFile(file);
            } else {
                this.this$0.filechooser.setSelectedFile(null);
            }
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        private /* synthetic */ BasicFileChooserUI this$0;

        protected NewFolderAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.this$0.filechooser.getFileSystemView().createNewFolder(this.this$0.filechooser.getCurrentDirectory());
            }
            catch (IOException iOException) {
                return;
            }
            this.this$0.filechooser.rescanCurrentDirectory();
            this.this$0.filechooser.repaint();
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        private /* synthetic */ BasicFileChooserUI this$0;

        protected GoHomeAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.filechooser.setCurrentDirectory(this.this$0.filechooser.getFileSystemView().getHomeDirectory());
            this.this$0.filechooser.revalidate();
            this.this$0.filechooser.repaint();
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        private /* synthetic */ BasicFileChooserUI this$0;
        private Timer timer;
        private Object lastSelected;
        private JList list;

        private /* synthetic */ void finit$() {
            this.timer = null;
            this.lastSelected = null;
            this.list = null;
        }

        public DoubleClickListener(BasicFileChooserUI basicFileChooserUI, JList jList) {
            this.this$0 = basicFileChooserUI;
            this.finit$();
            this.list = jList;
            this.timer = new Timer(1000, null);
            this.timer.setRepeats(false);
            this.lastSelected = jList.getSelectedValue();
            basicFileChooserUI.setDirectorySelected(false);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.list.getSelectedValue() == null) {
                return;
            }
            FileSystemView fileSystemView = this.this$0.filechooser.getFileSystemView();
            if (this.timer.isRunning() && this.list.getSelectedValue().toString().equals(this.lastSelected.toString())) {
                File file = fileSystemView.createFileObject(this.lastSelected.toString());
                this.timer.stop();
                if (this.this$0.filechooser.isTraversable(file)) {
                    this.this$0.filechooser.setCurrentDirectory(file);
                    this.this$0.filechooser.rescanCurrentDirectory();
                } else {
                    this.this$0.filechooser.setSelectedFile(file);
                    this.this$0.filechooser.approveSelection();
                    this.this$0.closeDialog();
                }
            } else {
                String string = this.list.getSelectedValue().toString();
                File file = fileSystemView.createFileObject(string);
                if (this.this$0.filechooser.isTraversable(file)) {
                    this.this$0.setDirectorySelected(true);
                    this.this$0.setDirectory(file);
                } else {
                    this.this$0.setDirectorySelected(false);
                    this.this$0.setDirectory(null);
                }
                this.lastSelected = string;
                this.this$0.parentPath = string.substring(0, string.lastIndexOf("/") + 1);
                this.this$0.entry.setText(string.substring(string.lastIndexOf("/") + 1));
                this.timer.restart();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        private /* synthetic */ BasicFileChooserUI this$0;

        protected ChangeToParentDirectoryAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.filechooser.changeToParentDirectory();
            this.this$0.filechooser.revalidate();
            this.this$0.filechooser.repaint();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        private /* synthetic */ BasicFileChooserUI this$0;

        protected CancelSelectionAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.filechooser.cancelSelection();
            this.this$0.closeDialog();
        }
    }

    protected class BasicFileView
    extends FileView {
        private /* synthetic */ BasicFileChooserUI this$0;
        protected Hashtable iconCache;

        private /* synthetic */ void finit$() {
            this.iconCache = new Hashtable();
        }

        public BasicFileView(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
            this.finit$();
        }

        public void cacheIcon(File file, Icon icon) {
            this.iconCache.put(file, icon);
        }

        public void clearIconCache() {
            this.iconCache.clear();
        }

        public Icon getCachedIcon(File file) {
            return (Icon)this.iconCache.get(file);
        }

        public String getDescription(File file) {
            return this.getName(file);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = this.this$0.filechooser.isTraversable(file) ? this.this$0.directoryIcon : this.this$0.fileIcon;
            this.cacheIcon(file, icon);
            return icon;
        }

        public String getName(File file) {
            return file.getName();
        }

        public String getTypeDescription(File file) {
            if (this.this$0.filechooser.isTraversable(file)) {
                return this.this$0.dirDescText;
            }
            return this.this$0.fileDescText;
        }

        public Boolean isHidden(File file) {
            return this.this$0.filechooser.getFileSystemView().isHiddenFile(file);
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        private /* synthetic */ BasicFileChooserUI this$0;

        protected ApproveSelectionAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = new String(this.this$0.parentPath + this.this$0.entry.getText());
            if (string != null) {
                File file = this.this$0.filechooser.getFileSystemView().createFileObject(string.toString());
                if (this.this$0.filechooser.isTraversable(file) && this.this$0.filechooser.isDirectorySelectionEnabled()) {
                    this.this$0.filechooser.setCurrentDirectory(file);
                } else {
                    this.this$0.filechooser.setSelectedFile(file);
                    this.this$0.filechooser.approveSelection();
                    this.this$0.closeDialog();
                }
            }
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        private /* synthetic */ BasicFileChooserUI this$0;

        public AcceptAllFileFilter(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }

        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return this.this$0.acceptAllFileFilterText;
        }
    }
}

