/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private Vector contents;
    private int directories;
    private int listingMode;
    private JFileChooser filechooser;
    private Comparator comparator;

    private /* synthetic */ void finit$() {
        this.comparator = new Comparator(this){
            private /* synthetic */ BasicDirectoryModel this$0;
            {
                this.this$0 = basicDirectoryModel;
            }

            public int compare(Object object, Object object2) {
                if (this.this$0.lt((File)object, (File)object2)) {
                    return -1;
                }
                return 1;
            }
        };
    }

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.finit$();
        this.filechooser = jFileChooser;
        jFileChooser.addPropertyChangeListener(this);
        this.listingMode = jFileChooser.getFileSelectionMode();
        this.contents = new Vector();
    }

    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public Vector getDirectories() {
        Vector vector = new Vector();
        for (int i = 0; i < this.directories; ++i) {
            vector.add(this.contents.get(i));
        }
        return vector;
    }

    public Object getElementAt(int n) {
        if (n > this.getSize() - 1) {
            return null;
        }
        if (this.listingMode == 0) {
            return this.contents.get(this.directories + n);
        }
        return this.contents.elementAt(n);
    }

    public Vector getFiles() {
        Vector vector = new Vector();
        for (int i = this.directories; i < this.getSize(); ++i) {
            vector.add(this.contents.get(i));
        }
        return vector;
    }

    public int getSize() {
        if (this.listingMode == 1) {
            return this.directories;
        }
        if (this.listingMode == 0) {
            return this.contents.size() - this.directories;
        }
        return this.contents.size();
    }

    public int indexOf(Object object) {
        if (this.listingMode == 0) {
            return this.contents.indexOf(object) - this.directories;
        }
        return this.contents.indexOf(object);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void invalidateFileCache() {
    }

    protected boolean lt(File file, File file2) {
        boolean bl;
        boolean bl2 = this.filechooser.isTraversable(file);
        if (bl2 == (bl = this.filechooser.isTraversable(file2))) {
            String string;
            String string2 = file.getName().toLowerCase();
            return string2.compareTo(string = file2.getName().toLowerCase()) < 0;
        }
        return bl2;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("fileSelectionChanged")) {
            this.listingMode = this.filechooser.getFileSelectionMode();
        }
    }

    public boolean renameFile(File file, File file2) {
        return false;
    }

    protected void sort(Vector vector) {
        Collections.sort(vector, this.comparator);
        Enumeration enumeration = Collections.enumeration(vector);
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            vector2.add(enumeration.nextElement());
        }
        this.contents = vector2;
    }

    public void validateFileCache() {
        this.contents.clear();
        this.directories = 0;
        FileSystemView fileSystemView = this.filechooser.getFileSystemView();
        File[] fileArray = fileSystemView.getFiles(this.filechooser.getCurrentDirectory(), this.filechooser.isFileHidingEnabled());
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == null || !this.filechooser.accept(fileArray[i])) continue;
            this.contents.add(fileArray[i]);
            if (!this.filechooser.isTraversable(fileArray[i])) continue;
            ++this.directories;
        }
        this.sort(this.contents);
        this.filechooser.revalidate();
        this.filechooser.repaint();
    }
}

