/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboBoxUI
extends ComboBoxUI {
    protected JButton arrowButton;
    protected JComboBox comboBox;
    protected Component editor;
    protected FocusListener focusListener;
    protected boolean hasFocus;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    private MouseListener mouseListener;
    protected JList listBox;
    protected ListDataListener listDataListener;
    protected ComboPopup popup;
    protected KeyListener popupKeyListener;
    protected MouseListener popupMouseListener;
    protected MouseMotionListener popupMouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color buttonBackground;
    private Color buttonShadow;
    private Color buttonDarkShadow;
    private Color buttonHighlight;
    Dimension displaySize;
    protected Dimension cachedMinimumSize;
    protected CellRendererPane currentValuePane;
    protected boolean isMinimumSizeDirty;
    private static final Dimension MAXIMUM_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JComboBox) {
            this.comboBox = (JComboBox)jComponent;
            this.comboBox.setOpaque(true);
            this.comboBox.setLayout(this.createLayoutManager());
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.comboBox = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        this.buttonBackground = UIManager.getColor("ComboBox.buttonBackground");
        this.buttonShadow = UIManager.getColor("ComboBox.buttonShadow");
        this.buttonDarkShadow = UIManager.getColor("ComboBox.buttonDarkShadow");
        this.buttonHighlight = UIManager.getColor("ComboBox.buttonHighlight");
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.focusListener = this.createFocusListener();
        this.comboBox.addFocusListener(this.focusListener);
        this.listBox.addFocusListener(this.focusListener);
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.keyListener = this.createKeyListener();
        this.comboBox.addKeyListener(this.keyListener);
        this.mouseListener = this.createMouseListener();
        this.arrowButton.addMouseListener(this.mouseListener);
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void uninstallDefaults() {
        if (this.comboBox.getFont() instanceof UIResource) {
            this.comboBox.setFont(null);
        }
        if (this.comboBox.getForeground() instanceof UIResource) {
            this.comboBox.setForeground(null);
        }
        if (this.comboBox.getBackground() instanceof UIResource) {
            this.comboBox.setBackground(null);
        }
        this.buttonBackground = null;
        this.buttonShadow = null;
        this.buttonDarkShadow = null;
        this.buttonHighlight = null;
    }

    protected void uninstallListeners() {
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.comboBox.removeFocusListener(this.focusListener);
        this.listBox.removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removeKeyListener(this.keyListener);
        this.keyListener = null;
        this.arrowButton.removeMouseListener(this.mouseListener);
        this.mouseListener = null;
        this.comboBox.getModel().removeListDataListener(this.listDataListener);
        this.listDataListener = null;
    }

    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    private MouseListener createMouseListener() {
        return new MouseHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler(this);
    }

    protected ItemListener createItemListener() {
        return new ItemHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager(this);
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    protected void installComponents() {
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        this.comboBox.setRenderer(this.createRenderer());
        this.arrowButton = this.createArrowButton();
        this.configureArrowButton();
        this.comboBox.add(this.arrowButton);
        ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
        if (comboBoxEditor == null || comboBoxEditor instanceof UIResource) {
            comboBoxEditor = this.createEditor();
            this.comboBox.setEditor(comboBoxEditor);
        }
        this.editor = comboBoxEditor.getEditorComponent();
        this.comboBox.revalidate();
    }

    protected void uninstallComponents() {
        this.unconfigureArrowButton();
        this.comboBox.remove(this.arrowButton);
        this.arrowButton = null;
        this.listBox = null;
        this.popup = null;
        this.comboBox.setRenderer(null);
        ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
        if (comboBoxEditor instanceof UIResource) {
            this.comboBox.setEditor(null);
            this.editor = null;
        }
    }

    public void addEditor() {
        this.comboBox.add(this.editor);
    }

    public void removeEditor() {
        this.comboBox.remove(this.editor);
    }

    protected void configureEditor() {
        this.editor.setFont(this.comboBox.getFont());
        this.comboBox.getEditor().setItem(this.comboBox.getSelectedItem());
    }

    protected void unconfigureEditor() {
    }

    public void configureArrowButton() {
        this.arrowButton.setEnabled(this.comboBox.isEnabled());
        this.arrowButton.setFont(this.comboBox.getFont());
    }

    public void unconfigureArrowButton() {
    }

    protected JButton createArrowButton() {
        return new BasicArrowButton(5, this.buttonBackground, this.buttonShadow, this.buttonDarkShadow, this.buttonHighlight);
    }

    public boolean isPopupVisible(JComboBox jComboBox) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox jComboBox, boolean bl) {
        if (bl) {
            this.popup.show();
            this.popup.getList().requestFocus();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return !this.comboBox.isEditable();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = this.rectangleForCurrentValue();
        this.paintCurrentValueBackground(graphics, rectangle, this.hasFocus);
        this.paintCurrentValue(graphics, rectangle, this.hasFocus);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getDisplaySize();
        int n = dimension.height;
        Dimension dimension2 = new Dimension(dimension.width + n, dimension.height);
        return dimension2;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return MAXIMUM_SIZE;
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        return 0;
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        return null;
    }

    protected boolean isNavigationKey(int n) {
        return false;
    }

    protected void selectNextPossibleValue() {
        int n = this.comboBox.getSelectedIndex();
        if (n != this.comboBox.getItemCount() - 1) {
            this.comboBox.setSelectedIndex(n + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.comboBox.getSelectedIndex();
        if (n != 0) {
            this.comboBox.setSelectedIndex(n - 1);
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible(this.comboBox, this.isPopupVisible(this.comboBox) ^ true);
    }

    protected Rectangle rectangleForCurrentValue() {
        Rectangle rectangle = SwingUtilities.getLocalBounds(this.comboBox);
        Rectangle rectangle2 = this.arrowButton.getBounds();
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width - rectangle2.width, rectangle.height);
        return rectangle3;
    }

    protected Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        if (!this.comboBox.isEditable()) {
            Object object = this.comboBox.getSelectedItem();
            boolean bl2 = this.arrowButton.getModel().isPressed();
            Component component = this.comboBox.getRenderer().getListCellRendererComponent(this.listBox, object != null ? object : "", -1, bl2, bl);
            if (!this.comboBox.isEnabled()) {
                component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                component.setEnabled(false);
            }
            component.setBounds(0, 0, rectangle.width, rectangle.height);
            component.setFont(this.comboBox.getFont());
            component.paint(graphics);
            this.comboBox.revalidate();
        } else {
            this.comboBox.getEditor().setItem(this.comboBox.getSelectedItem());
        }
    }

    public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
    }

    protected Dimension getDefaultSize() {
        FontMetrics fontMetrics = this.comboBox.getFontMetrics(this.comboBox.getFont());
        int n = fontMetrics.charWidth(' ') + 2;
        int n2 = fontMetrics.getHeight() + 2;
        return new Dimension(n, n2);
    }

    protected Dimension getDisplaySize() {
        if (!this.comboBox.isEditable()) {
            Object object = this.comboBox.getPrototypeDisplayValue();
            if (object != null) {
                ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, object, -1, false, false);
                Dimension dimension = component.getPreferredSize();
                dimension.width += 2;
                dimension.height += 2;
                return dimension;
            }
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            int n = comboBoxModel.getSize();
            if (n == 0) {
                this.displaySize = this.getDefaultSize();
                return this.displaySize;
            }
            Dimension dimension = new Dimension(0, 0);
            ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
            for (int i = 0; i < n; ++i) {
                Object object2 = comboBoxModel.getElementAt(i);
                Component component = listCellRenderer.getListCellRendererComponent(this.listBox, object2, -1, false, false);
                Dimension dimension2 = component.getPreferredSize();
                if (dimension2.width + 2 > dimension.width) {
                    dimension.width = dimension2.width + 2;
                }
                if (dimension2.height + 2 <= dimension.height) continue;
                dimension.height = dimension2.height + 2;
            }
            this.displaySize = dimension;
            return this.displaySize;
        }
        Component component = this.comboBox.getEditor().getEditorComponent();
        Dimension dimension = component.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height + 2;
        Object object = this.comboBox.getPrototypeDisplayValue();
        if (object != null) {
            FontMetrics fontMetrics = this.comboBox.getFontMetrics(this.comboBox.getFont());
            n = Math.max(n, fontMetrics.stringWidth(object.toString()) + 2);
        }
        this.displaySize = new Dimension(n, n2);
        return this.displaySize;
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    private class MouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboBoxUI this$0;

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.comboBox.isEnabled()) {
                this.this$0.toggleOpenClose();
            }
        }

        MouseHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public PropertyChangeHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                this.this$0.arrowButton.setEnabled(this.this$0.comboBox.isEnabled());
                if (this.this$0.comboBox.isEditable()) {
                    this.this$0.comboBox.getEditor().getEditorComponent().setEnabled(this.this$0.comboBox.isEnabled());
                }
            } else if (propertyChangeEvent.getPropertyName().equals("editable")) {
                if (this.this$0.comboBox.isEditable()) {
                    this.this$0.configureEditor();
                    this.this$0.addEditor();
                } else {
                    this.this$0.unconfigureEditor();
                    this.this$0.removeEditor();
                }
                this.this$0.comboBox.revalidate();
                this.this$0.comboBox.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("dataModel")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getOldValue();
                if (comboBoxModel != null) {
                    comboBoxModel.removeListDataListener(this.this$0.listDataListener);
                }
                if ((ComboBoxModel)propertyChangeEvent.getNewValue() != null) {
                    this.this$0.comboBox.getModel().addListDataListener(this.this$0.listDataListener);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("font")) {
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.this$0.editor.setFont(font);
                this.this$0.listBox.setFont(font);
                this.this$0.arrowButton.setFont(font);
                this.this$0.comboBox.revalidate();
                this.this$0.comboBox.repaint();
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ListDataHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ComboBoxModel comboBoxModel = this.this$0.comboBox.getModel();
            ListCellRenderer listCellRenderer = this.this$0.comboBox.getRenderer();
            if (this.this$0.displaySize == null) {
                this.this$0.displaySize = this.this$0.getDisplaySize();
            }
            if (this.this$0.displaySize.width < this.this$0.getDefaultSize().width) {
                this.this$0.displaySize.width = this.this$0.getDefaultSize().width;
            }
            if (this.this$0.displaySize.height < this.this$0.getDefaultSize().height) {
                this.this$0.displaySize.height = this.this$0.getDefaultSize().height;
            }
            this.this$0.comboBox.repaint();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.this$0.displaySize = this.this$0.getDisplaySize();
            this.this$0.comboBox.repaint();
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicComboBoxUI this$0;

        public KeyHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void keyPressed(KeyEvent keyEvent) {
        }
    }

    public class ItemHandler
    implements ItemListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ItemHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && this.this$0.comboBox.isEditable()) {
                this.this$0.comboBox.getEditor().setItem(itemEvent.getItem());
            }
            this.this$0.comboBox.repaint();
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicComboBoxUI this$0;

        public FocusHandler(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.this$0.hasFocus = true;
            this.this$0.comboBox.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.this$0.hasFocus = false;
            this.this$0.setPopupVisible(this.this$0.comboBox, false);
            this.this$0.comboBox.repaint();
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        private /* synthetic */ BasicComboBoxUI this$0;

        public ComboBoxLayoutManager(BasicComboBoxUI basicComboBoxUI) {
            this.this$0 = basicComboBoxUI;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.this$0.getPreferredSize((JComponent)container);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = this.this$0.comboBox.getHeight();
            int n2 = this.this$0.comboBox.getBounds().width - n;
            if (this.this$0.comboBox.isEditable()) {
                this.this$0.editor.setBounds(0, 0, n2, this.this$0.comboBox.getBounds().height);
            }
            this.this$0.arrowButton.setBounds(n2, 0, n, n);
            this.this$0.comboBox.revalidate();
        }
    }
}

