/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;

public class BasicColorChooserUI
extends ColorChooserUI {
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    JColorChooser chooser;
    JTabbedPane pane;
    private Container prevContainer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        return ColorChooserComponentFactory.getDefaultChooserPanels();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JColorChooser) {
            this.chooser = (JColorChooser)jComponent;
            this.chooser.setLayout(new BorderLayout());
            this.defaultChoosers = this.createDefaultChoosers();
            this.chooser.setChooserPanels(this.defaultChoosers);
            this.pane = new JTabbedPane();
            this.pane.addChangeListener(new ChangeListener(this){
                private /* synthetic */ BasicColorChooserUI this$0;
                {
                    this.this$0 = basicColorChooserUI;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    this.this$0.pane.repaint();
                }
            });
            this.makeTabs(this.defaultChoosers);
            this.chooser.add((Component)this.pane, "North");
            this.installPreviewPanel();
            this.installDefaults();
            this.installListeners();
        }
    }

    void makeTabs(AbstractColorChooserPanel[] abstractColorChooserPanelArray) {
        this.pane.removeAll();
        for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
            this.pane.addTab(abstractColorChooserPanelArray[i].getDisplayName(), abstractColorChooserPanelArray[i].getSmallDisplayIcon(), abstractColorChooserPanelArray[i]);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallDefaultChoosers();
        this.pane = null;
        this.chooser = null;
    }

    protected void uninstallDefaultChoosers() {
        this.defaultChoosers = null;
    }

    protected void installPreviewPanel() {
        this.updatePreviewPanel(ColorChooserComponentFactory.getPreviewPanel());
    }

    void updatePreviewPanel(JComponent jComponent) {
        if (this.prevContainer == null) {
            this.prevContainer = new JPanel();
            this.prevContainer.setLayout(new BorderLayout());
            this.chooser.add((Component)this.prevContainer, "Center");
        }
        this.prevContainer.removeAll();
        this.prevContainer.add((Component)jComponent, "Center");
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void uninstallDefaults() {
        this.chooser.setBackground(null);
        this.chooser.setForeground(null);
        this.chooser.setFont(null);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.previewListener = new PreviewListener(this);
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
        this.pane.addChangeListener(new TabPaneListener(this));
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler(this);
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewListener = null;
        this.propertyChangeListener = null;
    }

    private class TabPaneListener
    implements ChangeListener {
        private /* synthetic */ BasicColorChooserUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractColorChooserPanel abstractColorChooserPanel = (AbstractColorChooserPanel)this.this$0.pane.getSelectedComponent();
            abstractColorChooserPanel.updateChooser();
        }

        TabPaneListener(BasicColorChooserUI basicColorChooserUI) {
            this.this$0 = basicColorChooserUI;
        }
    }

    private class PreviewListener
    implements ChangeListener {
        private /* synthetic */ BasicColorChooserUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractColorChooserPanel abstractColorChooserPanel;
            if (this.this$0.pane != null && (abstractColorChooserPanel = (AbstractColorChooserPanel)this.this$0.pane.getSelectedComponent()) != null) {
                abstractColorChooserPanel.updateChooser();
            }
            this.this$0.chooser.repaint();
        }

        PreviewListener(BasicColorChooserUI basicColorChooserUI) {
            this.this$0 = basicColorChooserUI;
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicColorChooserUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "chooserPanels") {
                this.this$0.makeTabs(this.this$0.chooser.getChooserPanels());
            } else if (propertyChangeEvent.getPropertyName() == "previewPanel") {
                this.this$0.updatePreviewPanel(this.this$0.chooser.getPreviewPanel());
            } else if (propertyChangeEvent.getPropertyName() == "selectionModel") {
                ((AbstractColorChooserPanel)this.this$0.pane.getSelectedComponent()).updateChooser();
            }
            this.this$0.chooser.repaint();
        }

        public PropertyHandler(BasicColorChooserUI basicColorChooserUI) {
            this.this$0 = basicColorChooserUI;
        }
    }
}

