/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;

public final class SwingPropertyChangeSupport
extends PropertyChangeSupport {
    private static final long serialVersionUID = 7162625831330845068L;
    private transient EventListenerList listeners;
    private Hashtable propertyListeners;
    private Object source;

    public SwingPropertyChangeSupport(Object object) {
        super(object);
        this.source = object;
        this.listeners = new EventListenerList();
        this.propertyListeners = new Hashtable();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), propertyChangeListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        EventListenerList eventListenerList = (EventListenerList)this.propertyListeners.get(string);
        if (eventListenerList == null) {
            eventListenerList = new EventListenerList();
            this.propertyListeners.put(string, eventListenerList);
        }
        eventListenerList.add(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        EventListenerList eventListenerList = (EventListenerList)this.propertyListeners.get(string);
        if (eventListenerList == null) {
            return;
        }
        eventListenerList.remove(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"), propertyChangeListener);
        if (eventListenerList.getListenerCount() == 0) {
            this.propertyListeners.remove(string);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        int n;
        Object[] objectArray;
        PropertyChangeListener[] propertyChangeListenerArray;
        ArrayList arrayList = new ArrayList();
        Set set = this.propertyListeners.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            propertyChangeListenerArray = (PropertyChangeListener[])entry.getKey();
            objectArray = (Object[])entry.getValue();
            if (objectArray == null) continue;
            Object[] objectArray2 = objectArray.getListenerList();
            for (n = 0; n < objectArray2.length; n += 2) {
                arrayList.add(new PropertyChangeListenerProxy((String)propertyChangeListenerArray, (PropertyChangeListener)objectArray2[n + 1]));
            }
        }
        int n2 = this.listeners.getListenerCount() + arrayList.size();
        propertyChangeListenerArray = new PropertyChangeListener[n2];
        objectArray = this.listeners.getListenerList();
        int n3 = 0;
        for (n = 0; n < objectArray.length; n += 2) {
            propertyChangeListenerArray[n3++] = (PropertyChangeListener)objectArray[n + 1];
        }
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            propertyChangeListenerArray[n3++] = (PropertyChangeListenerProxy)iterator2.next();
        }
        return propertyChangeListenerArray;
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        EventListenerList eventListenerList = (EventListenerList)this.propertyListeners.get(string);
        if (eventListenerList == null) {
            return this.getPropertyChangeListeners();
        }
        int n = this.listeners.getListenerCount() + eventListenerList.getListenerCount();
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[n];
        int n2 = 0;
        for (int i = 0; i < this.listeners.listenerList.length; i += 2) {
            propertyChangeListenerArray[n2++] = (PropertyChangeListener)this.listeners.listenerList[i + 1];
        }
        Object[] objectArray = eventListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            propertyChangeListenerArray[n2++] = (PropertyChangeListener)objectArray[i + 1];
        }
        return propertyChangeListenerArray;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.source, string, object, object2);
        this.firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener;
        int n;
        if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) {
            return;
        }
        EventListener[] eventListenerArray = this.listeners.getListeners(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"));
        for (n = 0; n < eventListenerArray.length; ++n) {
            propertyChangeListener = (PropertyChangeListener)eventListenerArray[n];
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
        EventListenerList eventListenerList = (EventListenerList)this.propertyListeners.get(propertyChangeEvent.getPropertyName());
        if (eventListenerList != null) {
            eventListenerArray = eventListenerList.getListeners(SwingPropertyChangeSupport.class$("java.beans.PropertyChangeListener"));
            for (n = 0; n < eventListenerArray.length; ++n) {
                propertyChangeListener = (PropertyChangeListener)eventListenerArray[n];
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    public synchronized boolean hasListeners(String string) {
        if (this.listeners.getListenerCount() > 0) {
            return true;
        }
        return this.propertyListeners.get(string) != null;
    }
}

