/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class ViewportLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -788225906076097229L;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        JViewport jViewport = (JViewport)container;
        Component component = jViewport.getView();
        if (component != null) {
            if (component instanceof Scrollable) {
                return ((Scrollable)((Object)component)).getPreferredScrollableViewportSize();
            }
            return component.getPreferredSize();
        }
        return new Dimension();
    }

    public Dimension minimumLayoutSize(Container container) {
        JViewport jViewport = (JViewport)container;
        Component component = jViewport.getView();
        if (component != null) {
            return component.getMinimumSize();
        }
        return new Dimension();
    }

    public void layoutContainer(Container container) {
        int n;
        JViewport jViewport = (JViewport)container;
        Component component = jViewport.getView();
        if (component == null) {
            return;
        }
        Rectangle rectangle = jViewport.getViewRect();
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component.getMinimumSize();
        Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (rectangle.height >= dimension2.height) {
            rectangle.y = 0;
            if (!(component instanceof Scrollable) || ((Scrollable)((Object)component)).getScrollableTracksViewportHeight()) {
                dimension.height = rectangle.height;
            }
        } else {
            dimension.height = dimension2.height;
            n = point.y - dimension.height;
            if (n > 0) {
                rectangle.y -= n;
            }
        }
        if (rectangle.width >= dimension2.width) {
            rectangle.x = 0;
            if (!(component instanceof Scrollable) || ((Scrollable)((Object)component)).getScrollableTracksViewportWidth()) {
                dimension.width = rectangle.width;
            }
        } else {
            dimension.width = dimension2.width;
            n = point.x - dimension.width;
            if (n > 0) {
                rectangle.x -= n;
            }
        }
        jViewport.setViewPosition(rectangle.getLocation());
        jViewport.setViewSize(dimension);
    }
}

