/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Spring;

public class SpringLayout
implements LayoutManager2 {
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String WEST = "West";
    private Map constraintsMap = new HashMap();

    public void addLayoutComponent(Component component, Object object) {
        this.constraintsMap.put(component, object);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Spring getConstraint(String string, Component component) {
        Constraints constraints = this.getConstraints(component);
        return constraints.getConstraint(string);
    }

    public Constraints getConstraints(Component component) {
        Constraints constraints = (Constraints)this.constraintsMap.get(component);
        if (constraints == null) {
            Container container = component.getParent();
            constraints = new Constraints();
            if (container != null) {
                constraints.setX(Spring.constant(container.getInsets().left));
                constraints.setY(Spring.constant(container.getInsets().top));
            } else {
                constraints.setX(Spring.constant(0));
                constraints.setY(Spring.constant(0));
            }
        }
        constraints.setWidth(Spring.constant(component.getMinimumSize().width, component.getPreferredSize().width, component.getMaximumSize().width));
        constraints.setHeight(Spring.constant(component.getMinimumSize().height, component.getPreferredSize().height, component.getMaximumSize().height));
        this.constraintsMap.put(component, constraints);
        return constraints;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        this.addLayoutComponent(container, new Constraints(Spring.constant(0), Spring.constant(0)));
        int n = container.getInsets().left;
        int n2 = container.getInsets().right;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            Constraints constraints = this.getConstraints(component);
            int n3 = constraints.getX().getValue();
            int n4 = constraints.getY().getValue();
            int n5 = constraints.getWidth().getValue();
            int n6 = constraints.getHeight().getValue();
            component.setLocation(n3 + n, n4 + n2);
            component.setSize(n5, n6);
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getInsets().left;
        int n4 = container.getInsets().right;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            int n5;
            Component component = componentArray[i];
            Constraints constraints = this.getConstraints(component);
            int n6 = constraints.getX().getMaximumValue();
            int n7 = constraints.getY().getMaximumValue();
            int n8 = constraints.getWidth().getMaximumValue();
            int n9 = constraints.getHeight().getMaximumValue();
            int n10 = n3 + n6 + n8;
            if (n10 > n) {
                n = n10;
            }
            if ((n5 = n4 + n7 + n9) <= n2) continue;
            n2 = n5;
        }
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getInsets().left;
        int n4 = container.getInsets().right;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            int n5;
            Component component = componentArray[i];
            Constraints constraints = this.getConstraints(component);
            int n6 = constraints.getX().getMinimumValue();
            int n7 = constraints.getY().getMinimumValue();
            int n8 = constraints.getWidth().getMinimumValue();
            int n9 = constraints.getHeight().getMinimumValue();
            int n10 = n3 + n6 + n8;
            if (n10 > n) {
                n = n10;
            }
            if ((n5 = n4 + n7 + n9) <= n2) continue;
            n2 = n5;
        }
        return new Dimension(n, n2);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getInsets().left;
        int n4 = container.getInsets().right;
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            int n5;
            Component component = componentArray[i];
            Constraints constraints = this.getConstraints(component);
            int n6 = constraints.getX().getPreferredValue();
            int n7 = constraints.getY().getPreferredValue();
            int n8 = constraints.getWidth().getPreferredValue();
            int n9 = constraints.getHeight().getPreferredValue();
            int n10 = n3 + n6 + n8;
            if (n10 > n) {
                n = n10;
            }
            if ((n5 = n4 + n7 + n9) <= n2) continue;
            n2 = n5;
        }
        return new Dimension(n, n2);
    }

    public void putConstraint(String string, Component component, int n, String string2, Component component2) {
        Constraints constraints = this.getConstraints(component);
        Constraints constraints2 = this.getConstraints(component2);
        Spring spring = Spring.constant(n);
        Spring spring2 = constraints2.getConstraint(string2);
        constraints.setConstraint(string, Spring.sum(spring, spring2));
    }

    public void putConstraint(String string, Component component, Spring spring, String string2, Component component2) {
        Constraints constraints = this.getConstraints(component);
        Constraints constraints2 = this.getConstraints(component2);
        Spring spring2 = constraints2.getConstraint(string2);
        constraints.setConstraint(string, Spring.sum(spring, spring2));
    }

    public void removeLayoutComponent(Component component) {
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring height;
        private Spring width;
        private Spring east;
        private Spring south;

        public Constraints() {
            this.south = null;
            this.east = null;
            this.width = null;
            this.height = null;
            this.y = null;
            this.x = null;
        }

        public Constraints(Spring spring, Spring spring2) {
            this.x = spring;
            this.y = spring2;
            this.south = null;
            this.east = null;
            this.height = null;
            this.width = null;
        }

        public Constraints(Spring spring, Spring spring2, Spring spring3, Spring spring4) {
            this.x = spring;
            this.y = spring2;
            this.width = spring3;
            this.height = spring4;
            this.south = null;
            this.east = null;
        }

        public Spring getConstraint(String string) {
            Spring spring = null;
            if (string.equals(SpringLayout.NORTH)) {
                spring = this.y;
            } else if (string.equals(SpringLayout.WEST)) {
                spring = this.x;
            } else if (string.equals(SpringLayout.SOUTH)) {
                spring = this.south;
                if (spring == null && this.y != null && this.height != null) {
                    spring = Spring.sum(this.y, this.height);
                }
            } else if (string.equals(SpringLayout.EAST) && (spring = this.east) == null && this.x != null && this.width != null) {
                spring = Spring.sum(this.x, this.width);
            }
            return spring;
        }

        public Spring getHeight() {
            Spring spring = this.height;
            if (spring == null && this.y != null && this.south != null) {
                spring = Spring.sum(this.south, Spring.minus(this.y));
            }
            return spring;
        }

        public Spring getWidth() {
            Spring spring = this.width;
            if (spring == null && this.x != null && this.east != null) {
                spring = Spring.sum(this.east, Spring.minus(this.x));
            }
            return spring;
        }

        public Spring getX() {
            Spring spring = this.x;
            if (spring == null && this.width != null && this.east != null) {
                spring = Spring.sum(this.east, Spring.minus(this.width));
            }
            return spring;
        }

        public Spring getY() {
            Spring spring = this.y;
            if (spring == null && this.height != null && this.south != null) {
                spring = Spring.sum(this.south, Spring.minus(this.height));
            }
            return spring;
        }

        public void setConstraint(String string, Spring spring) {
            if (string.equals(SpringLayout.WEST)) {
                this.x = spring;
                if (this.width != null && this.east != null) {
                    this.width = Spring.sum(this.east, Spring.minus(this.x));
                }
            } else if (string.equals(SpringLayout.NORTH)) {
                this.y = spring;
                if (this.height != null && this.south != null) {
                    this.height = Spring.sum(this.south, Spring.minus(this.y));
                }
            } else if (string.equals(SpringLayout.EAST)) {
                this.east = spring;
                if (this.x != null && this.width != null) {
                    this.x = Spring.sum(this.east, Spring.minus(this.width));
                }
            } else if (string.equals(SpringLayout.SOUTH)) {
                this.south = spring;
                if (this.height != null && this.y != null) {
                    this.y = Spring.sum(this.south, Spring.minus(this.height));
                }
            }
        }

        public void setHeight(Spring spring) {
            this.height = spring;
            if (this.south != null && this.y != null) {
                this.south = Spring.sum(this.y, this.height);
            }
        }

        public void setWidth(Spring spring) {
            this.width = spring;
            if (this.east != null && this.x != null) {
                this.east = Spring.sum(this.x, this.width);
            }
        }

        public void setX(Spring spring) {
            this.x = spring;
            if (this.width != null && this.east != null) {
                this.width = Spring.sum(this.east, Spring.minus(this.x));
            }
        }

        public void setY(Spring spring) {
            this.y = spring;
            if (this.height != null && this.south != null) {
                this.height = Spring.sum(this.south, Spring.minus(this.y));
            }
        }
    }
}

