/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;

public class JToolBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = -1269915519555129643L;
    private transient boolean paintBorder;
    private transient Insets margin;
    private transient boolean floatable;
    private transient boolean rollover;
    private int orientation;

    private /* synthetic */ void finit$() {
        this.paintBorder = true;
        this.floatable = true;
        this.orientation = 0;
    }

    public JToolBar() {
        this(null, 0);
    }

    public JToolBar(int n) {
        this(null, n);
    }

    public JToolBar(String string) {
        this(string, 0);
    }

    public JToolBar(String string, int n) {
        this.finit$();
        this.setName(string);
        this.setOrientation(n);
        this.setLayout(new DefaultToolBarLayout(this));
        this.revalidate();
        this.updateUI();
    }

    public JButton add(Action action) {
        JButton jButton = this.createActionComponent(action);
        this.add(jButton);
        return jButton;
    }

    protected void paintBorder(Graphics graphics) {
        if (this.paintBorder && this.isFloatable()) {
            super.paintBorder(graphics);
        }
    }

    public ToolBarUI getUI() {
        return (ToolBarUI)this.ui;
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
    }

    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
        this.revalidate();
        this.repaint();
    }

    public String getUIClassID() {
        return "ToolBarUI";
    }

    public void setRollover(boolean bl) {
        if (bl != this.rollover) {
            this.rollover = bl;
            this.firePropertyChange("rollover", this.rollover ^ true, this.rollover);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRollover() {
        return this.rollover;
    }

    public int getComponentIndex(Component component) {
        Component[] componentArray = this.getComponents();
        if (componentArray == null) {
            return -1;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] != component) continue;
            return i;
        }
        return -1;
    }

    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        if (this.margin != null && insets == null || this.margin == null && insets != null || insets != null && this.margin != null && (insets.left != this.margin.left || insets.right != this.margin.right || insets.top != this.margin.top || insets.bottom != this.margin.bottom)) {
            Insets insets2 = this.margin;
            this.margin = insets;
            this.firePropertyChange("margin", insets2, this.margin);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        if (bl != this.paintBorder) {
            this.paintBorder = bl;
            this.firePropertyChange("borderPainted", this.paintBorder ^ true, this.paintBorder);
            this.repaint();
        }
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public void setFloatable(boolean bl) {
        if (bl != this.floatable) {
            this.floatable = bl;
            this.firePropertyChange("floatable", bl ^ true, bl);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setLayout(LayoutManager layoutManager) {
        super.setLayout(layoutManager);
        this.revalidate();
        this.repaint();
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(n + " is not a legal orientation");
        }
        if (n != this.orientation) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange("orientation", n2, this.orientation);
            this.revalidate();
            this.repaint();
        }
    }

    public void addSeparator() {
        this.add(new Separator());
    }

    public void addSeparator(Dimension dimension) {
        this.add(new Separator(dimension));
    }

    protected JButton createActionComponent(Action action) {
        return new JButton(action);
    }

    protected PropertyChangeListener createActionChangeListener(JButton jButton) {
        return null;
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setRolloverEnabled(this.rollover);
        }
    }

    protected String paramString() {
        return "JToolBar";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToolBar(this);
        }
        return this.accessibleContext;
    }

    public static class Separator
    extends JSeparator {
        private static final long serialVersionUID = -1656745644823105219L;

        public Separator() {
        }

        public Separator(Dimension dimension) {
            this.setPreferredSize(dimension);
        }

        public String getUIClassID() {
            return "ToolBarSeparatorUI";
        }

        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }

        public Dimension getSeparatorSize() {
            return super.getPreferredSize();
        }

        public void setSeparatorSize(Dimension dimension) {
            this.setPreferredSize(dimension);
        }
    }

    private class DefaultToolBarLayout
    implements LayoutManager {
        private /* synthetic */ JToolBar this$0;

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (!(container instanceof JToolBar)) {
                throw new Error("DefaultToolBarLayout can only be used on JToolBars.");
            }
            Insets insets = this.this$0.getInsets();
            Insets insets2 = this.this$0.getMargin();
            if (insets2 != null) {
                insets.left += insets2.left;
                insets.top += insets2.top;
                insets.bottom += insets2.bottom;
                insets.right += insets2.right;
            }
            Component[] componentArray = container.getComponents();
            Dimension dimension = container.getSize();
            int n = 0;
            if (this.this$0.getOrientation() == 0) {
                n += insets.left;
                for (int i = 0; i < componentArray.length; ++i) {
                    Dimension dimension2;
                    if (componentArray[i] == null || !componentArray[i].isVisible() || (dimension2 = componentArray[i].getPreferredSize()) == null) continue;
                    int n2 = (dimension.height - dimension2.height) / 2;
                    componentArray[i].setBounds(n, n2, dimension2.width, dimension2.height);
                    n += dimension2.width;
                }
            } else {
                n += insets.top;
                for (int i = 0; i < componentArray.length; ++i) {
                    Dimension dimension3;
                    if (componentArray[i] == null || !componentArray[i].isVisible() || (dimension3 = componentArray[i].getPreferredSize()) == null) continue;
                    int n3 = (dimension.width - dimension3.width) / 2;
                    componentArray[i].setBounds(n3, n, dimension3.width, dimension3.height);
                    n += dimension3.height;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n;
            int n2 = this.this$0.getOrientation();
            Component[] componentArray = this.this$0.getComponents();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (n2 == 0) {
                for (n = 0; n < componentArray.length; ++n) {
                    Dimension dimension = componentArray[n].getPreferredSize();
                    if (dimension == null) continue;
                    if (dimension.height > n3) {
                        n3 = dimension.height;
                    }
                    n4 += dimension.width;
                }
                n5 = n4;
                n6 = n3;
            } else {
                for (n = 0; n < componentArray.length; ++n) {
                    Dimension dimension = componentArray[n].getPreferredSize();
                    if (dimension == null) continue;
                    if (dimension.width > n3) {
                        n3 = dimension.width;
                    }
                    n4 += dimension.height;
                }
                n5 = n3;
                n6 = n4;
            }
            Insets insets = this.this$0.getInsets();
            n5 += insets.left + insets.right;
            n6 += insets.top + insets.bottom;
            Insets insets2 = this.this$0.getMargin();
            if (insets2 != null) {
                n5 += insets2.left + insets2.right;
                n6 += insets2.top + insets2.bottom;
            }
            return new Dimension(n5, n6);
        }

        public void removeLayoutComponent(Component component) {
        }

        DefaultToolBarLayout(JToolBar jToolBar) {
            this.this$0 = jToolBar;
        }
    }

    protected class AccessibleJToolBar
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JToolBar this$0;
        private static final long serialVersionUID = -5516888265903814215L;

        protected AccessibleJToolBar(JToolBar jToolBar) {
            this.this$0 = jToolBar;
            super(jToolBar);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }
    }
}

