/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;

public class JScrollPane
extends JComponent
implements Accessible,
ScrollPaneConstants {
    private static final long serialVersionUID = 5203525440012340014L;
    protected JViewport columnHeader;
    protected JViewport rowHeader;
    protected Component lowerLeft;
    protected Component lowerRight;
    protected Component upperLeft;
    protected Component upperRight;
    protected JScrollBar horizontalScrollBar;
    protected int horizontalScrollBarPolicy;
    protected JScrollBar verticalScrollBar;
    protected int verticalScrollBarPolicy;
    protected JViewport viewport;
    Border viewportBorder;
    boolean wheelScrollingEnabled;

    public JViewport getColumnHeader() {
        return this.columnHeader;
    }

    public Component getCorner(String string) {
        if (this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            if (string == "LOWER_LEADING_CORNER") {
                string = "LOWER_LEFT_CORNER";
            } else if (string == "LOWER_TRAILING_CORNER") {
                string = "LOWER_RIGHT_CORNER";
            } else if (string == "UPPER_LEADING_CORNER") {
                string = "UPPER_LEFT_CORNER";
            } else if (string == "UPPER_TRAILING_CORNER") {
                string = "UPPER_RIGHT_CORNER";
            }
        } else if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            if (string == "LOWER_LEADING_CORNER") {
                string = "LOWER_RIGHT_CORNER";
            } else if (string == "LOWER_TRAILING_CORNER") {
                string = "LOWER_LEFT_CORNER";
            } else if (string == "UPPER_LEADING_CORNER") {
                string = "UPPER_RIGHT_CORNER";
            } else if (string == "UPPER_TRAILING_CORNER") {
                string = "UPPER_LEFT_CORNER";
            }
        }
        if (string == "LOWER_RIGHT_CORNER") {
            return this.lowerRight;
        }
        if (string == "UPPER_RIGHT_CORNER") {
            return this.upperRight;
        }
        if (string == "LOWER_LEFT_CORNER") {
            return this.lowerLeft;
        }
        if (string == "UPPER_LEFT_CORNER") {
            return this.upperLeft;
        }
        return null;
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.horizontalScrollBar;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.horizontalScrollBarPolicy;
    }

    public JViewport getRowHeader() {
        return this.rowHeader;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verticalScrollBar;
    }

    public int getVerticalScrollBarPolicy() {
        return this.verticalScrollBarPolicy;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public Border getViewportBorder() {
        return this.viewportBorder;
    }

    public Rectangle getViewportBorderBounds() {
        if (this.viewportBorder == null) {
            if (this.getViewport() == null) {
                return new Rectangle(0, 0, 0, 0);
            }
            return this.getViewport().getBounds();
        }
        Insets insets = this.viewportBorder.getBorderInsets(this.getViewport());
        if (this.getViewport() == null) {
            return new Rectangle(0, 0, insets.left + insets.right, insets.top + insets.bottom);
        }
        Rectangle rectangle = this.getViewport().getBounds();
        return new Rectangle(rectangle.x - insets.left, rectangle.y - insets.top, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
    }

    public boolean isWheelScrollingEnabled() {
        return this.wheelScrollingEnabled;
    }

    private void sync() {
        LayoutManager layoutManager = super.getLayout();
        if (layoutManager != null && layoutManager instanceof ScrollPaneLayout) {
            ScrollPaneLayout scrollPaneLayout = (ScrollPaneLayout)layoutManager;
            scrollPaneLayout.syncWithScrollPane(this);
        }
    }

    private void removeNonNull(Component component) {
        if (component != null) {
            this.remove(component);
        }
    }

    private void addNonNull(Component component, Object object) {
        if (component != null) {
            this.add(component, object);
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2 = super.getComponentOrientation();
        super.setComponentOrientation(componentOrientation);
        this.firePropertyChange("componentOrientation", componentOrientation2, componentOrientation);
        this.sync();
    }

    public void setColumnHeader(JViewport jViewport) {
        if (this.columnHeader == jViewport) {
            return;
        }
        JViewport jViewport2 = this.columnHeader;
        this.removeNonNull(jViewport2);
        this.columnHeader = jViewport;
        this.addNonNull(jViewport, "COLUMN_HEADER");
        this.firePropertyChange("columnHeader", jViewport2, jViewport);
        this.sync();
    }

    public void setColumnHeaderView(Component component) {
        if (this.columnHeader == null) {
            this.setColumnHeader(this.createViewport());
        }
        this.columnHeader.setView(component);
        this.sync();
    }

    public void setCorner(String string, Component component) {
        if (this.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            if (string == "LOWER_LEADING_CORNER") {
                string = "LOWER_LEFT_CORNER";
            } else if (string == "LOWER_TRAILING_CORNER") {
                string = "LOWER_RIGHT_CORNER";
            } else if (string == "UPPER_LEADING_CORNER") {
                string = "UPPER_LEFT_CORNER";
            } else if (string == "UPPER_TRAILING_CORNER") {
                string = "UPPER_RIGHT_CORNER";
            }
        } else if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            if (string == "LOWER_LEADING_CORNER") {
                string = "LOWER_RIGHT_CORNER";
            } else if (string == "LOWER_TRAILING_CORNER") {
                string = "LOWER_LEFT_CORNER";
            } else if (string == "UPPER_LEADING_CORNER") {
                string = "UPPER_RIGHT_CORNER";
            } else if (string == "UPPER_TRAILING_CORNER") {
                string = "UPPER_LEFT_CORNER";
            }
        }
        if (string == "LOWER_RIGHT_CORNER") {
            this.removeNonNull(this.lowerRight);
            this.lowerRight = component;
            this.addNonNull(component, "LOWER_RIGHT_CORNER");
        } else if (string == "UPPER_RIGHT_CORNER") {
            this.removeNonNull(this.upperRight);
            this.upperRight = component;
            this.addNonNull(component, "UPPER_RIGHT_CORNER");
        } else if (string == "LOWER_LEFT_CORNER") {
            this.removeNonNull(this.lowerLeft);
            this.lowerLeft = component;
            this.addNonNull(component, "LOWER_LEFT_CORNER");
        } else if (string == "UPPER_LEFT_CORNER") {
            this.removeNonNull(this.upperLeft);
            this.upperLeft = component;
            this.addNonNull(component, "UPPER_LEFT_CORNER");
        } else {
            throw new IllegalArgumentException("unknown corner " + string);
        }
        this.sync();
    }

    public void setHorizontalScrollBar(JScrollBar jScrollBar) {
        if (this.horizontalScrollBar == jScrollBar) {
            return;
        }
        JScrollBar jScrollBar2 = this.horizontalScrollBar;
        this.removeNonNull(jScrollBar2);
        this.horizontalScrollBar = jScrollBar;
        this.addNonNull(jScrollBar, "HORIZONTAL_SCROLLBAR");
        this.firePropertyChange("horizontalScrollBar", jScrollBar2, jScrollBar);
        this.sync();
    }

    public void setHorizontalScrollBarPolicy(int n) {
        if (this.horizontalScrollBarPolicy == n) {
            return;
        }
        if (n != 30 && n != 31 && n != 32) {
            throw new IllegalArgumentException("unknown horizontal scrollbar policy");
        }
        int n2 = this.horizontalScrollBarPolicy;
        this.horizontalScrollBarPolicy = n;
        this.firePropertyChange("horizontalScrollBarPolicy", n2, n);
        this.sync();
        this.revalidate();
    }

    public void setLayout(LayoutManager layoutManager) {
        LayoutManager layoutManager2 = super.getLayout();
        ScrollPaneLayout scrollPaneLayout = (ScrollPaneLayout)layoutManager;
        super.setLayout(layoutManager);
        scrollPaneLayout.syncWithScrollPane(this);
        this.firePropertyChange("layout", layoutManager2, layoutManager);
        this.sync();
    }

    public void setRowHeader(JViewport jViewport) {
        if (this.rowHeader == jViewport) {
            return;
        }
        JViewport jViewport2 = this.rowHeader;
        this.removeNonNull(jViewport2);
        this.rowHeader = jViewport;
        this.addNonNull(jViewport, "ROW_HEADER");
        this.firePropertyChange("rowHeader", jViewport2, jViewport);
        this.sync();
    }

    public void setRowHeaderView(Component component) {
        if (this.rowHeader == null) {
            this.setRowHeader(this.createViewport());
        }
        this.rowHeader.setView(component);
        this.sync();
    }

    public void setVerticalScrollBar(JScrollBar jScrollBar) {
        if (this.verticalScrollBar == jScrollBar) {
            return;
        }
        JScrollBar jScrollBar2 = this.verticalScrollBar;
        this.removeNonNull(jScrollBar2);
        this.verticalScrollBar = jScrollBar;
        this.addNonNull(jScrollBar, "VERTICAL_SCROLLBAR");
        this.firePropertyChange("verticalScrollBar", jScrollBar2, jScrollBar);
        this.sync();
    }

    public void setVerticalScrollBarPolicy(int n) {
        if (this.verticalScrollBarPolicy == n) {
            return;
        }
        if (n != 20 && n != 21 && n != 22) {
            throw new IllegalArgumentException("unknown vertical scrollbar policy");
        }
        int n2 = this.verticalScrollBarPolicy;
        this.verticalScrollBarPolicy = n;
        this.firePropertyChange("verticalScrollBarPolicy", n2, n);
        this.sync();
        this.revalidate();
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (this.wheelScrollingEnabled == bl) {
            return;
        }
        boolean bl2 = this.wheelScrollingEnabled;
        this.wheelScrollingEnabled = bl;
        this.firePropertyChange("wheelScrollingEnabled", bl2, bl);
        this.sync();
    }

    public void setViewport(JViewport jViewport) {
        if (this.viewport == jViewport) {
            return;
        }
        JViewport jViewport2 = this.viewport;
        this.removeNonNull(jViewport2);
        this.viewport = jViewport;
        this.addNonNull(jViewport, "VIEWPORT");
        this.revalidate();
        this.repaint();
        this.firePropertyChange("viewport", jViewport2, jViewport);
        this.sync();
        if (this.accessibleContext != null) {
            AccessibleJScrollPane accessibleJScrollPane = (AccessibleJScrollPane)this.accessibleContext;
            accessibleJScrollPane.resetViewPort();
        }
    }

    public void setViewportBorder(Border border) {
        if (this.viewportBorder == border) {
            return;
        }
        Border border2 = this.viewportBorder;
        this.viewportBorder = border;
        this.firePropertyChange("viewportBorder", border2, border);
        this.sync();
    }

    public void setViewportView(Component component) {
        if (this.getViewport() == null) {
            this.setViewport(this.createViewport());
        }
        if (component != null) {
            this.getViewport().setView(component);
        }
        this.sync();
    }

    public boolean isValidateRoot() {
        return true;
    }

    public JScrollPane() {
        this(null);
    }

    public JScrollPane(Component component) {
        this(component, 20, 30);
    }

    public JScrollPane(int n, int n2) {
        this(null, n, n2);
    }

    public JScrollPane(Component component, int n, int n2) {
        this.setVerticalScrollBarPolicy(n);
        this.setVerticalScrollBar(this.createVerticalScrollBar());
        this.setHorizontalScrollBarPolicy(n2);
        this.setHorizontalScrollBar(this.createHorizontalScrollBar());
        this.viewport = this.createViewport();
        if (component != null) {
            this.getViewport().setView(component);
        }
        this.add((Component)this.viewport, 0);
        this.setLayout(new ScrollPaneLayout());
        this.setOpaque(false);
        this.updateUI();
    }

    public JScrollBar createHorizontalScrollBar() {
        return new ScrollBar(this, 0);
    }

    public JScrollBar createVerticalScrollBar() {
        return new ScrollBar(this, 1);
    }

    protected JViewport createViewport() {
        return new JViewport();
    }

    public String getUIClassID() {
        return "ScrollPaneUI";
    }

    public void updateUI() {
        ScrollPaneUI scrollPaneUI = (ScrollPaneUI)UIManager.getUI(this);
        this.setUI(scrollPaneUI);
    }

    public ScrollPaneUI getUI() {
        return (ScrollPaneUI)this.ui;
    }

    public void setUI(ScrollPaneUI scrollPaneUI) {
        super.setUI(scrollPaneUI);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollPane(this);
        }
        return this.accessibleContext;
    }

    protected class ScrollBar
    extends JScrollBar
    implements UIResource {
        private /* synthetic */ JScrollPane this$0;
        private static final long serialVersionUID = -42032395320987283L;

        public ScrollBar(JScrollPane jScrollPane, int n) {
            this.this$0 = jScrollPane;
            super(n);
        }

        public int getBlockIncrement(int n) {
            Component component = this.this$0.getViewport().getView();
            if (component == null || !(component instanceof Scrollable)) {
                return super.getBlockIncrement(n);
            }
            Scrollable scrollable = (Scrollable)((Object)component);
            return scrollable.getScrollableBlockIncrement(this.this$0.getViewport().getViewRect(), this.getOrientation(), n);
        }

        public int getUnitIncrement(int n) {
            Component component = this.this$0.getViewport().getView();
            if (component == null || !(component instanceof Scrollable)) {
                return super.getUnitIncrement(n);
            }
            Scrollable scrollable = (Scrollable)((Object)component);
            return scrollable.getScrollableUnitIncrement(this.this$0.getViewport().getViewRect(), this.getOrientation(), n);
        }
    }

    protected class AccessibleJScrollPane
    extends JComponent.AccessibleJComponent
    implements ChangeListener,
    PropertyChangeListener {
        private /* synthetic */ JScrollPane this$0;
        protected JViewport viewPort;

        public AccessibleJScrollPane(JScrollPane jScrollPane) {
            this.this$0 = jScrollPane;
            super(jScrollPane);
            this.viewPort = jScrollPane.getViewport();
            this.viewPort.addChangeListener(this);
            this.viewPort.addPropertyChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        public void resetViewPort() {
            this.viewPort.removeChangeListener(this);
            this.viewPort.removePropertyChangeListener(this);
            this.viewPort = this.this$0.getViewport();
            this.viewPort.addChangeListener(this);
            this.viewPort.addPropertyChangeListener(this);
        }
    }
}

