/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    private static final long serialVersionUID = 4227225638931828014L;
    private JPopupMenu popupMenu;
    private MenuEvent menuEvent;
    private int delay;
    protected WinListener popupListener;
    private Point menuLocation;

    private /* synthetic */ void finit$() {
        this.popupMenu = new JPopupMenu();
        this.menuEvent = new MenuEvent(this);
    }

    public JMenu() {
        this.finit$();
        this.setOpaque(false);
    }

    public JMenu(String string) {
        super(string);
        this.finit$();
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(Action action) {
        super(action);
        this.finit$();
        this.createActionChangeListener(this);
        this.popupMenu.setInvoker(this);
        this.setOpaque(false);
    }

    public JMenu(String string, boolean bl) {
        this(string);
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        return this.popupMenu.add(jMenuItem);
    }

    public Component add(Component component) {
        this.popupMenu.insert(component, -1);
        return component;
    }

    public Component add(Component component, int n) {
        return this.popupMenu.add(component, n);
    }

    public JMenuItem add(String string) {
        return this.popupMenu.add(string);
    }

    public JMenuItem add(Action action) {
        return this.popupMenu.add(action);
    }

    public void remove(JMenuItem jMenuItem) {
        this.popupMenu.remove(jMenuItem);
    }

    public void remove(int n) {
        this.popupMenu.remove(n);
    }

    public void remove(Component component) {
        int n = this.popupMenu.getComponentIndex(component);
        this.popupMenu.remove(n);
    }

    public void removeAll() {
        this.popupMenu.removeAll();
    }

    public void insert(String string, int n) {
        this.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero");
        }
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        JMenuItem jMenuItem = new JMenuItem(action);
        this.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void updateUI() {
        super.setUI((MenuItemUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "MenuUI";
    }

    public void setModel(ButtonModel buttonModel) {
        super.setModel(buttonModel);
    }

    public boolean isSelected() {
        return super.isSelected();
    }

    private void setSelectedHelper(boolean bl, boolean bl2, boolean bl3) {
        if (bl && bl2) {
            super.setArmed(true);
            super.setSelected(true);
            if (this.isShowing()) {
                this.fireMenuSelected();
                int n = 0;
                int n2 = 0;
                if (bl3) {
                    if (this.menuLocation == null) {
                        if (this.isTopLevelMenu()) {
                            n2 = this.getHeight();
                        } else {
                            n = this.getWidth();
                        }
                        this.getPopupMenu().show(this, n, n2);
                    } else {
                        this.getPopupMenu().show(this, this.menuLocation.x, this.menuLocation.y);
                    }
                }
            }
        } else {
            super.setSelected(false);
            super.setArmed(false);
            this.fireMenuDeselected();
            this.popupMenu.setVisible(false);
        }
    }

    public void setSelected(boolean bl) {
        this.setSelectedHelper(bl, true, false);
    }

    public boolean isPopupMenuVisible() {
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        if (this.getModel().isEnabled()) {
            this.popupMenu.setVisible(bl);
        }
    }

    protected Point getPopupMenuOrigin() {
        if (this.isTopLevelMenu()) {
            return new Point(0, this.getHeight());
        }
        return new Point(this.getWidth(), 0);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("delay less than 0");
        }
        this.delay = n;
    }

    public void setMenuLocation(int n, int n2) {
        this.menuLocation = new Point(n, n2);
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(this, jMenuItem);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        Component component = this.popupMenu.getComponentAtIndex(n);
        if (component instanceof JMenuItem) {
            return (JMenuItem)component;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        return false;
    }

    public int getMenuComponentCount() {
        return this.popupMenu.getComponentCount();
    }

    public Component getMenuComponent(int n) {
        return this.popupMenu.getComponentAtIndex(n);
    }

    public Component[] getMenuComponents() {
        return this.popupMenu.getComponents();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(JMenu.class$("javax.swing.event.MenuListener"), menuListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(JMenu.class$("javax.swing.event.MenuListener"), menuListener);
    }

    public MenuListener[] getMenuListeners() {
        return (MenuListener[])this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
    }

    protected void fireMenuSelected() {
        MenuListener[] menuListenerArray = this.getMenuListeners();
        for (int i = 0; i < menuListenerArray.length; ++i) {
            menuListenerArray[i].menuSelected(this.menuEvent);
        }
    }

    protected void fireMenuDeselected() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuListener)eventListenerArray[i]).menuDeselected(this.menuEvent);
        }
    }

    protected void fireMenuCanceled() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((MenuListener)eventListenerArray[i]).menuCanceled(this.menuEvent);
        }
    }

    protected WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new WinListener(this, jPopupMenu);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelectedHelper(bl, this.isEnabled(), true);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.popupMenu};
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
    }

    public void doClick(int n) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
        this.popupMenu.show(this, this.getWidth(), 0);
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu(this);
        }
        return this.accessibleContext;
    }

    protected class ActionChangedListener
    implements PropertyChangeListener {
        private /* synthetic */ JMenu this$0;
        private JMenuItem menuItem;

        public ActionChangedListener(JMenu jMenu, JMenuItem jMenuItem) {
            this.this$0 = jMenu;
            this.menuItem = jMenuItem;
            Action action = jMenuItem.getAction();
            if (action != null) {
                action.addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        private /* synthetic */ JMenu this$0;
        private static final long serialVersionUID = -6415815570638474823L;

        public WinListener(JMenu jMenu, JPopupMenu jPopupMenu) {
            this.this$0 = jMenu;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.this$0.setSelected(false);
        }
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private /* synthetic */ JMenu this$0;
        private static final long serialVersionUID = -8131864021059524309L;

        protected AccessibleJMenu(JMenu jMenu) {
            this.this$0 = jMenu;
            super(jMenu);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleSelection(int n) {
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public void addAccessibleSelection(int n) {
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

