/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.InternalFrameUI;

public class JInternalFrame
extends JComponent
implements Accessible,
WindowConstants,
RootPaneContainer {
    private static final long serialVersionUID = -5425177187760785402L;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String FRAME_ICON_PROPERTY = "frameIcon";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String IS_CLOSED_PROPERTY = "closed";
    public static final String IS_ICON_PROPERTY = "icon";
    public static final String IS_MAXIMUM_PROPERTY = "maximum";
    public static final String IS_SELECTED_PROPERTY = "selected";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String MENU_BAR_PROPERTY = "JMenuBar";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String TITLE_PROPERTY = "title";
    protected boolean closable;
    protected boolean iconable;
    protected boolean isClosed;
    protected boolean isIcon;
    protected boolean isMaximum;
    protected boolean isSelected;
    protected boolean maximizable;
    protected boolean rootPaneCheckingEnabled;
    protected boolean resizable;
    protected JDesktopIcon desktopIcon;
    protected Icon frameIcon;
    protected JRootPane rootPane;
    protected String title;
    private transient Rectangle storedBounds;
    private transient Component defaultFocus;
    private transient int defaultCloseOperation;
    private transient boolean isFirstTimeVisible;
    private transient boolean maxTransition;
    private transient boolean wasIcon;

    private /* synthetic */ void finit$() {
        this.rootPaneCheckingEnabled = false;
        this.defaultCloseOperation = 2;
        this.isFirstTimeVisible = true;
        this.maxTransition = false;
        this.wasIcon = false;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JInternalFrame() {
        this(null, false, false, false, false);
    }

    public JInternalFrame(String string) {
        this(string, false, false, false, false);
    }

    public JInternalFrame(String string, boolean bl) {
        this(string, bl, false, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, false, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3) {
        this(string, bl, bl2, bl3, false);
    }

    public JInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.finit$();
        this.title = string;
        this.resizable = bl;
        this.closable = bl2;
        this.maximizable = bl3;
        this.iconable = bl4;
        this.storedBounds = new Rectangle();
        this.setRootPane(this.createRootPane());
        this.updateUI();
        this.setRootPaneCheckingEnabled(true);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n);
        } else {
            super.addImpl(component, object, n);
        }
    }

    public void addInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.add(JInternalFrame.class$("javax.swing.event.InternalFrameListener"), internalFrameListener);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public void dispose() {
        this.hide();
        JDesktopPane jDesktopPane = this.getDesktopPane();
        if (jDesktopPane != null) {
            jDesktopPane.setSelectedFrame(null);
        } else {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.isClosed = true;
        this.fireInternalFrameEvent(25551);
        this.removeNotify();
    }

    public void doDefaultCloseAction() {
        this.fireInternalFrameEvent(25550);
        switch (this.getDefaultCloseOperation()) {
            case 1: {
                this.hide();
                break;
            }
            case 2: {
                this.dispose();
            }
        }
    }

    protected void fireInternalFrameEvent(int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(this, n);
        switch (n) {
            case 25550: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameClosing(internalFrameEvent);
                }
                break;
            }
            case 25554: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameActivated(internalFrameEvent);
                }
                break;
            }
            case 25551: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameClosed(internalFrameEvent);
                }
                break;
            }
            case 25555: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameDeactivated(internalFrameEvent);
                }
                break;
            }
            case 25553: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameDeiconified(internalFrameEvent);
                }
                break;
            }
            case 25552: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameIconified(internalFrameEvent);
                }
                break;
            }
            case 25549: {
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)objectArray[i + 1]).internalFrameOpened(internalFrameEvent);
                }
                break;
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame(this);
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public JDesktopIcon getDesktopIcon() {
        if (this.desktopIcon == null) {
            this.desktopIcon = new JDesktopIcon(this);
        }
        return this.desktopIcon;
    }

    public JDesktopPane getDesktopPane() {
        JDesktopPane jDesktopPane = (JDesktopPane)SwingUtilities.getAncestorOfClass(JInternalFrame.class$("javax.swing.JDesktopPane"), this);
        if (jDesktopPane == null && this.desktopIcon != null) {
            jDesktopPane = this.desktopIcon.getDesktopPane();
        }
        return jDesktopPane;
    }

    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public Component getFocusOwner() {
        Component component;
        if (this.isSelected() && SwingUtilities.isDescendingFrom(component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this)) {
            this.defaultFocus = component;
            return component;
        }
        return null;
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public InternalFrameListener[] getInternalFrameListeners() {
        return (InternalFrameListener[])this.listenerList.getListeners(JInternalFrame.class$("javax.swing.event.InternalFrameListener"));
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public int getLayer() {
        JDesktopPane jDesktopPane = this.getDesktopPane();
        if (jDesktopPane != null) {
            return jDesktopPane.getLayer(this);
        }
        return -1;
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JMenuBar getMenuBar() {
        return this.getJMenuBar();
    }

    public Component getMostRecentFocusOwner() {
        if (this.isSelected()) {
            return this.getFocusOwner();
        }
        return this.defaultFocus;
    }

    public Rectangle getNormalBounds() {
        if (!this.isMaximum() && !this.maxTransition) {
            return this.getBounds();
        }
        return this.storedBounds;
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public String getTitle() {
        return this.title;
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    public String getUIClassID() {
        return "InternalFrameUI";
    }

    public final String getWarningString() {
        return null;
    }

    public void hide() {
        JDesktopPane jDesktopPane = this.getDesktopPane();
        if (jDesktopPane != null) {
            jDesktopPane.setSelectedFrame(null);
        } else {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        super.hide();
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public final boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void moveToBack() {
        if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToBack(this);
        }
    }

    public void moveToFront() {
        if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToFront(this);
        }
    }

    public void pack() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
            } else if (this.isMaximum()) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setSize(this.getPreferredSize());
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    protected String paramString() {
        return super.paramString();
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void removeInternalFrameListener(InternalFrameListener internalFrameListener) {
        this.listenerList.remove(JInternalFrame.class$("javax.swing.event.InternalFrameListener"), internalFrameListener);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.revalidate();
    }

    public void restoreSubcomponentFocus() {
        Component component = this.getMostRecentFocusOwner();
        if (component != null) {
            component.requestFocus();
        }
    }

    public void setClosable(boolean bl) {
        this.closable = bl;
    }

    public void setClosed(boolean bl) throws PropertyVetoException {
        if (bl && !this.isClosed()) {
            this.fireInternalFrameEvent(25550);
            this.fireVetoableChange(IS_CLOSED_PROPERTY, false, true);
            this.isClosed = bl;
            this.firePropertyChange(IS_CLOSED_PROPERTY, false, true);
            this.fireInternalFrameEvent(25551);
        }
    }

    public void setContentPane(Container container) {
        if (container != this.getContentPane()) {
            Container container2 = this.getContentPane();
            this.getRootPane().setContentPane(container);
            this.firePropertyChange(CONTENT_PANE_PROPERTY, container2, container);
        }
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public void setDesktopIcon(JDesktopIcon jDesktopIcon) {
        jDesktopIcon.setInternalFrame(this);
        this.desktopIcon = jDesktopIcon;
    }

    public final void setFocusCycleRoot(boolean bl) {
    }

    public void setFrameIcon(Icon icon) {
        if (icon != this.frameIcon) {
            Icon icon2 = this.frameIcon;
            this.frameIcon = icon;
            this.firePropertyChange(FRAME_ICON_PROPERTY, icon2, this.frameIcon);
        }
    }

    public void setGlassPane(Component component) {
        if (component != this.getGlassPane()) {
            Component component2 = this.getGlassPane();
            this.getRootPane().setGlassPane(component);
            this.firePropertyChange(GLASS_PANE_PROPERTY, component2, component);
        }
    }

    public void setIcon(boolean bl) throws PropertyVetoException {
        if (bl != this.isIcon()) {
            this.fireVetoableChange(IS_ICON_PROPERTY, bl, this.isIcon);
            this.isIcon = bl;
            this.firePropertyChange(IS_ICON_PROPERTY, this.isIcon ^ true, this.isIcon);
            if (bl) {
                this.fireInternalFrameEvent(25552);
            } else {
                this.fireInternalFrameEvent(25553);
            }
        }
    }

    public void setIconifiable(boolean bl) {
        this.iconable = bl;
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setJMenuBar(jMenuBar);
    }

    public void setLayer(int n) {
        this.setLayer(new Integer(n));
    }

    public void setLayer(Integer n) {
        JDesktopPane jDesktopPane = this.getDesktopPane();
        if (jDesktopPane != null) {
            int n2 = jDesktopPane.getPosition(this);
            jDesktopPane.setLayer(this, n, n2);
        }
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        if (jLayeredPane != this.getLayeredPane()) {
            JLayeredPane jLayeredPane2 = this.getLayeredPane();
            this.getRootPane().setLayeredPane(jLayeredPane);
            this.firePropertyChange(LAYERED_PANE_PROPERTY, jLayeredPane2, jLayeredPane);
        }
    }

    public void setMaximizable(boolean bl) {
        this.maximizable = bl;
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public void setMaximum(boolean bl) throws PropertyVetoException {
        if (bl != this.isMaximum()) {
            this.fireVetoableChange(IS_MAXIMUM_PROPERTY, bl, this.isMaximum);
            this.isMaximum = bl;
            if (bl) {
                this.setNormalBounds(this.getBounds());
            }
            this.maxTransition = bl ^ true;
            this.firePropertyChange(IS_MAXIMUM_PROPERTY, this.isMaximum ^ true, this.isMaximum);
            this.maxTransition = false;
        }
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        this.setJMenuBar(jMenuBar);
    }

    public void setNormalBounds(Rectangle rectangle) {
        this.storedBounds.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        this.add(jRootPane);
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    public void setSelected(boolean bl) throws PropertyVetoException {
        if (bl != this.isSelected()) {
            this.fireVetoableChange(IS_SELECTED_PROPERTY, bl, this.isSelected);
            if (!bl) {
                this.defaultFocus = this.getMostRecentFocusOwner();
            }
            this.isSelected = bl;
            if (bl) {
                this.restoreSubcomponentFocus();
            }
            this.firePropertyChange(IS_SELECTED_PROPERTY, this.isSelected ^ true, this.isSelected);
            if (this.isSelected) {
                this.fireInternalFrameEvent(25554);
            } else {
                this.fireInternalFrameEvent(25555);
            }
        }
    }

    public void setTitle(String string) {
        if (string == null && this.title == null) {
            return;
        }
        if (string == null || this.title == null || !this.title.equals(string)) {
            String string2 = string;
            this.title = string;
            this.firePropertyChange(TITLE_PROPERTY, string2, this.title);
        }
    }

    public void show() {
        if (!this.isVisible()) {
            this.moveToFront();
            super.show();
            JDesktopPane jDesktopPane = this.getDesktopPane();
            if (jDesktopPane != null) {
                jDesktopPane.setSelectedFrame(this);
            } else {
                try {
                    this.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (this.isFirstTimeVisible) {
                this.isFirstTimeVisible = false;
                this.fireInternalFrameEvent(25549);
            }
        }
    }

    public void setUI(InternalFrameUI internalFrameUI) {
        boolean bl = this.isRootPaneCheckingEnabled();
        this.setRootPaneCheckingEnabled(false);
        super.setUI(internalFrameUI);
        this.setRootPaneCheckingEnabled(bl);
    }

    public void toBack() {
        this.moveToBack();
    }

    public void toFront() {
        this.moveToFront();
    }

    public void updateUI() {
        boolean bl = this.isRootPaneCheckingEnabled();
        this.setRootPaneCheckingEnabled(false);
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.setRootPaneCheckingEnabled(bl);
    }

    void setWasIcon(boolean bl, String string) {
        if (bl && !this.wasIcon) {
            this.wasIcon = bl;
            this.firePropertyChange(string, bl ^ true, bl);
        }
    }

    boolean getWasIcon() {
        return this.wasIcon;
    }

    private void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        super.fireVetoableChange(string, bl, bl2);
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        private static final long serialVersionUID = 4672973344731387687L;
        JInternalFrame frame;

        public JDesktopIcon(JInternalFrame jInternalFrame) {
            this.frame = jInternalFrame;
            this.updateUI();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon(this);
            }
            return this.accessibleContext;
        }

        public JDesktopPane getDesktopPane() {
            JDesktopPane jDesktopPane = (JDesktopPane)SwingUtilities.getAncestorOfClass(JInternalFrame.class$("javax.swing.JDesktopPane"), this);
            return jDesktopPane;
        }

        public JInternalFrame getInternalFrame() {
            return this.frame;
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        public void setInternalFrame(JInternalFrame jInternalFrame) {
            this.frame = jInternalFrame;
        }

        public void setUI(DesktopIconUI desktopIconUI) {
            super.setUI(desktopIconUI);
        }

        public void updateUI() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            private /* synthetic */ JDesktopIcon this$1;
            private static final long serialVersionUID = 5035560458941637802L;

            protected AccessibleJDesktopIcon(JDesktopIcon jDesktopIcon) {
                this.this$1 = jDesktopIcon;
                super(jDesktopIcon);
            }

            public AccessibleRole getAccessibleRole() {
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                return null;
            }

            public Number getCurrentAccessibleValue() {
                return null;
            }

            public Number getMaximumAccessibleValue() {
                return null;
            }

            public Number getMinimumAccessibleValue() {
                return null;
            }

            public boolean setCurrentAccessibleValue(Number number) {
                return false;
            }
        }
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JInternalFrame this$0;
        private static final long serialVersionUID = 5931936924175476797L;

        protected AccessibleJInternalFrame(JInternalFrame jInternalFrame) {
            this.this$0 = jInternalFrame;
            super(jInternalFrame);
        }

        public String getAccessibleName() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }
    }
}

