/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

public class JFileChooser
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 3162921138695327837L;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int CUSTOM_DIALOG = 2;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String APPROVE_BUTTON_TEXT_CHANGED_PROPERTY = "ApproveButtonTextChangedProperty";
    public static final String APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY = "ApproveButtonToolTipTextChangedProperty";
    public static final String APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY = "ApproveButtonMnemonicChangedProperty";
    public static final String CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY = "ControlButtonsAreShownChangedProperty";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SELECTED_FILE_CHANGED_PROPERTY = "SelectedFileChangedProperty";
    public static final String SELECTED_FILES_CHANGED_PROPERTY = "SelectedFilesChangedProperty";
    public static final String MULTI_SELECTION_ENABLED_CHANGED_PROPERTY = "MultiSelectionEnabledChangedProperty";
    public static final String FILE_SYSTEM_VIEW_CHANGED_PROPERTY = "FileSystemViewChanged";
    public static final String FILE_VIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILE_HIDING_CHANGED_PROPERTY = "FileHidingChanged";
    public static final String FILE_FILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String FILE_SELECTION_MODE_CHANGED_PROPERTY = "fileSelectionChanged";
    public static final String ACCESSORY_CHANGED_PROPERTY = "AccessoryChangedProperty";
    public static final String ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY = "acceptAllFileFilterUsedChanged";
    public static final String DIALOG_TITLE_CHANGED_PROPERTY = "DialogTitleChangedProperty";
    public static final String DIALOG_TYPE_CHANGED_PROPERTY = "DialogTypeChangedProperty";
    public static final String CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY = "ChoosableFileFilterChangedProperty";
    protected AccessibleContext accessibleContext;
    private FileSystemView fsv;
    private JComponent accessory;
    private int approveButtonMnemonic;
    private String approveButtonText;
    private String approveButtonToolTipText;
    private ArrayList choosableFilters;
    private boolean isAcceptAll;
    private String dialogTitle;
    private int dialogType;
    private int retval;
    private boolean multiSelection;
    private boolean fileHiding;
    private int fileSelectionMode;
    private FileView fv;
    private boolean controlButtonsShown;
    private File currentDir;
    private FileFilter currentFilter;
    private File[] selectedFiles;
    private File selectedFile;

    private /* synthetic */ void finit$() {
        this.approveButtonMnemonic = 0;
        this.choosableFilters = new ArrayList();
        this.isAcceptAll = true;
        this.dialogType = 0;
        this.retval = -1;
        this.multiSelection = false;
        this.fileHiding = true;
        this.fileSelectionMode = 2;
        this.fv = null;
        this.controlButtonsShown = true;
        this.currentDir = null;
        this.currentFilter = null;
    }

    public JFileChooser() {
        this.finit$();
        this.setup(null);
        this.setCurrentDirectory(null);
    }

    public JFileChooser(String string) {
        this.finit$();
        this.setup(null);
        this.setCurrentDirectory(this.fsv.createFileObject(string));
    }

    public JFileChooser(String string, FileSystemView fileSystemView) {
        this.finit$();
        this.setup(fileSystemView);
        this.setCurrentDirectory(fileSystemView.createFileObject(string));
    }

    public JFileChooser(File file) {
        this.finit$();
        this.setup(null);
        this.setCurrentDirectory(file);
    }

    public JFileChooser(FileSystemView fileSystemView) {
        this.finit$();
        this.setup(fileSystemView);
        this.setCurrentDirectory(null);
    }

    public JFileChooser(File file, FileSystemView fileSystemView) {
        this.finit$();
        this.setup(fileSystemView);
        this.setCurrentDirectory(file);
    }

    protected void setup(FileSystemView fileSystemView) {
        if (fileSystemView == null) {
            fileSystemView = FileSystemView.getFileSystemView();
        }
        this.setFileSystemView(fileSystemView);
        this.updateUI();
    }

    public void setDragEnabled(boolean bl) {
    }

    public boolean getDragEnabled() {
        return false;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(File file) {
        if (this.selectedFile != file) {
            File file2 = this.selectedFile;
            this.selectedFile = file;
            this.firePropertyChange(SELECTED_FILE_CHANGED_PROPERTY, file2, this.selectedFile);
        }
    }

    public File[] getSelectedFiles() {
        if (this.selectedFiles != null) {
            return this.selectedFiles;
        }
        if (this.selectedFile != null) {
            return new File[]{this.selectedFile};
        }
        return null;
    }

    public void setSelectedFiles(File[] fileArray) {
        if (this.selectedFiles != fileArray) {
            File[] fileArray2 = this.selectedFiles;
            this.selectedFiles = fileArray;
            this.firePropertyChange(SELECTED_FILES_CHANGED_PROPERTY, fileArray2, fileArray);
        }
        if (fileArray != null) {
            this.setSelectedFile(fileArray[0]);
        }
    }

    public File getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(File file) {
        if (this.currentDir != file || file == null) {
            if (file == null) {
                file = this.fsv.getDefaultDirectory();
            }
            File file2 = this.currentDir;
            this.currentDir = file;
            this.firePropertyChange(DIRECTORY_CHANGED_PROPERTY, file2, this.currentDir);
        }
    }

    public void changeToParentDirectory() {
        if (this.fsv.getParentDirectory(this.currentDir) != null) {
            this.setCurrentDirectory(this.fsv.getParentDirectory(this.currentDir));
        }
    }

    public void rescanCurrentDirectory() {
        this.getUI().rescanCurrentDirectory(this);
    }

    public void ensureFileIsVisible(File file) {
        this.getUI().ensureFileIsVisible(this, file);
    }

    public int showOpenDialog(Component component) throws HeadlessException {
        JDialog jDialog = this.createDialog(component);
        jDialog.setTitle("Open");
        this.setDialogType(0);
        this.retval = -1;
        jDialog.pack();
        jDialog.show();
        return this.retval;
    }

    public int showSaveDialog(Component component) throws HeadlessException {
        JDialog jDialog = this.createDialog(component);
        this.setDialogType(1);
        this.retval = -1;
        jDialog.pack();
        jDialog.show();
        return this.retval;
    }

    public int showDialog(Component component, String string) throws HeadlessException {
        JDialog jDialog = this.createDialog(component);
        this.setApproveButtonText(string);
        this.setDialogType(2);
        this.retval = -1;
        jDialog.pack();
        jDialog.show();
        return this.retval;
    }

    protected JDialog createDialog(Component component) throws HeadlessException {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(JFileChooser.class$("java.awt.Frame"), component);
        if (frame == null) {
            frame = SwingUtilities.getOwnerFrame();
        }
        JDialog jDialog = new JDialog(frame);
        this.setSelectedFile(null);
        jDialog.getContentPane().add(this);
        jDialog.setModal(true);
        jDialog.invalidate();
        jDialog.repaint();
        return jDialog;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean getControlButtonsAreShown() {
        return this.controlButtonsShown;
    }

    public void setControlButtonsAreShown(boolean bl) {
        if (this.controlButtonsShown != bl) {
            this.controlButtonsShown = bl;
            this.firePropertyChange(CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY, this.controlButtonsShown ^ true, this.controlButtonsShown);
        }
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Choose allowable dialogType.");
        }
        if (this.dialogType != n) {
            int n2 = this.dialogType;
            this.dialogType = n;
            this.firePropertyChange(DIALOG_TYPE_CHANGED_PROPERTY, n2, this.dialogType);
        }
    }

    public void setDialogTitle(String string) {
        if (this.dialogTitle != string) {
            String string2 = this.dialogTitle;
            this.dialogTitle = string;
            this.firePropertyChange(DIALOG_TITLE_CHANGED_PROPERTY, string2, this.dialogTitle);
        }
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setApproveButtonToolTipText(String string) {
        if (this.approveButtonToolTipText != string) {
            String string2 = this.approveButtonToolTipText;
            this.approveButtonToolTipText = string;
            this.firePropertyChange(APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY, string2, this.approveButtonToolTipText);
        }
    }

    public String getApproveButtonToolTipText() {
        return this.approveButtonToolTipText;
    }

    public int getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    public void setApproveButtonMnemonic(int n) {
        if (this.approveButtonMnemonic != n) {
            int n2 = this.approveButtonMnemonic;
            this.approveButtonMnemonic = n;
            this.firePropertyChange(APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY, n2, this.approveButtonMnemonic);
        }
    }

    public void setApproveButtonMnemonic(char c) {
        this.setApproveButtonMnemonic((int)Character.toUpperCase(c));
    }

    public void setApproveButtonText(String string) {
        if (this.approveButtonText != string) {
            String string2 = this.approveButtonText;
            this.approveButtonText = string;
            this.firePropertyChange(APPROVE_BUTTON_TEXT_CHANGED_PROPERTY, string2, this.approveButtonText);
        }
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public FileFilter[] getChoosableFileFilters() {
        return (FileFilter[])this.choosableFilters.toArray(new FileFilter[this.choosableFilters.size()]);
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        this.choosableFilters.add(fileFilter);
        FileFilter[] fileFilterArray2 = this.getChoosableFileFilters();
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, fileFilterArray2);
    }

    public boolean removeChoosableFileFilter(FileFilter fileFilter) {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        if (!this.choosableFilters.remove(fileFilter)) {
            return false;
        }
        FileFilter[] fileFilterArray2 = this.getChoosableFileFilters();
        this.firePropertyChange(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY, fileFilterArray, fileFilterArray2);
        return true;
    }

    public void resetChoosableFileFilters() {
        this.choosableFilters.clear();
        this.choosableFilters.add(this.getUI().getAcceptAllFileFilter(this));
        this.setFileFilter((FileFilter)this.choosableFilters.get(0));
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.getUI().getAcceptAllFileFilter(this);
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.isAcceptAll;
    }

    public void setAcceptAllFileFilterUsed(boolean bl) {
        if (this.isAcceptAll != bl) {
            this.isAcceptAll = bl;
            this.firePropertyChange(ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY, this.isAcceptAll ^ true, this.isAcceptAll);
        }
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void setAccessory(JComponent jComponent) {
        if (this.accessory != jComponent) {
            JComponent jComponent2 = this.accessory;
            this.accessory = jComponent;
            this.firePropertyChange(ACCESSORY_CHANGED_PROPERTY, jComponent2, this.accessory);
        }
    }

    public void setFileSelectionMode(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Choose a correct file selection mode.");
        }
        if (this.fileSelectionMode != n) {
            int n2 = this.fileSelectionMode;
            this.fileSelectionMode = n;
            this.firePropertyChange(FILE_SELECTION_MODE_CHANGED_PROPERTY, n2, this.fileSelectionMode);
        }
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    public void setMultiSelectionEnabled(boolean bl) {
        if (this.multiSelection != bl) {
            this.multiSelection = bl;
            this.firePropertyChange(MULTI_SELECTION_ENABLED_CHANGED_PROPERTY, this.multiSelection ^ true, this.multiSelection);
        }
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public boolean isFileHidingEnabled() {
        return this.fileHiding;
    }

    public void setFileHidingEnabled(boolean bl) {
        if (this.fileHiding != bl) {
            this.fileHiding = bl;
            this.firePropertyChange(FILE_HIDING_CHANGED_PROPERTY, this.fileHiding ^ true, this.fileHiding);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        if (this.currentFilter != fileFilter) {
            FileFilter fileFilter2 = this.currentFilter;
            this.currentFilter = fileFilter;
            this.firePropertyChange(FILE_FILTER_CHANGED_PROPERTY, fileFilter2, this.currentFilter);
        }
    }

    public FileFilter getFileFilter() {
        return this.currentFilter;
    }

    public void setFileView(FileView fileView) {
        if (this.fv != fileView) {
            FileView fileView2 = this.fv;
            this.fv = fileView;
            this.firePropertyChange(FILE_VIEW_CHANGED_PROPERTY, fileView2, this.fv);
        }
    }

    public FileView getFileView() {
        return this.fv;
    }

    public String getName(File file) {
        String string = null;
        if (this.fv != null) {
            string = this.fv.getName(file);
        }
        if (string == null) {
            string = this.getUI().getFileView(this).getName(file);
        }
        return string;
    }

    public String getDescription(File file) {
        String string = null;
        if (this.fv != null) {
            string = this.fv.getDescription(file);
        }
        if (string == null) {
            string = this.getUI().getFileView(this).getDescription(file);
        }
        return string;
    }

    public String getTypeDescription(File file) {
        String string = null;
        if (this.fv != null) {
            string = this.getFileView().getTypeDescription(file);
        }
        if (string == null) {
            string = this.getUI().getFileView(this).getTypeDescription(file);
        }
        return string;
    }

    public Icon getIcon(File file) {
        Icon icon = null;
        if (this.fv != null) {
            icon = this.fv.getIcon(file);
        }
        if (icon == null) {
            icon = this.getUI().getFileView(this).getIcon(file);
        }
        return icon;
    }

    public boolean isTraversable(File file) {
        return this.getFileSystemView().isTraversable(file);
    }

    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        return this.getFileFilter().accept(file);
    }

    public void setFileSystemView(FileSystemView fileSystemView) {
        if (this.fsv != fileSystemView) {
            FileSystemView fileSystemView2 = this.fsv;
            this.fsv = fileSystemView;
            this.firePropertyChange(FILE_SYSTEM_VIEW_CHANGED_PROPERTY, fileSystemView2, this.fsv);
        }
    }

    public FileSystemView getFileSystemView() {
        return this.fsv;
    }

    public void approveSelection() {
        this.retval = 0;
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    public void cancelSelection() {
        this.retval = 1;
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(JFileChooser.class$("java.awt.event.ActionListener"), actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        try {
            this.listenerList.remove(JFileChooser.class$("java.awt.event.ActionListener"), actionListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(JFileChooser.class$("java.awt.event.ActionListener"));
    }

    protected void fireActionPerformed(String string) {
        ActionListener[] actionListenerArray = this.getActionListeners();
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        for (int i = 0; i < actionListenerArray.length; ++i) {
            actionListenerArray[i].actionPerformed(actionEvent);
        }
    }

    public void updateUI() {
        this.setUI((FileChooserUI)UIManager.getUI(this));
        this.revalidate();
    }

    public String getUIClassID() {
        return "FileChooserUI";
    }

    public FileChooserUI getUI() {
        return (FileChooserUI)this.ui;
    }

    protected String paramString() {
        return "JFileChooser";
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJFileChooser(this);
    }

    protected class AccessibleJFileChooser
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JFileChooser this$0;

        protected AccessibleJFileChooser(JFileChooser jFileChooser) {
            this.this$0 = jFileChooser;
            super(jFileChooser);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILE_CHOOSER;
        }
    }
}

