/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public class FloatControl
extends Control {
    private float minimum;
    private float maximum;
    private float precision;
    private int updatePeriod;
    private float value;
    private String units;
    private String minLabel;
    private String maxLabel;
    private String midLabel;

    protected FloatControl(Type type, float f, float f2, float f3, int n, float f4, String string) {
        super(type);
        this.minimum = f;
        this.maximum = f2;
        this.precision = f3;
        this.updatePeriod = n;
        this.value = f4;
        this.units = string;
        this.minLabel = "";
        this.maxLabel = "";
        this.midLabel = "";
    }

    protected FloatControl(Type type, float f, float f2, float f3, int n, float f4, String string, String string2, String string3, String string4) {
        super(type);
        this.minimum = f;
        this.maximum = f2;
        this.precision = f3;
        this.updatePeriod = n;
        this.value = f4;
        this.units = string;
        this.minLabel = string2;
        this.maxLabel = string4;
        this.midLabel = string3;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public String getMidLabel() {
        return this.midLabel;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public String getMinLabel() {
        return this.minLabel;
    }

    public float getPrecision() {
        return this.precision;
    }

    public String getUnits() {
        return this.units;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f) {
        if (f < this.minimum || f > this.maximum) {
            throw new IllegalArgumentException("value out of range");
        }
        this.value = f;
    }

    public void shift(float f, float f2, int n) {
        if (f < this.minimum || f > this.maximum || f2 < this.minimum || f2 > this.maximum || n < 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        this.value = f2;
    }

    public String toString() {
        return super.toString() + ": " + this.value;
    }

    public static class Type
    extends Control.Type {
        public static final Type AUX_RETURN = new Type("AUX return");
        public static final Type AUX_SEND = new Type("AUX send");
        public static final Type BALANCE = new Type("Balance");
        public static final Type MASTER_GAIN = new Type("Master gain");
        public static final Type PAN = new Type("Pan");
        public static final Type REVERB_RETURN = new Type("Reverb return");
        public static final Type REVERB_SEND = new Type("Reverb send");
        public static final Type SAMPLE_RATE = new Type("Sample rate");
        public static final Type VOLUME = new Type("Volume");

        protected Type(String string) {
            super(string);
        }
    }
}

