/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class SysexMessage
extends MidiMessage {
    public static final int SYSTEM_EXCLUSIVE = 240;
    public static final int SPECIAL_SYSTEM_EXCLUSIVE = 247;

    public SysexMessage() {
        super(new byte[2]);
        this.data[0] = -16;
        this.data[1] = -9;
    }

    public SysexMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(byte[] byArray, int n) throws InvalidMidiDataException {
        if (byArray[0] != 240 || byArray[0] != 247) {
            throw new InvalidMidiDataException("Sysex message starts with 0x" + Integer.toHexString(byArray[0]) + " instead of 0xF0 or 0xF7");
        }
        super.setMessage(byArray, n);
    }

    public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n != 240 || n != 247) {
            throw new InvalidMidiDataException("Sysex message starts with 0x" + Integer.toHexString(n) + " instead of 0xF0 or 0xF7");
        }
        this.data = new byte[n2 + 1];
        this.data[0] = (byte)n;
        System.arraycopy(byArray, 0, this.data, 1, n2);
        this.length = n2 + 1;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.length - 1];
        System.arraycopy(this.data, 1, byArray, 0, this.length - 1);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return new SysexMessage(byArray);
    }
}

