/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.UnmodifiableSetException;

public final class AttributeSetUtilities {
    private AttributeSetUtilities() {
    }

    public static AttributeSet synchronizedView(AttributeSet attributeSet) {
        return new SynchronizedAttributeSet(attributeSet);
    }

    public static DocAttributeSet synchronizedView(DocAttributeSet docAttributeSet) {
        return new SynchronizedDocAttributeSet(docAttributeSet);
    }

    public static PrintJobAttributeSet synchronizedView(PrintJobAttributeSet printJobAttributeSet) {
        return new SynchronizedPrintJobAttributeSet(printJobAttributeSet);
    }

    public static PrintRequestAttributeSet synchronizedView(PrintRequestAttributeSet printRequestAttributeSet) {
        return new SynchronizedPrintRequestAttributeSet(printRequestAttributeSet);
    }

    public static PrintServiceAttributeSet synchronizedView(PrintServiceAttributeSet printServiceAttributeSet) {
        return new SynchronizedPrintServiceAttributeSet(printServiceAttributeSet);
    }

    public static AttributeSet unmodifiableView(AttributeSet attributeSet) {
        return new UnmodifiableAttributeSet(attributeSet);
    }

    public static DocAttributeSet unmodifiableView(DocAttributeSet docAttributeSet) {
        return new UnmodifiableDocAttributeSet(docAttributeSet);
    }

    public static PrintJobAttributeSet unmodifiableView(PrintJobAttributeSet printJobAttributeSet) {
        return new UnmodifiablePrintJobAttributeSet(printJobAttributeSet);
    }

    public static PrintRequestAttributeSet unmodifiableView(PrintRequestAttributeSet printRequestAttributeSet) {
        return new UnmodifiablePrintRequestAttributeSet(printRequestAttributeSet);
    }

    public static PrintServiceAttributeSet unmodifiableView(PrintServiceAttributeSet printServiceAttributeSet) {
        return new UnmodifiablePrintServiceAttributeSet(printServiceAttributeSet);
    }

    public static Class verifyAttributeCategory(Object object, Class clazz) {
        if (object == null) {
            throw new NullPointerException("object may not be null");
        }
        Class clazz2 = (Class)object;
        if (clazz.isAssignableFrom(clazz2)) {
            return clazz2;
        }
        throw new ClassCastException();
    }

    public static Attribute verifyAttributeValue(Object object, Class clazz) {
        if (object == null) {
            throw new NullPointerException("object may not be null");
        }
        if (clazz.isInstance(object)) {
            return (Attribute)object;
        }
        throw new ClassCastException();
    }

    public static void verifyCategoryForValue(Class clazz, Attribute attribute) {
        if (clazz == null || attribute == null) {
            throw new NullPointerException("category or attribute may not be null");
        }
        if (!clazz.equals(attribute.getCategory())) {
            throw new IllegalArgumentException("category of attribute not equal to category");
        }
    }

    private static class SynchronizedPrintServiceAttributeSet
    extends SynchronizedAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public SynchronizedPrintServiceAttributeSet(PrintServiceAttributeSet printServiceAttributeSet) {
            super(printServiceAttributeSet);
        }
    }

    private static class SynchronizedPrintRequestAttributeSet
    extends SynchronizedAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public SynchronizedPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
            super(printRequestAttributeSet);
        }
    }

    private static class SynchronizedPrintJobAttributeSet
    extends SynchronizedAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public SynchronizedPrintJobAttributeSet(PrintJobAttributeSet printJobAttributeSet) {
            super(printJobAttributeSet);
        }
    }

    private static class SynchronizedDocAttributeSet
    extends SynchronizedAttributeSet
    implements DocAttributeSet,
    Serializable {
        public SynchronizedDocAttributeSet(DocAttributeSet docAttributeSet) {
            super(docAttributeSet);
        }
    }

    private static class SynchronizedAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet set;

        public SynchronizedAttributeSet(AttributeSet attributeSet) {
            if (attributeSet == null) {
                throw new NullPointerException("attributeSet may not be null");
            }
            this.set = attributeSet;
        }

        public synchronized boolean add(Attribute attribute) {
            return this.set.add(attribute);
        }

        public synchronized boolean addAll(AttributeSet attributeSet) {
            return this.set.addAll(attributeSet);
        }

        public synchronized void clear() {
            this.set.clear();
        }

        public synchronized boolean containsKey(Class clazz) {
            return this.set.containsKey(clazz);
        }

        public synchronized boolean containsValue(Attribute attribute) {
            return this.set.containsValue(attribute);
        }

        public synchronized boolean equals(Object object) {
            return this.set.equals(object);
        }

        public synchronized Attribute get(Class clazz) {
            return this.set.get(clazz);
        }

        public synchronized int hashCode() {
            return this.set.hashCode();
        }

        public synchronized boolean isEmpty() {
            return this.set.isEmpty();
        }

        public synchronized boolean remove(Class clazz) {
            return this.set.remove(clazz);
        }

        public synchronized boolean remove(Attribute attribute) {
            return this.set.remove(attribute);
        }

        public synchronized int size() {
            return this.set.size();
        }

        public synchronized Attribute[] toArray() {
            return this.set.toArray();
        }
    }

    private static class UnmodifiablePrintServiceAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintServiceAttributeSet,
    Serializable {
        public UnmodifiablePrintServiceAttributeSet(PrintServiceAttributeSet printServiceAttributeSet) {
            super(printServiceAttributeSet);
        }
    }

    private static class UnmodifiablePrintRequestAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintRequestAttributeSet,
    Serializable {
        public UnmodifiablePrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
            super(printRequestAttributeSet);
        }
    }

    private static class UnmodifiablePrintJobAttributeSet
    extends UnmodifiableAttributeSet
    implements PrintJobAttributeSet,
    Serializable {
        public UnmodifiablePrintJobAttributeSet(PrintJobAttributeSet printJobAttributeSet) {
            super(printJobAttributeSet);
        }
    }

    private static class UnmodifiableDocAttributeSet
    extends UnmodifiableAttributeSet
    implements DocAttributeSet,
    Serializable {
        public UnmodifiableDocAttributeSet(DocAttributeSet docAttributeSet) {
            super(docAttributeSet);
        }
    }

    private static class UnmodifiableAttributeSet
    implements AttributeSet,
    Serializable {
        private AttributeSet set;

        public UnmodifiableAttributeSet(AttributeSet attributeSet) {
            if (attributeSet == null) {
                throw new NullPointerException("attributeSet may not be null");
            }
            this.set = attributeSet;
        }

        public boolean add(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public boolean addAll(AttributeSet attributeSet) {
            throw new UnmodifiableSetException();
        }

        public void clear() {
            throw new UnmodifiableSetException();
        }

        public boolean containsKey(Class clazz) {
            return this.set.containsKey(clazz);
        }

        public boolean containsValue(Attribute attribute) {
            return this.set.containsValue(attribute);
        }

        public boolean equals(Object object) {
            return this.set.equals(object);
        }

        public Attribute get(Class clazz) {
            return this.set.get(clazz);
        }

        public int hashCode() {
            return this.set.hashCode();
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public boolean remove(Class clazz) {
            throw new UnmodifiableSetException();
        }

        public boolean remove(Attribute attribute) {
            throw new UnmodifiableSetException();
        }

        public int size() {
            return this.set.size();
        }

        public Attribute[] toArray() {
            return this.set.toArray();
        }
    }
}

