/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DocFlavor
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4512080796965449721L;
    public static final String hostEncoding = new String("US-ASCII");
    private String mediaSubtype;
    private String mediaType;
    private String className;
    private HashMap params;

    private /* synthetic */ void finit$() {
        this.params = new HashMap();
    }

    public DocFlavor(String string, String string2) {
        this.finit$();
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.parseMimeType(string);
        this.className = string2;
    }

    private void parseMimeType(String string) {
        int n = string.indexOf(59);
        if (n != -1) {
            String string2 = string.substring(n + 2);
            string = string.substring(0, n);
            n = string2.indexOf(61);
            this.params.put(string2.substring(0, n), string2.substring(n + 1));
        }
        if ((n = string.indexOf(47)) == -1) {
            throw new IllegalArgumentException();
        }
        this.mediaType = string.substring(0, n);
        this.mediaSubtype = string.substring(n + 1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DocFlavor)) {
            return false;
        }
        DocFlavor docFlavor = (DocFlavor)object;
        return this.getMimeType().equals(docFlavor.getMimeType()) && this.getRepresentationClassName().equals(docFlavor.getRepresentationClassName());
    }

    public String getMediaSubtype() {
        return this.mediaSubtype;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getMimeType() {
        String string = this.getMediaType() + "/" + this.getMediaSubtype();
        Iterator iterator = this.params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            string = string + new StringBuffer("; ").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        return string;
    }

    public String getParameter(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return (String)this.params.get(string);
    }

    public String getRepresentationClassName() {
        return this.className;
    }

    public int hashCode() {
        return this.mediaType.hashCode() * this.mediaSubtype.hashCode() * this.className.hashCode() ^ this.params.hashCode();
    }

    public String toString() {
        return this.getMimeType();
    }

    public static class URL
    extends DocFlavor {
        private static final long serialVersionUID = 2936725788144902062L;
        public static final URL AUTOSENSE = new URL("application/octet-stream");
        public static final URL GIF = new URL("image/gif");
        public static final URL JPEG = new URL("image/jpeg");
        public static final URL PCL = new URL("application/vnd.hp-PCL");
        public static final URL PDF = new URL("application/pdf");
        public static final URL PNG = new URL("image/png");
        public static final URL POSTSCRIPT = new URL("application/postscript");
        public static final URL TEXT_HTML_HOST = new URL("text/html");
        public static final URL TEXT_HTML_US_ASCII = new URL("text/html; charset=us-ascii");
        public static final URL TEXT_HTML_UTF_16 = new URL("text/html; charset=utf-16");
        public static final URL TEXT_HTML_UTF_16BE = new URL("text/html; charset=utf-16be");
        public static final URL TEXT_HTML_UTF_16LE = new URL("text/html; charset=utf-16le");
        public static final URL TEXT_HTML_UTF_8 = new URL("text/html; charset=utf-8");
        public static final URL TEXT_PLAIN_HOST = new URL("text/plain");
        public static final URL TEXT_PLAIN_US_ASCII = new URL("text/plain; charset=us-ascii");
        public static final URL TEXT_PLAIN_UTF_16 = new URL("text/plain; charset=utf-16");
        public static final URL TEXT_PLAIN_UTF_16BE = new URL("text/plain; charset=utf-16be");
        public static final URL TEXT_PLAIN_UTF_16LE = new URL("text/plain; charset=utf-16le");
        public static final URL TEXT_PLAIN_UTF_8 = new URL("text/plain; charset=utf-8");

        public URL(String string) {
            super(string, "java.net.URL");
        }
    }

    public static class STRING
    extends DocFlavor {
        private static final long serialVersionUID = 4414407504887034035L;
        public static final STRING TEXT_HTML = new STRING("text/html; charset=utf-16");
        public static final STRING TEXT_PLAIN = new STRING("text/plain; charset=utf-16");

        public STRING(String string) {
            super(string, "java.lang.String");
        }
    }

    public static class SERVICE_FORMATTED
    extends DocFlavor {
        private static final long serialVersionUID = 6181337766266637256L;
        public static final SERVICE_FORMATTED PAGEABLE = new SERVICE_FORMATTED("java.awt.print.Pageable");
        public static final SERVICE_FORMATTED PRINTABLE = new SERVICE_FORMATTED("java.awt.print.Printable");
        public static final SERVICE_FORMATTED RENDERABLE_IMAGE = new SERVICE_FORMATTED("java.awt.image.renderable.RenderableImage");

        public SERVICE_FORMATTED(String string) {
            super("application/x-java-jvm-local-objectref", string);
        }
    }

    public static class READER
    extends DocFlavor {
        private static final long serialVersionUID = 7100295812579351567L;
        public static final READER TEXT_HTML = new READER("text/html; charset=utf-16");
        public static final READER TEXT_PLAIN = new READER("text/plain; charset=utf-16");

        public READER(String string) {
            super(string, "java.io.Reader");
        }
    }

    public static class INPUT_STREAM
    extends DocFlavor {
        private static final long serialVersionUID = -7045842700749194127L;
        public static final INPUT_STREAM AUTOSENSE = new INPUT_STREAM("application/octet-stream");
        public static final INPUT_STREAM GIF = new INPUT_STREAM("image/gif");
        public static final INPUT_STREAM JPEG = new INPUT_STREAM("image/jpeg");
        public static final INPUT_STREAM PCL = new INPUT_STREAM("application/vnd.hp-PCL");
        public static final INPUT_STREAM PDF = new INPUT_STREAM("application/pdf");
        public static final INPUT_STREAM PNG = new INPUT_STREAM("image/png");
        public static final INPUT_STREAM POSTSCRIPT = new INPUT_STREAM("application/postscript");
        public static final INPUT_STREAM TEXT_HTML_HOST = new INPUT_STREAM("text/html");
        public static final INPUT_STREAM TEXT_HTML_US_ASCII = new INPUT_STREAM("text/html; charset=us-ascii");
        public static final INPUT_STREAM TEXT_HTML_UTF_16 = new INPUT_STREAM("text/html; charset=utf-16");
        public static final INPUT_STREAM TEXT_HTML_UTF_16BE = new INPUT_STREAM("text/html; charset=utf-16be");
        public static final INPUT_STREAM TEXT_HTML_UTF_16LE = new INPUT_STREAM("text/html; charset=utf-16le");
        public static final INPUT_STREAM TEXT_HTML_UTF_8 = new INPUT_STREAM("text/html; charset=utf-8");
        public static final INPUT_STREAM TEXT_PLAIN_HOST = new INPUT_STREAM("text/plain");
        public static final INPUT_STREAM TEXT_PLAIN_US_ASCII = new INPUT_STREAM("text/plain; charset=us-ascii");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_16 = new INPUT_STREAM("text/plain; charset=utf-16");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_16BE = new INPUT_STREAM("text/plain; charset=utf-16be");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_16LE = new INPUT_STREAM("text/plain; charset=utf-16le");
        public static final INPUT_STREAM TEXT_PLAIN_UTF_8 = new INPUT_STREAM("text/plain; charset=utf-8");

        public INPUT_STREAM(String string) {
            super(string, "java.io.InputStream");
        }
    }

    public static class CHAR_ARRAY
    extends DocFlavor {
        private static final long serialVersionUID = -8720590903724405128L;
        public static final CHAR_ARRAY TEXT_HTML = new CHAR_ARRAY("text/html; charset=utf-16");
        public static final CHAR_ARRAY TEXT_PLAIN = new CHAR_ARRAY("text/plain; charset=utf-16");

        public CHAR_ARRAY(String string) {
            super(string, "[C");
        }
    }

    public static class BYTE_ARRAY
    extends DocFlavor {
        private static final long serialVersionUID = -9065578006593857475L;
        public static final BYTE_ARRAY AUTOSENSE = new BYTE_ARRAY("application/octet-stream");
        public static final BYTE_ARRAY GIF = new BYTE_ARRAY("image/gif");
        public static final BYTE_ARRAY JPEG = new BYTE_ARRAY("image/jpeg");
        public static final BYTE_ARRAY PCL = new BYTE_ARRAY("application/vnd.hp-PCL");
        public static final BYTE_ARRAY PDF = new BYTE_ARRAY("application/pdf");
        public static final BYTE_ARRAY PNG = new BYTE_ARRAY("image/png");
        public static final BYTE_ARRAY POSTSCRIPT = new BYTE_ARRAY("application/postscript");
        public static final BYTE_ARRAY TEXT_HTML_HOST = new BYTE_ARRAY("text/html");
        public static final BYTE_ARRAY TEXT_HTML_US_ASCII = new BYTE_ARRAY("text/html; charset=us-ascii");
        public static final BYTE_ARRAY TEXT_HTML_UTF_16 = new BYTE_ARRAY("text/html; charset=utf-16");
        public static final BYTE_ARRAY TEXT_HTML_UTF_16BE = new BYTE_ARRAY("text/html; charset=utf-16be");
        public static final BYTE_ARRAY TEXT_HTML_UTF_16LE = new BYTE_ARRAY("text/html; charset=utf-16le");
        public static final BYTE_ARRAY TEXT_HTML_UTF_8 = new BYTE_ARRAY("text/html; charset=utf-8");
        public static final BYTE_ARRAY TEXT_PLAIN_HOST = new BYTE_ARRAY("text/plain");
        public static final BYTE_ARRAY TEXT_PLAIN_US_ASCII = new BYTE_ARRAY("text/plain; charset=us-ascii");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_16 = new BYTE_ARRAY("text/plain; charset=utf-16");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_16BE = new BYTE_ARRAY("text/plain; charset=utf-16be");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_16LE = new BYTE_ARRAY("text/plain; charset=utf-16le");
        public static final BYTE_ARRAY TEXT_PLAIN_UTF_8 = new BYTE_ARRAY("text/plain; charset=utf-8");

        public BYTE_ARRAY(String string) {
            super(string, "[B");
        }
    }
}

