/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrivialHostnameVerifier;

public abstract class HttpsURLConnection
extends HttpURLConnection {
    private static HostnameVerifier defaultVerifier;
    private static SSLSocketFactory defaultFactory;
    protected HostnameVerifier hostnameVerifier;
    private SSLSocketFactory factory;

    protected HttpsURLConnection(URL uRL) throws IOException {
        super(uRL);
    }

    public static synchronized HostnameVerifier getDefaultHostnameVerifier() {
        if (defaultVerifier == null) {
            defaultVerifier = new TrivialHostnameVerifier();
        }
        return defaultVerifier;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("default verifier cannot be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("setHostnameVerifier"));
        }
        Class clazz = HttpsURLConnection.class$("javax.net.ssl.HttpsURLConnection");
        synchronized (clazz) {
            try {
                defaultVerifier = hostnameVerifier;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        if (defaultFactory == null) {
            try {
                defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return defaultFactory;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new IllegalArgumentException("default factory cannot be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        Class clazz = HttpsURLConnection.class$("javax.net.ssl.HttpsURLConnection");
        synchronized (clazz) {
            try {
                defaultFactory = sSLSocketFactory;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier == null) {
            this.hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        }
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("verifier cannot be null");
        }
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.factory == null) {
            this.factory = HttpsURLConnection.getDefaultSSLSocketFactory();
        }
        return this.factory;
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        this.factory = sSLSocketFactory;
    }

    public abstract String getCipherSuite();

    public abstract Certificate[] getLocalCertificates();

    public abstract Certificate[] getServerCertificates() throws SSLPeerUnverifiedException;
}

