/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;

public class BasicAttributes
implements Attributes {
    private static final long serialVersionUID = 4980164073184639448L;
    private boolean ignoreCase;
    transient Vector attributes;

    public BasicAttributes() {
        this(false);
    }

    public BasicAttributes(boolean bl) {
        this.ignoreCase = bl;
        this.attributes = new Vector();
    }

    public BasicAttributes(String string, Object object) {
        this(string, object, false);
    }

    public BasicAttributes(String string, Object object, boolean bl) {
        this.ignoreCase = bl;
        this.attributes = new Vector();
        this.attributes.add(new BasicAttribute(string, object));
    }

    public Object clone() {
        BasicAttributes basicAttributes = new BasicAttributes(this.ignoreCase);
        basicAttributes.attributes = (Vector)this.attributes.clone();
        return basicAttributes;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attributes)) {
            return false;
        }
        Attributes attributes = (Attributes)object;
        if (this.ignoreCase != attributes.isCaseIgnored() || this.attributes.size() != attributes.size()) {
            return false;
        }
        NamingEnumeration namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attribute;
            Attribute attribute2 = (Attribute)namingEnumeration.nextElement();
            if (attribute2.equals(attribute = this.get(attribute2.getID()))) continue;
            return false;
        }
        return true;
    }

    public Attribute get(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            if ((!this.ignoreCase || !string.equalsIgnoreCase(attribute.getID())) && (this.ignoreCase || !string.equals(attribute.getID()))) continue;
            return attribute;
        }
        return null;
    }

    public NamingEnumeration getAll() {
        return new BasicAttributesEnumeration(this, false);
    }

    public NamingEnumeration getIDs() {
        return new BasicAttributesEnumeration(this, true);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            n += this.attributes.get(i).hashCode();
        }
        return n;
    }

    public boolean isCaseIgnored() {
        return this.ignoreCase;
    }

    public Attribute put(Attribute attribute) {
        Attribute attribute2 = this.remove(attribute.getID());
        this.attributes.add(attribute);
        return attribute2;
    }

    public Attribute put(String string, Object object) {
        return this.put(new BasicAttribute(string, object));
    }

    public Attribute remove(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            if ((!this.ignoreCase || !string.equalsIgnoreCase(attribute.getID())) && (this.ignoreCase || !string.equals(attribute.getID()))) continue;
            this.attributes.remove(i);
            return attribute;
        }
        return null;
    }

    public int size() {
        return this.attributes.size();
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i > 0) {
                string = string + "; ";
            }
            string = string + this.attributes.get(i).toString();
        }
        return string;
    }

    private class BasicAttributesEnumeration
    implements NamingEnumeration {
        private /* synthetic */ BasicAttributes this$0;
        int where;
        boolean id;

        private /* synthetic */ void finit$() {
            this.where = 0;
        }

        public BasicAttributesEnumeration(BasicAttributes basicAttributes, boolean bl) {
            this.this$0 = basicAttributes;
            this.finit$();
            this.id = bl;
        }

        public void close() throws NamingException {
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public boolean hasMoreElements() {
            return this.where < this.this$0.attributes.size();
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.where >= this.this$0.attributes.size()) {
                throw new NoSuchElementException("no more elements");
            }
            Attribute attribute = (Attribute)this.this$0.attributes.get(this.where);
            ++this.where;
            if (this.id) {
                return attribute.getID();
            }
            return attribute;
        }
    }
}

