/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv;
    private int rounds;
    private int version;
    private int wordSize;

    public RC5ParameterSpec(int n, int n2, int n3) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, 0);
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray, int n4) {
        this(n, n2, n3);
        int n5 = 2 * (n3 / 8);
        if (n4 < 0) {
            throw new IllegalArgumentException();
        }
        if (byArray.length - n4 < n5) {
            throw new IllegalArgumentException("IV too short");
        }
        this.iv = new byte[n5];
        System.arraycopy(byArray, n4, this.iv, 0, n5);
    }

    public byte[] getIV() {
        return this.iv;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getVersion() {
        return this.version;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        byte[] byArray = ((RC5ParameterSpec)object).getIV();
        if (this.iv != byArray) {
            if (this.iv == null || byArray == null) {
                return false;
            }
            if (this.iv.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < this.iv.length; ++i) {
                if (this.iv[i] == byArray[i]) continue;
                return false;
            }
        }
        return this.rounds == ((RC5ParameterSpec)object).getRounds() && this.version == ((RC5ParameterSpec)object).getVersion() && this.wordSize == ((RC5ParameterSpec)object).getWordSize();
    }

    public int hashCode() {
        int n = this.rounds + this.version + this.wordSize;
        if (this.iv != null) {
            for (int i = 0; i < this.iv.length; ++i) {
                n += this.iv[i];
            }
        }
        return n;
    }
}

