/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private byte[] outBuffer;
    private int outOffset;
    private int outLength;
    private byte[][] inBuffer;
    private int inLength;
    private boolean isStream;
    private static final int VIRGIN = 0;
    private static final int LIVING = 1;
    private static final int DYING = 2;
    private static final int DEAD = 3;
    private int state;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        this(inputStream);
        this.cipher = cipher;
        this.isStream = cipher.getBlockSize() == 1;
        if (!this.isStream) {
            this.inBuffer = new byte[2][];
            this.inBuffer[0] = new byte[cipher.getBlockSize()];
            this.inBuffer[1] = new byte[cipher.getBlockSize()];
            this.inLength = 0;
            this.outBuffer = new byte[cipher.getBlockSize()];
            this.outLength = 0;
            this.outOffset = 0;
            this.state = 0;
        }
    }

    protected CipherInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int available() throws IOException {
        if (this.isStream) {
            return super.available();
        }
        return this.outLength - this.outOffset;
    }

    public void close() throws IOException {
        super.close();
    }

    public int read() throws IOException {
        if (this.isStream) {
            byte[] byArray = new byte[1];
            int n = super.read();
            if (n == -1) {
                return -1;
            }
            byArray[0] = (byte)n;
            try {
                this.cipher.update(byArray, 0, 1, byArray, 0);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IOException(shortBufferException.getMessage());
            }
            return byArray[0] & 0xFF;
        }
        if (this.state == 3) {
            return -1;
        }
        if (this.available() == 0) {
            this.nextBlock();
        }
        if (this.state == 3) {
            return -1;
        }
        return this.outBuffer[this.outOffset++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        if (this.isStream) {
            n2 = super.read(byArray, n, n2);
            try {
                this.cipher.update(byArray, n, n2, byArray, n);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IOException(shortBufferException.getMessage());
            }
            return n2;
        }
        for (n3 = 0; n3 < n2; n3 += n4) {
            if (this.available() == 0) {
                this.nextBlock();
            }
            if (this.state == 3) {
                if (n3 > 0) {
                    return n3;
                }
                return -1;
            }
            n4 = Math.min(this.available(), n2 - n3);
            System.arraycopy(this.outBuffer, this.outOffset, byArray, n3 + n, n4);
            this.outLength = 0;
            this.outOffset = 0;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        if (this.isStream) {
            return super.skip(l);
        }
        long l2 = 0L;
        if (l > 0L && this.available() > 0) {
            l2 = this.available();
            this.outLength = 0;
            this.outOffset = 0;
        }
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    private void nextBlock() throws IOException {
        byte[] byArray = this.inBuffer[0];
        this.inBuffer[0] = this.inBuffer[1];
        this.inBuffer[1] = byArray;
        int n = 0;
        boolean bl = false;
        if (this.state == 0 || this.state == 1) {
            int n2;
            do {
                if ((n2 = this.in.read(this.inBuffer[1], n, this.inBuffer[1].length - n)) != -1) continue;
                bl = true;
                break;
            } while ((n += n2) < this.inBuffer[1].length);
        }
        try {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.nextBlock();
                    break;
                }
                case 1: {
                    if (bl) {
                        if (n > 0) {
                            this.outOffset = this.cipher.update(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                            this.state = 2;
                            break;
                        }
                        this.outOffset = this.cipher.doFinal(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                        this.state = 3;
                        break;
                    }
                    this.outOffset = this.cipher.update(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                    break;
                }
                case 2: {
                    this.outOffset = this.cipher.doFinal(this.inBuffer[0], 0, this.inLength, this.outBuffer, 0);
                    this.state = 3;
                }
            }
        }
        catch (ShortBufferException shortBufferException) {
            throw new IOException(shortBufferException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.toString());
        }
        this.inLength = n;
    }
}

