/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;

public class LogManager {
    private static LogManager logManager;
    private Map loggers;
    final Logger rootLogger;
    private Properties properties;
    private final PropertyChangeSupport pcs;
    private static final LoggingPermission controlPermission;

    private /* synthetic */ void finit$() {
        this.pcs = new PropertyChangeSupport(LogManager.class$("java.util.logging.LogManager"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected LogManager() {
        this.finit$();
        if (logManager != null) {
            throw new IllegalStateException("there can be only one LogManager; use LogManager.getLogManager()");
        }
        logManager = this;
        this.loggers = new HashMap();
        this.rootLogger = new Logger("", null);
        this.addLogger(this.rootLogger);
        Logger.getLogger("global").setParent(this.rootLogger);
        Logger.getLogger("global").setUseParentHandlers(true);
    }

    public static LogManager getLogManager() {
        return logManager;
    }

    private static LogManager makeLogManager() {
        String string = System.getProperty("java.util.logging.manager");
        LogManager logManager = (LogManager)LogManager.createInstance(string, LogManager.class$("java.util.logging.LogManager"));
        if (logManager != null) {
            return logManager;
        }
        if (string != null) {
            System.err.println("WARNING: System property \"java.util.logging.manager\" should be the name of a subclass of java.util.logging.LogManager");
        }
        return new LogManager();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propertyChangeListener.getClass();
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized boolean addLogger(Logger logger) {
        String string = logger.getName();
        WeakReference weakReference = (WeakReference)this.loggers.get(string);
        if (weakReference != null) {
            if (weakReference.get() != null) {
                return false;
            }
            this.loggers.remove(weakReference);
        }
        if (string != null && !string.equals("")) {
            this.checkAccess();
        }
        Logger logger2 = this.findAncestor(logger);
        this.loggers.put(string, new WeakReference(logger));
        if (logger2 != logger.getParent()) {
            logger.setParent(logger2);
        }
        if (logger2 != this.rootLogger) {
            Iterator iterator = this.loggers.keySet().iterator();
            while (iterator.hasNext()) {
                Logger logger3 = (Logger)((WeakReference)this.loggers.get(iterator.next())).get();
                if (logger3 == null || logger3 == logger || logger3.getParent() != logger2 || !logger3.getName().startsWith(string) || logger3.getName().charAt(string.length()) != '.') continue;
                logger3.setParent(logger);
            }
        }
        return true;
    }

    private synchronized Logger findAncestor(Logger logger) {
        String string = logger.getName();
        int n = string.length();
        Logger logger2 = this.rootLogger;
        int n2 = 0;
        if (logger == this.rootLogger) {
            return null;
        }
        Iterator iterator = this.loggers.keySet().iterator();
        while (iterator.hasNext()) {
            Logger logger3;
            String string2 = (String)iterator.next();
            int n3 = string2.length();
            if (n3 <= n2 || n <= n3 || !string.startsWith(string2) || string.charAt(n3) != '.' || (logger3 = (Logger)((WeakReference)this.loggers.get(string2)).get()) == null || logger3 == logger) continue;
            n2 = string2.length();
            logger2 = logger3;
        }
        return logger2;
    }

    public synchronized Logger getLogger(String string) {
        string.getClass();
        WeakReference weakReference = (WeakReference)this.loggers.get(string);
        if (weakReference != null) {
            return (Logger)weakReference.get();
        }
        return null;
    }

    public synchronized Enumeration getLoggerNames() {
        return Collections.enumeration(this.loggers.keySet());
    }

    public synchronized void reset() throws SecurityException {
        this.checkAccess();
        this.properties = new Properties();
        Iterator iterator = this.loggers.values().iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference == null) continue;
            Logger logger = (Logger)weakReference.get();
            if (logger == null) {
                iterator.remove();
                continue;
            }
            if (logger == this.rootLogger) continue;
            logger.setLevel(null);
        }
        this.rootLogger.setLevel(Level.INFO);
    }

    public synchronized void readConfiguration() throws IOException, SecurityException {
        InputStream inputStream;
        String string;
        String string2 = System.getProperty("java.util.logging.config.file");
        if (string2 == null || string2.length() == 0) {
            string = System.getProperty("gnu.classpath.home.url") + "/logging.properties";
            inputStream = new URL(string).openStream();
        } else {
            inputStream = new FileInputStream(string2);
        }
        try {
            this.readConfiguration(inputStream);
        }
        finally {
            string = null;
            ((InputStream)inputStream).close();
        }
    }

    public synchronized void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkAccess();
        Properties properties = new Properties();
        properties.load(inputStream);
        this.properties = properties;
        Enumeration enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            String string = ((String)enumeration.nextElement()).trim();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            string2 = string2.trim();
            if ("handlers".equals(string)) {
                object2 = new StringTokenizer(string2);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    try {
                        Class clazz = Class.forName((String)object);
                        this.getLogger("").addHandler((Handler)clazz.newInstance());
                    }
                    catch (ClassCastException classCastException) {
                        System.err.println("[LogManager] class " + (String)object + " is not subclass of java.util.logging.Handler");
                    }
                    catch (Exception exception) {}
                }
            }
            if (!string.endsWith(".level")) continue;
            object2 = string.substring(0, string.length() - 6);
            object = this.getLogger((String)object2);
            if (object == null) {
                object = Logger.getLogger((String)object2);
                this.addLogger((Logger)object);
            }
            try {
                ((Logger)object).setLevel(Level.parse(string2));
            }
            catch (Exception exception) {}
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    public synchronized String getProperty(String string) {
        if (this.properties != null) {
            return this.properties.getProperty(string);
        }
        return null;
    }

    static int getIntProperty(String string, int n) {
        try {
            return Integer.parseInt(LogManager.getLogManager().getProperty(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    static int getIntPropertyClamped(String string, int n, int n2, int n3) {
        int n4 = LogManager.getIntProperty(string, n);
        if (n4 < n2 || n4 > n3) {
            n4 = n;
        }
        return n4;
    }

    static boolean getBooleanProperty(String string, boolean bl) {
        try {
            return new Boolean(LogManager.getLogManager().getProperty(string));
        }
        catch (Exception exception) {
            return bl;
        }
    }

    static Level getLevelProperty(String string, Level level) {
        try {
            return Level.parse(LogManager.getLogManager().getProperty(string));
        }
        catch (Exception exception) {
            return level;
        }
    }

    static final Class getClassProperty(String string, Class clazz) {
        Class clazz2 = null;
        try {
            String string2 = logManager.getProperty(string);
            if (string2 != null) {
                clazz2 = Class.forName(string2);
            }
            if (clazz2 != null) {
                return clazz2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    static final Object getInstanceProperty(String string, Class clazz, Class clazz2) {
        Class clazz3 = LogManager.getClassProperty(string, clazz2);
        if (clazz3 == null) {
            return null;
        }
        try {
            Object object = clazz3.newInstance();
            if (clazz.isInstance(object)) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz2 == null) {
            return null;
        }
        try {
            return clazz2.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public void checkAccess() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(controlPermission);
        }
    }

    static final Object createInstance(String string, Class clazz) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            Class clazz2 = Class.forName(string);
            if (!clazz.isAssignableFrom(clazz2)) {
                return null;
            }
            return clazz2.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
        catch (LinkageError linkageError) {
            return null;
        }
    }

    static {
        LogManager.makeLogManager();
        Object object = LogManager.createInstance(System.getProperty("java.util.logging.config.class"), LogManager.class$("java.lang.Object"));
        try {
            if (object == null) {
                LogManager.getLogManager().readConfiguration();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        controlPermission = new LoggingPermission("control", null);
    }
}

