/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import gnu.java.io.Base64InputStream;
import gnu.java.security.OID;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final String META_INF = "META-INF/";
    private static final String PKCS7_DSA_SUFFIX = ".DSA";
    private static final String PKCS7_RSA_SUFFIX = ".RSA";
    private static final String DIGEST_KEY_SUFFIX = "-Digest";
    private static final String SF_SUFFIX = ".SF";
    private static final OID MD2_OID;
    private static final OID MD4_OID;
    private static final OID MD5_OID;
    private static final OID SHA1_OID;
    private static final OID DSA_ENCRYPTION_OID;
    private static final OID RSA_ENCRYPTION_OID;
    private Manifest manifest;
    boolean verify;
    private boolean manifestRead;
    boolean signaturesRead;
    HashMap verified;
    HashMap entryCerts;
    static boolean DEBUG;

    private /* synthetic */ void finit$() {
        this.manifestRead = false;
        this.signaturesRead = false;
        this.verified = new HashMap();
    }

    static void debug(Object object) {
        System.err.print(JarFile.class$("java.util.jar.JarFile").getName());
        System.err.print(" >>> ");
        System.err.println(object);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JarFile(String string) throws FileNotFoundException, IOException {
        this(string, true);
    }

    public JarFile(String string, boolean bl) throws FileNotFoundException, IOException {
        super(string);
        this.finit$();
        if (bl) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file) throws FileNotFoundException, IOException {
        this(file, true);
    }

    public JarFile(File file, boolean bl) throws FileNotFoundException, IOException {
        super(file);
        this.finit$();
        if (bl) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    public JarFile(File file, boolean bl, int n) throws FileNotFoundException, IOException, IllegalArgumentException {
        super(file, n);
        this.finit$();
        if (bl) {
            this.manifest = this.readManifest();
            this.verify();
        }
    }

    private void verify() {
        if (this.manifest == null) {
            this.verify = false;
            return;
        }
        this.verify = true;
    }

    private Manifest readManifest() {
        try {
            ZipEntry zipEntry = super.getEntry(MANIFEST_NAME);
            if (zipEntry != null) {
                InputStream inputStream = super.getInputStream(zipEntry);
                this.manifestRead = true;
                return new Manifest(inputStream);
            }
            this.manifestRead = true;
            return null;
        }
        catch (IOException iOException) {
            this.manifestRead = true;
            return null;
        }
    }

    public Enumeration entries() throws IllegalStateException {
        return new JarEnumeration(super.entries(), this);
    }

    public synchronized ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            Set set;
            Manifest manifest;
            JarEntry jarEntry = new JarEntry(zipEntry);
            try {
                manifest = this.getManifest();
            }
            catch (IOException iOException) {
                manifest = null;
            }
            if (manifest != null) {
                jarEntry.attr = manifest.getAttributes(string);
            }
            if (this.verify && !this.signaturesRead) {
                try {
                    this.readSignatures();
                }
                catch (IOException iOException) {
                    if (DEBUG) {
                        JarFile.debug(iOException);
                        iOException.printStackTrace();
                    }
                    this.signaturesRead = true;
                }
            }
            if (DEBUG) {
                JarFile.debug("entryCerts=" + this.entryCerts + " verified " + string + " ? " + this.verified.get(string));
            }
            if (this.entryCerts != null && this.verified.get(string) == Boolean.TRUE && (set = (Set)this.entryCerts.get(string)) != null) {
                jarEntry.certs = (Certificate[])set.toArray(new Certificate[set.size()]);
            }
            return jarEntry;
        }
        return null;
    }

    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws ZipException, IOException {
        if (!this.verified.containsKey(zipEntry.getName()) && this.verify) {
            if (DEBUG) {
                JarFile.debug("reading and verifying " + zipEntry);
            }
            return new EntryInputStream(zipEntry, super.getInputStream(zipEntry), this);
        }
        if (DEBUG) {
            JarFile.debug("reading already verified entry " + zipEntry);
        }
        if (this.verify && this.verified.get(zipEntry.getName()) == Boolean.FALSE) {
            throw new ZipException("digest for " + zipEntry + " is invalid");
        }
        return super.getInputStream(zipEntry);
    }

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    public synchronized Manifest getManifest() throws IOException {
        if (!this.manifestRead) {
            this.manifest = this.readManifest();
        }
        return this.manifest;
    }

    void readSignatures() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Cloneable cloneable;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        Object object8 = super.entries();
        while (object8.hasMoreElements()) {
            cloneable = (ZipEntry)object8.nextElement();
            object7 = ((ZipEntry)cloneable).getName();
            if (!((String)object7).startsWith(META_INF)) continue;
            String string = ((String)object7).substring(META_INF.length());
            if (string.lastIndexOf(46) >= 0) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            if (((String)object7).endsWith(PKCS7_DSA_SUFFIX) || ((String)object7).endsWith(PKCS7_RSA_SUFFIX)) {
                if (DEBUG) {
                    JarFile.debug("reading PKCS7 info from " + (String)object7 + ", alias=" + string);
                }
                object6 = null;
                try {
                    object6 = new PKCS7SignedData(super.getInputStream((ZipEntry)cloneable));
                }
                catch (CertificateException certificateException) {
                    IOException iOException = new IOException("certificate parsing error");
                    iOException.initCause(certificateException);
                    throw iOException;
                }
                catch (CRLException cRLException) {
                    IOException iOException = new IOException("CRL parsing error");
                    iOException.initCause(cRLException);
                    throw iOException;
                }
                if (((String)object7).endsWith(PKCS7_DSA_SUFFIX)) {
                    hashMap.put(string, object6);
                    continue;
                }
                if (!((String)object7).endsWith(PKCS7_RSA_SUFFIX)) continue;
                hashMap2.put(string, object6);
                continue;
            }
            if (!((String)object7).endsWith(SF_SUFFIX)) continue;
            if (DEBUG) {
                JarFile.debug("reading signature file for " + string + ": " + (String)object7);
            }
            object6 = new Manifest(super.getInputStream((ZipEntry)cloneable));
            hashMap3.put(string, object6);
            if (!DEBUG) continue;
            JarFile.debug("result: " + object6);
        }
        object8 = new HashSet();
        cloneable = new HashMap();
        object7 = hashMap3.entrySet().iterator();
        while (object7.hasNext()) {
            boolean bl = false;
            object6 = (Map.Entry)object7.next();
            object5 = (String)object6.getKey();
            object4 = (PKCS7SignedData)hashMap.get(object5);
            if (object4 != null) {
                object3 = ((PKCS7SignedData)object4).getCertificates();
                object2 = ((PKCS7SignedData)object4).getSignerInfos();
                object = object2.iterator();
                while (object.hasNext()) {
                    this.verify((Certificate[])object3, (SignerInfo)object.next(), (String)object5, (Set)object8);
                }
            }
            if ((object4 = (PKCS7SignedData)hashMap2.get(object5)) != null) {
                object3 = ((PKCS7SignedData)object4).getCertificates();
                object2 = ((PKCS7SignedData)object4).getSignerInfos();
                object = object2.iterator();
                while (object.hasNext()) {
                    this.verify((Certificate[])object3, (SignerInfo)object.next(), (String)object5, (Set)object8);
                }
            }
            if (object8.isEmpty()) {
                object7.remove();
                continue;
            }
            cloneable.put(object6.getValue(), new HashSet((Collection)object8));
            object8.clear();
        }
        this.entryCerts = new HashMap();
        object7 = cloneable.entrySet().iterator();
        while (object7.hasNext()) {
            Map.Entry entry = (Map.Entry)object7.next();
            object6 = (Manifest)entry.getKey();
            object5 = ((Manifest)object6).getEntries();
            object4 = (Set)entry.getValue();
            object3 = object5.entrySet().iterator();
            while (object3.hasNext()) {
                Set set;
                Attributes attributes;
                object2 = (Map.Entry)object3.next();
                object = String.valueOf(object2.getKey());
                if (!this.verifyHashes((String)object, attributes = (Attributes)object2.getValue())) continue;
                if (DEBUG) {
                    JarFile.debug("entry " + (String)object + " has certificates " + object4);
                }
                if ((set = (Set)this.entryCerts.get(object)) != null) {
                    set.addAll((Collection)object4);
                    continue;
                }
                this.entryCerts.put(object, new HashSet((Collection)object4));
            }
        }
        this.signaturesRead = true;
    }

    private void verify(Certificate[] certificateArray, SignerInfo signerInfo, String string, Set set) {
        Cloneable cloneable;
        Signature signature;
        block19: {
            signature = null;
            try {
                cloneable = signerInfo.getDigestEncryptionAlgorithmId();
                if (cloneable.equals(DSA_ENCRYPTION_OID)) {
                    if (!signerInfo.getDigestAlgorithmId().equals(SHA1_OID)) {
                        return;
                    }
                    signature = Signature.getInstance("SHA1withDSA");
                    break block19;
                }
                if (cloneable.equals(RSA_ENCRYPTION_OID)) {
                    OID oID = signerInfo.getDigestAlgorithmId();
                    if (oID.equals(MD2_OID)) {
                        signature = Signature.getInstance("md2WithRsaEncryption");
                        break block19;
                    }
                    if (oID.equals(MD4_OID)) {
                        signature = Signature.getInstance("md4WithRsaEncryption");
                        break block19;
                    }
                    if (oID.equals(MD5_OID)) {
                        signature = Signature.getInstance("md5WithRsaEncryption");
                        break block19;
                    }
                    if (oID.equals(SHA1_OID)) {
                        signature = Signature.getInstance("sha1WithRsaEncryption");
                        break block19;
                    }
                    return;
                }
                if (DEBUG) {
                    JarFile.debug("unsupported signature algorithm: " + cloneable);
                }
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (DEBUG) {
                    JarFile.debug(noSuchAlgorithmException);
                    noSuchAlgorithmException.printStackTrace();
                }
                return;
            }
        }
        cloneable = super.getEntry(META_INF + string + SF_SUFFIX);
        if (cloneable == null) {
            return;
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            X509Certificate x509Certificate;
            if (!(certificateArray[i] instanceof X509Certificate) || !(x509Certificate = (X509Certificate)certificateArray[i]).getIssuerX500Principal().equals(signerInfo.getIssuer()) || !x509Certificate.getSerialNumber().equals(signerInfo.getSerialNumber())) continue;
            try {
                signature.initVerify(x509Certificate.getPublicKey());
                InputStream inputStream = super.getInputStream((ZipEntry)cloneable);
                if (inputStream == null) continue;
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    signature.update(byArray, 0, n);
                }
                if (!signature.verify(signerInfo.getEncryptedDigest())) continue;
                if (DEBUG) {
                    JarFile.debug("signature for " + x509Certificate.getSubjectDN() + " is good");
                }
                set.add(x509Certificate);
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (InvalidKeyException invalidKeyException) {
                continue;
            }
            catch (SignatureException signatureException) {
                // empty catch block
            }
        }
    }

    private boolean verifyHashes(String string, Attributes attributes) {
        Object object;
        int n = 0;
        byte[] byArray = null;
        try {
            object = super.getEntry(string);
            if (object == null) {
                if (DEBUG) {
                    JarFile.debug("verifyHashes: no entry '" + string + "'");
                }
                return false;
            }
            byArray = this.readManifestEntry((ZipEntry)object);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                JarFile.debug(iOException);
                iOException.printStackTrace();
            }
            return false;
        }
        object = attributes.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string2 = String.valueOf(entry.getKey());
            if (!string2.endsWith(DIGEST_KEY_SUFFIX)) continue;
            String string3 = string2.substring(0, string2.length() - DIGEST_KEY_SUFFIX.length());
            try {
                byte[] byArray2 = Base64InputStream.decode((String)entry.getValue());
                MessageDigest messageDigest = MessageDigest.getInstance(string3);
                messageDigest.update(byArray);
                byte[] byArray3 = messageDigest.digest();
                if (DEBUG) {
                    JarFile.debug("verifying SF entry " + string + " alg: " + messageDigest.getAlgorithm() + " expect=" + new BigInteger(byArray2).toString(16) + " comp=" + new BigInteger(byArray3).toString(16));
                }
                if (!Arrays.equals(byArray2, byArray3)) {
                    return false;
                }
                ++n;
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    JarFile.debug(iOException);
                    iOException.printStackTrace();
                }
                return false;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (DEBUG) {
                    JarFile.debug(noSuchAlgorithmException);
                    noSuchAlgorithmException.printStackTrace();
                }
                return false;
            }
        }
        return n > 0;
    }

    private byte[] readManifestEntry(ZipEntry zipEntry) throws IOException {
        int n;
        InputStream inputStream = super.getInputStream(super.getEntry(MANIFEST_NAME));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = ("Name: " + zipEntry.getName()).getBytes();
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        block5: while ((n = inputStream.read()) != -1) {
            switch (n4) {
                case 0: {
                    if ((byte)n != byArray[n2]) {
                        n2 = 0;
                        break;
                    }
                    if (++n2 != byArray.length) continue block5;
                    byteArrayOutputStream.write(byArray);
                    n4 = 1;
                    break;
                }
                case 1: {
                    if (n != 10 && n != 13) {
                        byteArrayOutputStream.reset();
                        n2 = 0;
                        n4 = 0;
                        break;
                    }
                    byteArrayOutputStream.write(n);
                    n4 = 2;
                    break;
                }
                case 2: {
                    if (n == 10) {
                        byteArrayOutputStream.write(n);
                        if (n5 == 0 || n5 == 1 && n3 == 13) {
                            return byteArrayOutputStream.toByteArray();
                        }
                        n5 = 0;
                    } else {
                        if (n5 == 1 && n3 == 13) {
                            return byteArrayOutputStream.toByteArray();
                        }
                        byteArrayOutputStream.write(n);
                        ++n5;
                    }
                    n3 = n;
                    break;
                }
                default: {
                    throw new RuntimeException("this statement should be unreachable");
                }
            }
        }
        if (n4 == 2 && n3 == 13 && n5 == 0) {
            return byteArrayOutputStream.toByteArray();
        }
        throw new IOException("could not find " + zipEntry + " in manifest");
    }

    static {
        MANIFEST_NAME = MANIFEST_NAME;
        META_INF = META_INF;
        PKCS7_DSA_SUFFIX = PKCS7_DSA_SUFFIX;
        PKCS7_RSA_SUFFIX = PKCS7_RSA_SUFFIX;
        DIGEST_KEY_SUFFIX = DIGEST_KEY_SUFFIX;
        SF_SUFFIX = SF_SUFFIX;
        MD2_OID = new OID("1.2.840.113549.2.2");
        MD4_OID = new OID("1.2.840.113549.2.4");
        MD5_OID = new OID("1.2.840.113549.2.5");
        SHA1_OID = new OID("1.3.14.3.2.26");
        DSA_ENCRYPTION_OID = new OID("1.2.840.10040.4.1");
        RSA_ENCRYPTION_OID = new OID("1.2.840.113549.1.1.1");
        DEBUG = false;
    }

    private static class EntryInputStream
    extends FilterInputStream {
        private final JarFile jarfile;
        private final long length;
        private long pos;
        private final ZipEntry entry;
        private final byte[][] hashes;
        private final MessageDigest[] md;
        private boolean checked;

        EntryInputStream(ZipEntry zipEntry, InputStream inputStream, JarFile jarFile) throws IOException {
            super(inputStream);
            this.entry = zipEntry;
            this.jarfile = jarFile;
            this.length = zipEntry.getSize();
            this.pos = 0L;
            this.checked = false;
            Manifest manifest = this.jarfile.getManifest();
            Attributes attributes = manifest != null ? manifest.getAttributes(zipEntry.getName()) : null;
            if (DEBUG) {
                JarFile.debug("verifying entry " + zipEntry + " attr=" + attributes);
            }
            if (attributes == null) {
                this.hashes = new byte[0][];
                this.md = new MessageDigest[0];
            } else {
                LinkedList linkedList = new LinkedList();
                LinkedList linkedList2 = new LinkedList();
                Iterator iterator = attributes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String string = String.valueOf(entry.getKey());
                    if (string == null || !string.endsWith(JarFile.DIGEST_KEY_SUFFIX)) continue;
                    linkedList.add(Base64InputStream.decode((String)entry.getValue()));
                    try {
                        linkedList2.add(MessageDigest.getInstance(string.substring(0, string.length() - DIGEST_KEY_SUFFIX.length())));
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        IOException iOException = new IOException("no such message digest: " + string);
                        iOException.initCause(noSuchAlgorithmException);
                        throw iOException;
                    }
                }
                if (DEBUG) {
                    JarFile.debug("digests=" + linkedList2);
                }
                this.hashes = (byte[][])linkedList.toArray((Object[])new byte[linkedList.size()][]);
                this.md = (MessageDigest[])linkedList2.toArray(new MessageDigest[linkedList2.size()]);
            }
        }

        public boolean markSupported() {
            return false;
        }

        public void mark(int n) {
        }

        public void reset() {
        }

        public int read() throws IOException {
            int n = super.read();
            if (n == -1) {
                this.eof();
                return -1;
            }
            for (int i = 0; i < this.md.length; ++i) {
                this.md[i].update((byte)n);
            }
            ++this.pos;
            if (this.length > 0L && this.pos >= this.length) {
                this.eof();
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, (int)Math.min((long)n2, this.length != 0L ? this.length - this.pos : Integer.MAX_VALUE));
            if (n3 == -1 || this.length > 0L && this.pos >= this.length) {
                this.eof();
                return -1;
            }
            for (int i = 0; i < this.md.length; ++i) {
                this.md[i].update(byArray, n, n3);
            }
            this.pos += (long)n3;
            if (this.length != 0L && this.pos >= this.length) {
                this.eof();
            }
            return n3;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public long skip(long l) throws IOException {
            long l2;
            int n;
            byte[] byArray = new byte[1024];
            for (l2 = 0L; l2 < l && (n = this.read(byArray, 0, (int)Math.min((long)byArray.length, l - l2))) != -1; l2 += (long)n) {
            }
            return l2;
        }

        private void eof() throws IOException {
            if (this.checked) {
                return;
            }
            this.checked = true;
            for (int i = 0; i < this.md.length; ++i) {
                byte[] byArray = this.md[i].digest();
                if (DEBUG) {
                    JarFile.debug("verifying " + this.md[i].getAlgorithm() + " expect=" + new BigInteger(this.hashes[i]).toString(16) + " comp=" + new BigInteger(byArray).toString(16));
                }
                if (Arrays.equals(byArray, this.hashes[i])) continue;
                JarFile jarFile = this.jarfile;
                synchronized (jarFile) {
                    try {
                        if (DEBUG) {
                            JarFile.debug(this.entry + " could NOT be verified");
                        }
                        this.jarfile.verified.put(this.entry.getName(), Boolean.FALSE);
                    }
                    finally {
                        Object var4_4 = null;
                    }
                    return;
                }
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                try {
                    if (DEBUG) {
                        JarFile.debug(this.entry + " has been VERIFIED");
                    }
                    this.jarfile.verified.put(this.entry.getName(), Boolean.TRUE);
                }
                finally {
                    Object var5_8 = null;
                }
                return;
            }
        }
    }

    private static class JarEnumeration
    implements Enumeration {
        private final Enumeration entries;
        private final JarFile jarfile;

        JarEnumeration(Enumeration enumeration, JarFile jarFile) {
            this.entries = enumeration;
            this.jarfile = jarFile;
        }

        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        public Object nextElement() {
            Object object;
            Manifest manifest;
            ZipEntry zipEntry = (ZipEntry)this.entries.nextElement();
            JarEntry jarEntry = new JarEntry(zipEntry);
            try {
                manifest = this.jarfile.getManifest();
            }
            catch (IOException iOException) {
                manifest = null;
            }
            if (manifest != null) {
                jarEntry.attr = manifest.getAttributes(jarEntry.getName());
            }
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                block10: {
                    try {
                        if (this.jarfile.verify && !this.jarfile.signaturesRead) {
                            try {
                                this.jarfile.readSignatures();
                            }
                            catch (IOException iOException) {
                                if (DEBUG) {
                                    JarFile.debug(iOException);
                                    iOException.printStackTrace();
                                }
                                this.jarfile.signaturesRead = true;
                            }
                        }
                        if (this.jarfile.entryCerts == null || this.jarfile.verified.get(zipEntry.getName()) != Boolean.TRUE || (object = (Set)this.jarfile.entryCerts.get(jarEntry.getName())) == null) break block10;
                        jarEntry.certs = (Certificate[])object.toArray(new Certificate[object.size()]);
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        throw throwable;
                    }
                }
                object = null;
            }
            object = jarEntry;
            return object;
        }
    }
}

