/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class Properties
extends Hashtable {
    protected Properties defaults;
    private static final long serialVersionUID = 4112578634029874840L;

    public Properties() {
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    public Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public void load(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
        while ((string = bufferedReader.readLine()) != null) {
            char c;
            StringBuilder stringBuilder;
            int n;
            char c2 = '\u0000';
            for (n = 0; n < string.length() && Character.isWhitespace(c2 = string.charAt(n)); ++n) {
            }
            if (string.length() - n == 0 || string.charAt(n) == '#' || string.charAt(n) == '!') continue;
            int n2 = n;
            boolean bl = string.indexOf(92, n) != -1;
            StringBuilder stringBuilder2 = stringBuilder = bl ? new StringBuilder() : null;
            block14: while (n < string.length() && !Character.isWhitespace(c2 = string.charAt(n++)) && c2 != '=' && c2 != ':') {
                if (bl && c2 == '\\') {
                    if (n == string.length()) {
                        string = bufferedReader.readLine();
                        if (string == null) {
                            string = "";
                        }
                        for (n = 0; n < string.length() && Character.isWhitespace(c2 = string.charAt(n)); ++n) {
                        }
                        continue;
                    }
                    c2 = string.charAt(n++);
                    switch (c2) {
                        case 'n': {
                            stringBuilder.append('\n');
                            break;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break;
                        }
                        case 'u': {
                            if (n + 4 > string.length()) continue block14;
                            c = (char)Integer.parseInt(string.substring(n, n + 4), 16);
                            stringBuilder.append(c);
                            n += 4;
                            break;
                        }
                        default: {
                            stringBuilder.append(c2);
                        }
                    }
                    continue;
                }
                if (!bl) continue;
                stringBuilder.append(c2);
            }
            char c3 = c = c2 == ':' || c2 == '=' ? (char)'\u0001' : '\u0000';
            String string2 = bl ? stringBuilder.toString() : (c != '\u0000' || Character.isWhitespace(c2) ? string.substring(n2, n - 1) : string.substring(n2, n));
            while (n < string.length() && Character.isWhitespace(c2 = string.charAt(n))) {
                ++n;
            }
            if (c == '\u0000' && (c2 == ':' || c2 == '=')) {
                ++n;
                while (n < string.length() && Character.isWhitespace(c2 = string.charAt(n))) {
                    ++n;
                }
            }
            if (!bl) {
                this.put(string2, string.substring(n));
                continue;
            }
            StringBuilder stringBuilder3 = new StringBuilder(string.length() - n);
            block18: while (n < string.length()) {
                if ((c2 = string.charAt(n++)) == '\\') {
                    if (n == string.length()) {
                        string = bufferedReader.readLine();
                        if (string == null) break;
                        for (n = 0; n < string.length() && Character.isWhitespace(c2 = string.charAt(n)); ++n) {
                        }
                        stringBuilder3.ensureCapacity(string.length() - n + stringBuilder3.length());
                        continue;
                    }
                    c2 = string.charAt(n++);
                    switch (c2) {
                        case 'n': {
                            stringBuilder3.append('\n');
                            break;
                        }
                        case 't': {
                            stringBuilder3.append('\t');
                            break;
                        }
                        case 'r': {
                            stringBuilder3.append('\r');
                            break;
                        }
                        case 'u': {
                            if (n + 4 > string.length()) continue block18;
                            char c4 = (char)Integer.parseInt(string.substring(n, n + 4), 16);
                            stringBuilder3.append(c4);
                            n += 4;
                            break;
                        }
                        default: {
                            stringBuilder3.append(c2);
                        }
                    }
                    continue;
                }
                stringBuilder3.append(c2);
            }
            this.put(string2, stringBuilder3.toString());
        }
    }

    public void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
        if (string != null) {
            printWriter.println("#" + string);
        }
        printWriter.println("#" + Calendar.getInstance().getTime());
        Iterator iterator = this.entrySet().iterator();
        int n = this.size();
        StringBuilder stringBuilder = new StringBuilder();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.formatForOutput((String)entry.getKey(), stringBuilder, true);
            stringBuilder.append('=');
            this.formatForOutput((String)entry.getValue(), stringBuilder, false);
            printWriter.println(stringBuilder);
        }
        printWriter.flush();
    }

    public String getProperty(String string) {
        Properties properties = this;
        do {
            String string2;
            if ((string2 = (String)properties.get(string)) == null) continue;
            return string2;
        } while ((properties = properties.defaults) != null);
        return null;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public Enumeration propertyNames() {
        Properties properties = this;
        HashSet hashSet = new HashSet();
        do {
            hashSet.addAll(properties.keySet());
            properties = properties.defaults;
        } while (properties != null);
        return Collections.enumeration(hashSet);
    }

    public void list(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.list(printWriter);
    }

    public void list(PrintWriter printWriter) {
        printWriter.println("-- listing properties --");
        Iterator iterator = this.entrySet().iterator();
        int n = this.size();
        while (--n >= 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            printWriter.print((String)entry.getKey() + "=");
            String string = (String)entry.getValue();
            if (string != null && string.length() > 40) {
                printWriter.println(string.substring(0, 37) + "...");
                continue;
            }
            printWriter.println(string);
        }
        printWriter.flush();
    }

    private void formatForOutput(String string, StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.setLength(0);
            stringBuilder.ensureCapacity(string.length());
        } else {
            stringBuilder.ensureCapacity(stringBuilder.length() + string.length());
        }
        boolean bl2 = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    break;
                }
                case ' ': {
                    stringBuilder.append(bl2 ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    stringBuilder.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String string2 = Integer.toHexString(c);
                        stringBuilder.append("\\u0000".substring(0, 6 - string2.length()));
                        stringBuilder.append(string2);
                        break;
                    }
                    stringBuilder.append(c);
                }
            }
            if (c == ' ') continue;
            bl2 = bl;
        }
    }

    public void storeToXML(OutputStream outputStream, String string) throws IOException {
        this.storeToXML(outputStream, string, "UTF-8");
    }

    public void storeToXML(OutputStream outputStream, String string, String string2) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("Null output stream supplied.");
        }
        if (string2 == null) {
            throw new NullPointerException("Null encoding supplied.");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            DOMImplementation dOMImplementation = dOMImplementationRegistry.getDOMImplementation("LS 3.0");
            DocumentType documentType = dOMImplementation.createDocumentType("properties", null, "http://java.sun.com/dtd/properties.dtd");
            Document document = dOMImplementation.createDocument(null, "properties", documentType);
            Element element = document.getDocumentElement();
            if (string != null) {
                object3 = document.createElement("comment");
                object3.appendChild(document.createTextNode(string));
                element.appendChild((Node)object3);
            }
            object3 = this.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = document.createElement("entry");
                object.setAttribute("key", (String)object2.getKey());
                object.appendChild(document.createTextNode((String)object2.getValue()));
                element.appendChild((Node)object);
            }
            object2 = (DOMImplementationLS)((Object)dOMImplementation);
            object = object2.createLSSerializer();
            LSOutput lSOutput = object2.createLSOutput();
            lSOutput.setByteStream(outputStream);
            lSOutput.setEncoding(string2);
            object.write(document, lSOutput);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (IOException)new IOException("The XML classes could not be found.").initCause(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw (IOException)new IOException("The XML classes could not be instantiated.").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new IOException("The XML classes could not be accessed.").initCause(illegalAccessException);
        }
    }

    public void loadFromXML(InputStream inputStream) throws IOException, InvalidPropertiesFormatException {
        if (inputStream == null) {
            throw new NullPointerException("Null input stream supplied.");
        }
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            PropertiesHandler propertiesHandler = new PropertiesHandler(this);
            xMLReader.setContentHandler(propertiesHandler);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", propertiesHandler);
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (SAXException sAXException) {
            throw (InvalidPropertiesFormatException)new InvalidPropertiesFormatException("Error in parsing XML.").initCause(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (IOException)new IOException("An XML parser could not be found.").initCause(parserConfigurationException);
        }
    }

    private class PropertiesHandler
    extends DefaultHandler2 {
        private /* synthetic */ Properties this$0;
        private String key = null;
        private String value = null;
        private boolean dtdDeclSeen = false;

        public PropertiesHandler(Properties properties) {
            this.this$0 = properties;
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
            if (!string.equals("properties") || string2 != null || !string3.equals("http://java.sun.com/dtd/properties.dtd")) {
                throw new SAXException("Invalid DTD declaration: " + string);
            }
            this.dtdDeclSeen = true;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("entry")) {
                int n = attributes.getIndex("key");
                if (n != -1) {
                    this.key = attributes.getValue(n);
                }
            } else if (!string3.equals("comment") && !string3.equals("properties")) {
                throw new SAXException("Invalid tag: " + string3);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.key != null) {
                this.value = new String(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("entry")) {
                if (this.value == null) {
                    this.value = "";
                }
                this.this$0.setProperty(this.key, this.value);
                this.key = null;
                this.value = null;
            }
        }

        public void endDocument() throws SAXException {
            if (!this.dtdDeclSeen) {
                throw new SAXException("No appropriate DTD declaration was seen.");
            }
        }
    }
}

