/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    private int threshold;
    private final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set keys;
    private transient Collection values;
    private transient Set entries;

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map map) {
        this(Math.max(map.size() * 2, 11), 0.75f);
        this.putAll(map);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new HashEntry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration keys() {
        return new Enumerator(this, 0);
    }

    public Enumeration elements() {
        return new Enumerator(this, 1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry hashEntry = this.buckets[i];
            while (hashEntry != null) {
                if (hashEntry.value.equals(object)) {
                    return true;
                }
                hashEntry = hashEntry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        if (object2 == null) {
            throw new NullPointerException();
        }
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                Object object3 = hashEntry.value;
                hashEntry.value = object2;
                return object3;
            }
            hashEntry = hashEntry.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            n = this.hash(object);
        }
        hashEntry = new HashEntry(object, object2);
        hashEntry.next = this.buckets[n];
        this.buckets[n] = hashEntry;
        return null;
    }

    public synchronized Object remove(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                ++this.modCount;
                if (hashEntry2 == null) {
                    this.buckets[n] = hashEntry.next;
                } else {
                    hashEntry2.next = hashEntry.next;
                }
                --this.size;
                return hashEntry.value;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public synchronized void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry instanceof AbstractMap.BasicMapEntry) {
                AbstractMap.BasicMapEntry basicMapEntry = (AbstractMap.BasicMapEntry)entry;
                this.put(basicMapEntry.key, basicMapEntry.value);
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public synchronized Object clone() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashtable.buckets = new HashEntry[this.buckets.length];
        hashtable.putAllInternal(this);
        hashtable.keys = null;
        hashtable.values = null;
        hashtable.entries = null;
        return hashtable;
    }

    public synchronized String toString() {
        HashIterator hashIterator = new HashIterator(this, 2);
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = this.size; i > 0; --i) {
            stringBuffer.append(hashIterator.next());
            if (i <= 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Set keySet() {
        if (this.keys == null) {
            AbstractSet abstractSet = new AbstractSet(this){
                private /* synthetic */ Hashtable this$0;
                {
                    this.this$0 = hashtable;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new HashIterator(this.this$0, 0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    if (object == null) {
                        return false;
                    }
                    return this.this$0.containsKey(object);
                }

                public boolean remove(Object object) {
                    return this.this$0.remove(object) != null;
                }
            };
            this.keys = new Collections.SynchronizedSet((Object)this, abstractSet);
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            AbstractCollection abstractCollection = new AbstractCollection(this){
                private /* synthetic */ Hashtable this$0;
                {
                    this.this$0 = hashtable;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new HashIterator(this.this$0, 1);
                }

                public void clear() {
                    this.this$0.clear();
                }
            };
            this.values = new Collections.SynchronizedCollection(this, abstractCollection);
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            AbstractSet abstractSet = new AbstractSet(this){
                private /* synthetic */ Hashtable this$0;
                {
                    this.this$0 = hashtable;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new HashIterator(this.this$0, 2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.getEntry(object) != null;
                }

                public boolean remove(Object object) {
                    HashEntry hashEntry = this.this$0.getEntry(object);
                    if (hashEntry != null) {
                        this.this$0.remove(hashEntry.key);
                        return true;
                    }
                    return false;
                }
            };
            this.entries = new Collections.SynchronizedSet((Object)this, abstractSet);
        }
        return this.entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)object).entrySet());
    }

    public synchronized int hashCode() {
        HashIterator hashIterator = new HashIterator(this, 2);
        int n = 0;
        for (int i = this.size; i > 0; --i) {
            n += hashIterator.next().hashCode();
        }
        return n;
    }

    private int hash(Object object) {
        int n = object.hashCode() % this.buckets.length;
        if (n < 0) {
            return -n;
        }
        return n;
    }

    HashEntry getEntry(Object object) {
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Object object2 = ((Map.Entry)object).getKey();
        if (object2 == null) {
            return null;
        }
        int n = this.hash(object2);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.equals(object)) {
                return hashEntry;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    void putAllInternal(Map map) {
        Iterator iterator = map.entrySet().iterator();
        this.size = 0;
        while (iterator.hasNext()) {
            ++this.size;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object object = entry.getKey();
            int n = this.hash(object);
            HashEntry hashEntry = new HashEntry(object, entry.getValue());
            hashEntry.next = this.buckets[n];
            this.buckets[n] = hashEntry;
        }
    }

    protected void rehash() {
        HashEntry[] hashEntryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new HashEntry[n];
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            HashEntry hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                int n2 = this.hash(hashEntry.key);
                HashEntry hashEntry2 = this.buckets[n2];
                if (hashEntry2 != null) {
                    while (hashEntry2.next != null) {
                        hashEntry2 = hashEntry2.next;
                    }
                    hashEntry2.next = hashEntry;
                } else {
                    this.buckets[n2] = hashEntry;
                }
                HashEntry hashEntry3 = hashEntry.next;
                hashEntry.next = null;
                hashEntry = hashEntry3;
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buckets.length);
        objectOutputStream.writeInt(this.size);
        HashIterator hashIterator = new HashIterator(this, 2);
        while (hashIterator.hasNext()) {
            HashEntry hashEntry = (HashEntry)hashIterator.next();
            objectOutputStream.writeObject(hashEntry.key);
            objectOutputStream.writeObject(hashEntry.value);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.buckets = new HashEntry[objectInputStream.readInt()];
        int n = objectInputStream.readInt();
        while (--n >= 0) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    private final class Enumerator
    implements Enumeration {
        private /* synthetic */ Hashtable this$0;
        final int type;
        int count;
        int idx;
        HashEntry next;

        private /* synthetic */ void finit$() {
            this.count = this.this$0.size;
            this.idx = this.this$0.buckets.length;
        }

        Enumerator(Hashtable hashtable, int n) {
            this.this$0 = hashtable;
            this.finit$();
            this.type = n;
        }

        public boolean hasMoreElements() {
            return this.count > 0;
        }

        public Object nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                hashEntry = this.this$0.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            if (this.type == 1) {
                return hashEntry.value;
            }
            return hashEntry.key;
        }
    }

    private final class HashIterator
    implements Iterator {
        private /* synthetic */ Hashtable this$0;
        final int type;
        int knownMod;
        int count;
        int idx;
        HashEntry last;
        HashEntry next;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
            this.count = this.this$0.size;
            this.idx = this.this$0.buckets.length;
        }

        HashIterator(Hashtable hashtable, int n) {
            this.this$0 = hashtable;
            this.finit$();
            this.type = n;
        }

        public boolean hasNext() {
            return this.count > 0;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                hashEntry = this.this$0.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            this.last = hashEntry;
            if (this.type == 1) {
                return hashEntry.value;
            }
            if (this.type == 0) {
                return hashEntry.key;
            }
            return hashEntry;
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    private static final class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        HashEntry(Object object, Object object2) {
            super(object, object2);
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return super.setValue(object);
        }
    }
}

