/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Currency;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private String currencySymbol;
    private char decimalSeparator;
    private char digit;
    private char exponential;
    private char groupingSeparator;
    private String infinity;
    private String intlCurrencySymbol;
    private char minusSign;
    private char monetarySeparator;
    private String NaN;
    private char patternSeparator;
    private char percent;
    private char perMill;
    private int serialVersionOnStream;
    private char zeroDigit;
    private Locale locale;
    private static final long serialVersionUID = 5772796243397350300L;

    private /* synthetic */ void finit$() {
        this.serialVersionOnStream = 2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public DecimalFormatSymbols() {
        this(Locale.getDefault());
    }

    private String safeGetString(ResourceBundle resourceBundle, String string, String string2) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string2;
    }

    private char safeGetChar(ResourceBundle resourceBundle, String string, char c) {
        String string2 = null;
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string2 == null || string2.length() < 1) {
            return c;
        }
        return string2.charAt(0);
    }

    public DecimalFormatSymbols(Locale locale) {
        ResourceBundle resourceBundle;
        this.finit$();
        try {
            resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundle = null;
        }
        this.currencySymbol = this.safeGetString(resourceBundle, "currencySymbol", "$");
        this.decimalSeparator = this.safeGetChar(resourceBundle, "decimalSeparator", '.');
        this.digit = this.safeGetChar(resourceBundle, "digit", '#');
        this.exponential = this.safeGetChar(resourceBundle, "exponential", 'E');
        this.groupingSeparator = this.safeGetChar(resourceBundle, "groupingSeparator", ',');
        this.infinity = this.safeGetString(resourceBundle, "infinity", "\u221e");
        this.intlCurrencySymbol = this.safeGetString(resourceBundle, "intlCurrencySymbol", "$");
        try {
            this.monetarySeparator = this.safeGetChar(resourceBundle, "monetarySeparator", '.');
        }
        catch (MissingResourceException missingResourceException) {
            this.monetarySeparator = this.decimalSeparator;
        }
        this.minusSign = this.safeGetChar(resourceBundle, "minusSign", '-');
        this.NaN = this.safeGetString(resourceBundle, "NaN", "\ufffd");
        this.patternSeparator = this.safeGetChar(resourceBundle, "patternSeparator", ';');
        this.percent = this.safeGetChar(resourceBundle, "percent", '%');
        this.perMill = this.safeGetChar(resourceBundle, "perMill", '\u2030');
        this.zeroDigit = this.safeGetChar(resourceBundle, "zeroDigit", '0');
        this.locale = locale;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalFormatSymbols)) {
            return false;
        }
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)object;
        return this.currencySymbol.equals(decimalFormatSymbols.currencySymbol) && this.decimalSeparator == decimalFormatSymbols.decimalSeparator && this.digit == decimalFormatSymbols.digit && this.exponential == decimalFormatSymbols.exponential && this.groupingSeparator == decimalFormatSymbols.groupingSeparator && this.infinity.equals(decimalFormatSymbols.infinity) && this.intlCurrencySymbol.equals(decimalFormatSymbols.intlCurrencySymbol) && this.minusSign == decimalFormatSymbols.minusSign && this.monetarySeparator == decimalFormatSymbols.monetarySeparator && this.NaN.equals(decimalFormatSymbols.NaN) && this.patternSeparator == decimalFormatSymbols.patternSeparator && this.percent == decimalFormatSymbols.percent && this.perMill == decimalFormatSymbols.perMill && this.zeroDigit == decimalFormatSymbols.zeroDigit;
    }

    public Currency getCurrency() {
        return Currency.getInstance(this.currencySymbol);
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getDigit() {
        return this.digit;
    }

    char getExponential() {
        return this.exponential;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public String getNaN() {
        return this.NaN;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public char getPercent() {
        return this.percent;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public int hashCode() {
        return this.zeroDigit << (16 + this.groupingSeparator & 0x1F) << (8 + this.decimalSeparator & 0x1F);
    }

    public void setCurrency(Currency currency) {
        this.setCurrencySymbol(currency.getSymbol());
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbol = string;
    }

    public void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    public void setDigit(char c) {
        this.digit = c;
    }

    void setExponential(char c) {
        this.exponential = c;
    }

    public void setGroupingSeparator(char c) {
        this.groupingSeparator = c;
    }

    public void setInfinity(String string) {
        this.infinity = string;
    }

    public void setInternationalCurrencySymbol(String string) {
        this.intlCurrencySymbol = string;
    }

    public void setMinusSign(char c) {
        this.minusSign = c;
    }

    public void setMonetaryDecimalSeparator(char c) {
        this.monetarySeparator = c;
    }

    public void setNaN(String string) {
        this.NaN = string;
    }

    public void setPatternSeparator(char c) {
        this.patternSeparator = c;
    }

    public void setPercent(char c) {
        this.percent = c;
    }

    public void setPerMill(char c) {
        this.perMill = c;
    }

    public void setZeroDigit(char c) {
        this.zeroDigit = c;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.locale = Locale.getDefault();
        }
        this.serialVersionOnStream = 2;
    }
}

