/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.SystemProperties;
import gnu.java.security.provider.Gnu;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public final class Security {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static Vector providers;
    private static Properties secprops;

    private Security() {
    }

    private static boolean loadProviders(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        boolean bl = true;
        String string3 = string + "/security/" + string2 + ".security";
        try {
            String string4;
            InputStream inputStream = new URL(string3).openStream();
            secprops.load(inputStream);
            int n = 1;
            while ((string4 = secprops.getProperty("security.provider." + n)) != null) {
                Exception exception = null;
                try {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    providers.addElement(Class.forName(string4, true, classLoader).newInstance());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    exception = classNotFoundException;
                }
                catch (InstantiationException instantiationException) {
                    exception = instantiationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = illegalAccessException;
                }
                if (exception != null) {
                    System.err.println("WARNING: Error loading security provider " + string4 + ": " + exception);
                    bl = false;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public static String getAlgorithmProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = String.valueOf(string2) + "." + String.valueOf(string);
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            Provider provider = (Provider)iterator.next();
            Iterator iterator2 = provider.keySet().iterator();
            while (iterator2.hasNext()) {
                String string4 = (String)iterator2.next();
                if (!string4.equalsIgnoreCase(string3)) continue;
                return provider.getProperty(string4);
            }
        }
        return null;
    }

    public static int insertProviderAt(Provider provider, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("insertProvider." + provider.getName());
        }
        --n;
        int n2 = providers.size();
        for (int i = 0; i < n2; ++i) {
            if (!((Provider)providers.elementAt(i)).getName().equals(provider.getName())) continue;
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        providers.insertElementAt(provider, n);
        return n + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static void removeProvider(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeProvider." + string);
        }
        int n = providers.size();
        for (int i = 0; i < n; ++i) {
            if (!((Provider)providers.elementAt(i)).getName().equals(string)) continue;
            providers.remove(i);
            break;
        }
    }

    public static Provider[] getProviders() {
        Object[] objectArray = new Provider[providers.size()];
        providers.copyInto(objectArray);
        return objectArray;
    }

    public static Provider getProvider(String string) {
        int n = providers.size();
        for (int i = 0; i < n; ++i) {
            Provider provider = (Provider)providers.elementAt(i);
            if (!provider.getName().equals(string)) continue;
            return provider;
        }
        return null;
    }

    public static String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("getProperty." + string);
        }
        return secprops.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setProperty." + string);
        }
        secprops.put(string, string2);
    }

    public static Set getAlgorithms(String string) {
        HashSet hashSet = new HashSet();
        if (string == null || string.length() == 0) {
            return hashSet;
        }
        if ((string = string.trim()).length() == 0) {
            return hashSet;
        }
        string = string.toUpperCase() + ".";
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            Enumeration enumeration = providerArray[i].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = ((String)enumeration.nextElement()).trim();
                if (!string2.toUpperCase().startsWith(string)) continue;
                int n = (string2 = string2.substring(string.length()).trim()).indexOf(32);
                if (n != -1) {
                    string2 = string2.substring(0, n);
                }
                hashSet.add(string2);
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static Provider[] getProviders(String string) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return Security.getProviders();
        }
        HashMap hashMap = new HashMap(1);
        int n = string.indexOf(58);
        if (n == -1) {
            hashMap.put(string, "");
        } else {
            hashMap.put(string.substring(0, n), string.substring(n + 1));
        }
        return Security.getProviders(hashMap);
    }

    public static Provider[] getProviders(Map map) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (map == null) {
            return Security.getProviders();
        }
        Set set = map.keySet();
        if (set == null || set.isEmpty()) {
            return Security.getProviders();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(providers);
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3;
            String string4 = (String)iterator.next();
            if (string4 == null || (string4 = string4.trim()).length() == 0) continue;
            int n = string4.indexOf(46);
            if (n == -1) {
                throw new InvalidParameterException("missing dot in '" + String.valueOf(string4) + "'");
            }
            String string5 = (String)map.get(string4);
            if (string5 == null || string5.trim().length() == 0) {
                string5 = null;
                string3 = null;
                string2 = string4.substring(0, n).trim();
                string = string4.substring(n + 1).trim();
            } else {
                int n2 = string4.indexOf(32);
                if (n2 == -1) {
                    throw new InvalidParameterException("value (" + String.valueOf(string5) + ") is not empty, but querry (" + String.valueOf(string4) + ") is missing at least one space character");
                }
                string5 = string5.trim();
                string3 = string4.substring(n2 + 1).trim();
                if (string3.indexOf(46) != -1) {
                    throw new InvalidParameterException("attribute_name (" + String.valueOf(string3) + ") in querry (" + String.valueOf(string4) + ") contains a dot");
                }
                string4 = string4.substring(0, n2).trim();
                string2 = string4.substring(0, n).trim();
                string = string4.substring(n + 1).trim();
            }
            if (string2.length() == 0) {
                throw new InvalidParameterException("<crypto_service> in querry (" + String.valueOf(string4) + ") is empty");
            }
            if (string.length() == 0) {
                throw new InvalidParameterException("<algorithm_or_type> in querry (" + String.valueOf(string4) + ") is empty");
            }
            Security.selectProviders(string2, string, string3, string5, linkedHashSet, linkedHashSet2);
            linkedHashSet.retainAll(linkedHashSet2);
            if (!linkedHashSet.isEmpty()) continue;
            break;
        }
        if (linkedHashSet.isEmpty()) {
            return null;
        }
        return (Provider[])linkedHashSet.toArray(new Provider[linkedHashSet.size()]);
    }

    private static void selectProviders(String string, String string2, String string3, String string4, LinkedHashSet linkedHashSet, LinkedHashSet linkedHashSet2) {
        linkedHashSet2.clear();
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Provider provider = (Provider)iterator.next();
            if (!Security.provides(provider, string, string2, string3, string4)) continue;
            linkedHashSet2.add(provider);
        }
    }

    private static boolean provides(Provider provider, String string, String string2, String string3, String string4) {
        Iterator iterator;
        int n;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        block0: for (n = 0; n < 3; ++n) {
            string5 = (string + "." + String.valueOf(string2)).trim();
            iterator = provider.keySet().iterator();
            while (iterator.hasNext()) {
                string6 = (String)iterator.next();
                if (string6.equalsIgnoreCase(string5)) {
                    bl = true;
                    break block0;
                }
                if (!string6.equalsIgnoreCase(ALG_ALIAS + string5)) continue;
                string2 = provider.getProperty(string6);
                continue block0;
            }
        }
        if (!bl) {
            return false;
        }
        if (string4 == null) {
            return true;
        }
        n = string5.length() + 1;
        iterator = provider.keySet().iterator();
        while (iterator.hasNext()) {
            String string7;
            string6 = (String)iterator.next();
            if (string6.length() <= n || !string6.substring(0, n).equalsIgnoreCase(string5 + " ") || !(string7 = string6.substring(n).trim()).equalsIgnoreCase(string3)) continue;
            String string8 = provider.getProperty(string6);
            if (string8 == null) {
                return false;
            }
            if (string4.equalsIgnoreCase(string8 = string8.trim())) {
                return true;
            }
            return new Integer(string4) >= new Integer(string8);
        }
        return false;
    }

    static {
        ALG_ALIAS = ALG_ALIAS;
        providers = new Vector();
        secprops = new Properties();
        String string = SystemProperties.getProperty("gnu.classpath.home.url");
        String string2 = SystemProperties.getProperty("gnu.classpath.vm.shortname");
        boolean bl = Security.loadProviders(string, string2);
        if (!Security.loadProviders(string, "classpath") && !bl && providers.size() == 0) {
            providers.addElement(new Gnu());
        }
    }
}

