/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import gnu.java.nio.ChannelInputStream;
import gnu.java.nio.ChannelOutputStream;
import gnu.java.nio.ChannelReader;
import gnu.java.nio.InputStreamChannel;
import gnu.java.nio.OutputStreamChannel;
import gnu.java.nio.channels.FileChannelImpl;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class Channels {
    private Channels() {
    }

    public static InputStream newInputStream(ReadableByteChannel readableByteChannel) {
        if (readableByteChannel instanceof FileChannelImpl) {
            return Channels.newInputStream((FileChannelImpl)readableByteChannel);
        }
        return new ChannelInputStream(readableByteChannel);
    }

    public static OutputStream newOutputStream(WritableByteChannel writableByteChannel) {
        if (writableByteChannel instanceof FileChannelImpl) {
            return Channels.newOutputStream((FileChannelImpl)writableByteChannel);
        }
        return new ChannelOutputStream(writableByteChannel);
    }

    static native FileInputStream newInputStream(FileChannelImpl var0);

    static native FileOutputStream newOutputStream(FileChannelImpl var0);

    public static ReadableByteChannel newChannel(InputStream inputStream) {
        return new InputStreamChannel(inputStream);
    }

    public static WritableByteChannel newChannel(OutputStream outputStream) {
        return new OutputStreamChannel(outputStream);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        return new ChannelReader(readableByteChannel, charsetDecoder, n);
    }

    public static Reader newReader(ReadableByteChannel readableByteChannel, String string) {
        return Channels.newReader(readableByteChannel, Charset.forName(string).newDecoder(), -1);
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, CharsetEncoder charsetEncoder, int n) {
        throw new Error("not implemented");
    }

    public static Writer newWriter(WritableByteChannel writableByteChannel, String string) {
        return Channels.newWriter(writableByteChannel, Charset.forName(string).newEncoder(), -1);
    }
}

