/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.CharBufferImpl;

public abstract class CharBuffer
extends Buffer
implements Comparable,
CharSequence {
    int array_offset = 0;
    char[] backing_buffer;

    CharBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public static CharBuffer allocate(int n) {
        return new CharBufferImpl(n);
    }

    public static final CharBuffer wrap(char[] cArray, int n, int n2) {
        return new CharBufferImpl(cArray, 0, cArray.length, n + n2, n, -1, false);
    }

    public static final CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public static final CharBuffer wrap(CharSequence charSequence, int n, int n2) {
        if (n < 0 || n > charSequence.length() || n2 < n || n2 > charSequence.length() - n) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            cArray[i] = charSequence.charAt(i + n);
        }
        return CharBuffer.wrap(cArray, 0, n3).asReadOnlyBuffer();
    }

    public static final CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    public CharBuffer get(char[] cArray, int n, int n2) {
        Buffer.checkArraySize(cArray.length, n, n2);
        this.checkForUnderflow(n2);
        for (int i = n; i < n + n2; ++i) {
            cArray[i] = this.get();
        }
        return this;
    }

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(charBuffer.remaining());
        if (charBuffer.remaining() > 0) {
            char[] cArray = new char[charBuffer.remaining()];
            charBuffer.get(cArray);
            this.put(cArray);
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        Buffer.checkArraySize(cArray.length, n, n2);
        this.checkForOverflow(n2);
        for (int i = n; i < n + n2; ++i) {
            this.put(cArray[i]);
        }
        return this;
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final char[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        for (int i = this.position() + 1; i < this.limit(); ++i) {
            n += (this.get(i) + 30) * (n2 *= 31);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CharBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int compareTo(Object object) {
        CharBuffer charBuffer = (CharBuffer)object;
        int n = Math.min(this.remaining(), charBuffer.remaining());
        int n2 = this.position();
        int n3 = charBuffer.position();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2;
            if ((c2 = this.get(n2++)) == (c = charBuffer.get(n3++))) continue;
            if (c2 < c) {
                return -1;
            }
            return 1;
        }
        return this.remaining() - charBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public String toString() {
        if (this.hasArray()) {
            return new String(this.array(), this.position(), this.length());
        }
        char[] cArray = new char[this.length()];
        int n = this.position();
        this.get(cArray, 0, cArray.length);
        this.position(n);
        return new String(cArray);
    }

    public final int length() {
        return this.remaining();
    }

    public abstract CharSequence subSequence(int var1, int var2);

    public CharBuffer put(String string, int n, int n2) {
        return this.put(string.toCharArray(), n, n2);
    }

    public final CharBuffer put(String string) {
        return this.put(string.toCharArray(), 0, string.length());
    }

    public final char charAt(int n) {
        if (n < 0 || n >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + n);
    }
}

