/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class Method
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] exception_types;
    private String name;
    private Class[] parameter_types;
    private Class return_type;
    private int offset;

    private Method() {
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public native String getName();

    public native int getModifiers();

    public Class getReturnType() {
        if (this.return_type == null) {
            this.getType();
        }
        return this.return_type;
    }

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        return this.declaringClass == method.declaringClass && this.offset == method.offset;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.declaringClass.getName().hashCode();
    }

    public String toString() {
        int n;
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getModifiers();
        if (n2 != 0) {
            Modifier.toString(n2, stringBuffer);
            stringBuffer.append(" ");
        }
        Method.appendClassName(stringBuffer, this.return_type);
        stringBuffer.append(" ");
        Method.appendClassName(stringBuffer, this.declaringClass);
        stringBuffer.append(".");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        for (n = 0; n < this.parameter_types.length; ++n) {
            Method.appendClassName(stringBuffer, this.parameter_types[n]);
            if (n >= this.parameter_types.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        if (this.exception_types.length > 0) {
            stringBuffer.append(" throws ");
            for (n = 0; n < this.exception_types.length; ++n) {
                Method.appendClassName(stringBuffer, this.exception_types[n]);
                if (n >= this.exception_types.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public native Object invoke(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    private native void getType();

    static void appendClassName(StringBuffer stringBuffer, Class clazz) {
        if (clazz.isArray()) {
            Method.appendClassName(stringBuffer, clazz.getComponentType());
            stringBuffer.append("[]");
        } else {
            stringBuffer.append(clazz.getName());
        }
    }
}

