/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Field
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private String name;
    private int offset;
    private Class type;

    Field() {
    }

    public boolean equals(Object object) {
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return this.declaringClass == field.declaringClass && this.offset == field.offset;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public native String getName();

    public native Class getType();

    public native int getModifiers();

    public int hashCode() {
        return this.declaringClass.hashCode() ^ this.offset;
    }

    public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getBoolean(null, object);
    }

    public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getChar(null, object);
    }

    public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getByte(null, object);
    }

    public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getShort(null, object);
    }

    public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getInt(null, object);
    }

    public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getLong(null, object);
    }

    public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getFloat(null, object);
    }

    public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.getDouble(null, object);
    }

    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        return this.get(null, object);
    }

    private native boolean getBoolean(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native char getChar(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native byte getByte(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native short getShort(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native int getInt(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native long getLong(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native float getFloat(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native double getDouble(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native Object get(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.setByte(null, object, by, true);
    }

    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setShort(null, object, s, true);
    }

    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.setInt(null, object, n, true);
    }

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(null, object, l, true);
    }

    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(null, object, f, true);
    }

    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        this.setDouble(null, object, d, true);
    }

    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setChar(null, object, c, true);
    }

    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        this.setBoolean(null, object, bl, true);
    }

    native void setByte(Class var1, Object var2, byte var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setShort(Class var1, Object var2, short var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setInt(Class var1, Object var2, int var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setLong(Class var1, Object var2, long var3, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    native void setFloat(Class var1, Object var2, float var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setDouble(Class var1, Object var2, double var3, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    native void setChar(Class var1, Object var2, char var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setBoolean(Class var1, Object var2, boolean var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void set(Class var1, Object var2, Object var3, Class var4, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.set(null, object, object2);
    }

    private void set(Class clazz, Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        Class clazz2 = this.getType();
        if (!clazz2.isPrimitive()) {
            this.set(clazz, object, object2, clazz2, true);
        } else if (object2 instanceof Byte) {
            this.setByte(clazz, object, (Byte)object2, true);
        } else if (object2 instanceof Short) {
            this.setShort(clazz, object, (Short)object2, true);
        } else if (object2 instanceof Integer) {
            this.setInt(clazz, object, (Integer)object2, true);
        } else if (object2 instanceof Long) {
            this.setLong(clazz, object, (Long)object2, true);
        } else if (object2 instanceof Float) {
            this.setFloat(clazz, object, ((Float)object2).floatValue(), true);
        } else if (object2 instanceof Double) {
            this.setDouble(clazz, object, (Double)object2, true);
        } else if (object2 instanceof Character) {
            this.setChar(clazz, object, ((Character)object2).charValue(), true);
        } else if (object2 instanceof Boolean) {
            this.setBoolean(clazz, object, (Boolean)object2, true);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            Modifier.toString(n, stringBuffer);
            stringBuffer.append(' ');
        }
        Method.appendClassName(stringBuffer, this.getType());
        stringBuffer.append(' ');
        Method.appendClassName(stringBuffer, this.getDeclaringClass());
        stringBuffer.append('.');
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }
}

