/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private Class[] exception_types;
    private Class[] parameter_types;
    private int offset;

    private Constructor() {
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.declaringClass.getName();
    }

    public native int getModifiers();

    public Class[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    public Class[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Constructor)) {
            return false;
        }
        Constructor constructor = (Constructor)object;
        return this.declaringClass == constructor.declaringClass && this.offset == constructor.offset;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.declaringClass.getName().hashCode();
    }

    public String toString() {
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            Modifier.toString(n, stringBuffer);
            stringBuffer.append(" ");
        }
        Method.appendClassName(stringBuffer, this.declaringClass);
        stringBuffer.append("(");
        for (int i = 0; i < this.parameter_types.length; ++i) {
            Method.appendClassName(stringBuffer, this.parameter_types[i]);
            if (i >= this.parameter_types.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public native Object newInstance(Object[] var1) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    private native void getType();
}

