/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.util.DoubleEnumeration;
import gnu.java.util.EmptyEnumeration;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassLoader {
    final HashMap loadedClasses;
    final HashMap definedPackages;
    private final ClassLoader parent;
    private final boolean initialized;
    static final ClassLoader systemClassLoader = VMClassLoader.getSystemClassLoader();
    static final ProtectionDomain defaultProtectionDomain;
    boolean defaultAssertionStatus;
    static final Map systemPackageAssertionStatus;
    Map packageAssertionStatus;
    static final Map systemClassAssertionStatus;
    Map classAssertionStatus;

    private /* synthetic */ void finit$() {
        this.loadedClasses = new HashMap();
        this.definedPackages = new HashMap();
        this.defaultAssertionStatus = VMClassLoader.defaultAssertionStatus();
    }

    protected ClassLoader() throws SecurityException {
        this(systemClassLoader);
    }

    protected ClassLoader(ClassLoader classLoader) {
        this.finit$();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initialized = true;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    private native Class loadClassFromSig(String var1) throws ClassNotFoundException;

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        if (string.length() > 0 && string.charAt(0) == '[') {
            clazz = this.loadClassFromSig(string);
        } else {
            clazz = this.findLoadedClass(string);
            if (clazz == null) {
                block8: {
                    try {
                        if (this.parent == null) {
                            clazz = VMClassLoader.loadClass(string, bl);
                            if (clazz != null) {
                                return clazz;
                            }
                            break block8;
                        }
                        return this.parent.loadClass(string, bl);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                clazz = this.findClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    protected final synchronized Class defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (protectionDomain == null) {
            protectionDomain = defaultProtectionDomain;
        }
        if (!this.initialized) {
            throw new SecurityException("attempt to define class from uninitialized class loader");
        }
        Class clazz = VMClassLoader.defineClass(this, string, byArray, n, n2, protectionDomain);
        this.loadedClasses.put(clazz.getName(), clazz);
        return clazz;
    }

    protected final void resolveClass(Class clazz) {
        VMClassLoader.resolveClass(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        return Class.forName(string, false, systemClassLoader);
    }

    public final ClassLoader getParent() {
        Class clazz;
        ClassLoader classLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = (clazz = VMSecurityManager.getClassContext(ClassLoader.class$("java.lang.ClassLoader"))[1]).getClassLoader()) != null && !classLoader.isAncestorOf(this)) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return this.parent;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        clazz.setSigners(objectArray);
    }

    protected final synchronized Class findLoadedClass(String string) {
        return (Class)this.loadedClasses.get(string);
    }

    public URL getResource(String string) {
        URL uRL = this.parent == null ? VMClassLoader.getResource(string) : this.parent.getResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration enumeration = this.parent == null ? VMClassLoader.getResources(string) : this.parent.getResources(string);
        return new DoubleEnumeration(enumeration, this.findResources(string));
    }

    protected Enumeration findResources(String string) throws IOException {
        return EmptyEnumeration.getInstance();
    }

    protected URL findResource(String string) {
        return null;
    }

    public static final URL getSystemResource(String string) {
        return systemClassLoader.getResource(string);
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        return systemClassLoader.getResources(string);
    }

    public InputStream getResourceAsStream(String string) {
        try {
            URL uRL = this.getResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final InputStream getSystemResourceAsStream(String string) {
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ClassLoader getSystemClassLoader() {
        Class clazz;
        ClassLoader classLoader;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = (clazz = VMSecurityManager.getClassContext(ClassLoader.class$("java.lang.ClassLoader"))[1]).getClassLoader()) != null && classLoader != systemClassLoader) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return systemClassLoader;
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        if (this.getPackage(string) != null) {
            throw new IllegalArgumentException("Package " + string + " already defined");
        }
        Package package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            Package package_2;
            try {
                this.definedPackages.put(string, package_);
            }
            finally {
                package_2 = null;
            }
            package_2 = package_;
            return package_2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Package getPackage(String string) {
        Package package_ = this.parent == null ? VMClassLoader.getPackage(string) : this.parent.getPackage(string);
        if (package_ != null) return package_;
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            try {
                package_ = (Package)this.definedPackages.get(string);
                return package_;
            }
            finally {
                Package package_2 = null;
            }
        }
    }

    protected Package[] getPackages() {
        HashMap hashMap = this.definedPackages;
        synchronized (hashMap) {
            Package[] packageArray;
            Object[] objectArray;
            try {
                objectArray = new Package[this.definedPackages.size()];
                this.definedPackages.values().toArray(objectArray);
            }
            finally {
                packageArray = null;
            }
            packageArray = this.parent == null ? VMClassLoader.getPackages() : this.parent.getPackages();
            Package[] packageArray2 = new Package[packageArray.length + objectArray.length];
            System.arraycopy(packageArray, 0, packageArray2, 0, packageArray.length);
            System.arraycopy(objectArray, 0, packageArray2, packageArray.length, objectArray.length);
            Package[] packageArray3 = packageArray2;
            return packageArray3;
        }
    }

    protected String findLibrary(String string) {
        return null;
    }

    public void setDefaultAssertionStatus(boolean bl) {
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap(systemPackageAssertionStatus);
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap(systemClassAssertionStatus);
        }
        this.classAssertionStatus.put(string.toString(), bl);
    }

    public synchronized void clearAssertionStatus() {
        this.defaultAssertionStatus = false;
        this.packageAssertionStatus = new HashMap();
        this.classAssertionStatus = new HashMap();
    }

    final boolean isAncestorOf(ClassLoader classLoader) {
        while (classLoader != null) {
            if (this == classLoader) {
                return true;
            }
            classLoader = classLoader.parent;
        }
        return false;
    }

    static {
        CodeSource codeSource = new CodeSource(null, null);
        PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(codeSource);
        defaultProtectionDomain = new ProtectionDomain(codeSource, permissionCollection);
        systemPackageAssertionStatus = VMClassLoader.packageAssertionStatus();
        systemClassAssertionStatus = VMClassLoader.classAssertionStatus();
    }
}

