/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.text.Collator;
import java.util.Locale;

public final class Character
implements Serializable,
Comparable {
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('C');
    public static final int SIZE = 16;
    private static final int MAX_CACHE = 127;
    private static Character[] charCache = new Character[128];
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte SURROGATE = 19;
    public static final byte PRIVATE_USE = 18;
    public static final byte UNASSIGNED = 0;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    private static final int TYPE_MASK = 31;
    private static final int NO_BREAK_MASK = 32;
    private static final int MIRROR_MASK = 64;
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';

    private static native char readChar(char var0);

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Character && this.value == ((Character)object).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    public static boolean isLowerCase(char c) {
        return Character.getType(c) == 2;
    }

    public static boolean isUpperCase(char c) {
        return Character.getType(c) == 1;
    }

    public static boolean isTitleCase(char c) {
        return Character.getType(c) == 3;
    }

    public static boolean isDigit(char c) {
        return Character.getType(c) == 9;
    }

    public static boolean isDefined(char c) {
        return Character.getType(c) != 0;
    }

    public static boolean isLetter(char c) {
        return (62 >> (Character.getType(c) & 0x1F) & 1) != 0;
    }

    public static boolean isLetterOrDigit(char c) {
        return (574 >> (Character.getType(c) & 0x1F) & 1) != 0;
    }

    public static boolean isJavaLetter(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static boolean isJavaLetterOrDigit(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isJavaIdentifierStart(char c) {
        return (75498558 >> (Character.getType(c) & 0x1F) & 1) != 0;
    }

    public static boolean isJavaIdentifierPart(char c) {
        int n = Character.getType(c);
        return (1 << (n & 0x1F) & 0x481077E) != 0 || n == 15 && Character.isIdentifierIgnorable(c);
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return (1086 >> (Character.getType(c) & 0x1F) & 1) != 0;
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        int n = Character.getType(c);
        return (1 << (n & 0x1F) & 0x81077E) != 0 || n == 15 && Character.isIdentifierIgnorable(c);
    }

    public static boolean isIdentifierIgnorable(char c) {
        return c <= '\u009f' && (c < '\t' || c >= '\u007f' || c <= '\u001b' && c >= '\u000e') || Character.getType(c) == 16;
    }

    public static native char toLowerCase(char var0);

    public static native char toUpperCase(char var0);

    public static native char toTitleCase(char var0);

    public static native int digit(char var0, int var1);

    public static native int getNumericValue(char var0);

    public static boolean isSpace(char c) {
        char c2 = c;
        c = (char)(c2 - '\u0001');
        return c2 <= ' ' && (1 << (c & 0x1F) & 0x80001B00) != 0;
    }

    public static boolean isSpaceChar(char c) {
        return (28672 >> (Character.getType(c) & 0x1F) & 1) != 0;
    }

    public static boolean isWhitespace(char c) {
        char c2 = Character.readChar(c);
        return (1 << (c2 & 0x1F) & 0x7000) != 0 && (c2 & 0x20) == 0 || c <= '\u001f' && (1 << (c & 0x1F) & 0xF0003E00) != 0;
    }

    public static boolean isISOControl(char c) {
        return Character.getType(c) == 15;
    }

    public static native int getType(char var0);

    public static char forDigit(int n, int n2) {
        if (n2 < 2 || n2 > 36 || n < 0 || n >= n2) {
            return '\u0000';
        }
        return (char)(n < 10 ? 48 + n : 87 + n);
    }

    public static native byte getDirectionality(char var0);

    public static boolean isMirrored(char c) {
        return (Character.readChar(c) & 0x40) != 0;
    }

    public int compareTo(Character c) {
        return this.value - c.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Character)object);
    }

    public static Character valueOf(char c) {
        if (c > '\u007f') {
            return new Character(c);
        }
        Character[] characterArray = charCache;
        synchronized (characterArray) {
            try {
                if (charCache[c - '\u0000'] == null) {
                    Character.charCache[c - '\u0000'] = new Character(c);
                }
                Character c2 = charCache[c - '\u0000'];
                Object var3_3 = null;
                return c2;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public static char reverseBytes(char c) {
        return (char)(c >> 8 & 0xFF | c << 8 & 0xFF00);
    }

    public static char[] toChars(int n) {
        char[] cArray = new char[Character.charCount(n)];
        int n2 = Character.toChars(n, cArray, 0);
        return cArray;
    }

    public static int toChars(int n, char[] cArray, int n2) {
        int n3;
        if (!Character.isValidCodePoint(n)) {
            throw new IllegalArgumentException("not a valid code point: " + n);
        }
        if (Character.isSupplementaryCodePoint(n)) {
            int n4 = n - 65536;
            cArray[n2 + 1] = (char)(n4 % 1024 + 56320);
            cArray[n2] = (char)(n4 / 1024 + 55296);
            n3 = 2;
        } else {
            cArray[n2] = (char)n;
            n3 = 1;
        }
        return n3;
    }

    public static int charCount(int n) {
        if (n >= 65536) {
            return 2;
        }
        return 1;
    }

    public static boolean isSupplementaryCodePoint(int n) {
        return n >= 65536 && n <= 0x10FFFF;
    }

    public static boolean isValidCodePoint(int n) {
        return n >= 0 && n <= 0x10FFFF;
    }

    public static boolean isHighSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isLowSurrogate(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    public static boolean isSurrogatePair(char c, char c2) {
        return Character.isHighSurrogate(c) && Character.isLowSurrogate(c2);
    }

    public static int toCodePoint(char c, char c2) {
        return (c - 55296) * 1024 + (c2 - 56320) + 65536;
    }

    public static int codePointAt(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException();
        }
        char c = charSequence.charAt(n);
        if (!Character.isHighSurrogate(c) || ++n >= n2) {
            return c;
        }
        char c2 = charSequence.charAt(n);
        if (!Character.isLowSurrogate(c2)) {
            return c;
        }
        return Character.toCodePoint(c, c2);
    }

    public static int codePointAt(char[] cArray, int n) {
        return Character.codePointAt(cArray, n, cArray.length);
    }

    public static int codePointAt(char[] cArray, int n, int n2) {
        if (n < 0 || n >= n2 || n2 < 0 || n2 >= cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        char c = cArray[n];
        if (!Character.isHighSurrogate(c) || ++n >= n2) {
            return c;
        }
        char c2 = cArray[n];
        if (!Character.isLowSurrogate(c2)) {
            return c;
        }
        return Character.toCodePoint(c, c2);
    }

    public static int codePointBefore(char[] cArray, int n) {
        return Character.codePointBefore(cArray, n, 1);
    }

    public static int codePointBefore(char[] cArray, int n, int n2) {
        char c;
        if (n < n2 || n > cArray.length || n2 < 0 || n2 >= cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!Character.isLowSurrogate(c = cArray[--n]) || --n < n2) {
            return c;
        }
        char c2 = cArray[n];
        if (!Character.isHighSurrogate(c2)) {
            return c;
        }
        return Character.toCodePoint(c2, c);
    }

    public static int codePointBefore(CharSequence charSequence, int n) {
        char c;
        int n2 = charSequence.length();
        if (n < 1 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (!Character.isLowSurrogate(c = charSequence.charAt(--n)) || --n < 0) {
            return c;
        }
        char c2 = charSequence.charAt(n);
        if (!Character.isHighSurrogate(c2)) {
            return c;
        }
        return Character.toCodePoint(c2, c);
    }

    public static final class UnicodeBlock
    extends Subset {
        private final int start;
        private final int end;
        private final String canonicalName;
        private static final int CANONICAL_NAME = 0;
        private static final int NO_SPACES_NAME = 1;
        private static final int CONSTANT_NAME = 2;
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock(0, 127, "BASIC_LATIN", "Basic Latin");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock(128, 255, "LATIN_1_SUPPLEMENT", "Latin-1 Supplement");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock(256, 383, "LATIN_EXTENDED_A", "Latin Extended-A");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock(384, 591, "LATIN_EXTENDED_B", "Latin Extended-B");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock(592, 687, "IPA_EXTENSIONS", "IPA Extensions");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock(688, 767, "SPACING_MODIFIER_LETTERS", "Spacing Modifier Letters");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock(768, 879, "COMBINING_DIACRITICAL_MARKS", "Combining Diacritical Marks");
        public static final UnicodeBlock GREEK = new UnicodeBlock(880, 1023, "GREEK", "Greek");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock(1024, 1279, "CYRILLIC", "Cyrillic");
        public static final UnicodeBlock CYRILLIC_SUPPLEMENTARY = new UnicodeBlock(1280, 1327, "CYRILLIC_SUPPLEMENTARY", "Cyrillic Supplementary");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock(1328, 1423, "ARMENIAN", "Armenian");
        public static final UnicodeBlock HEBREW = new UnicodeBlock(1424, 1535, "HEBREW", "Hebrew");
        public static final UnicodeBlock ARABIC = new UnicodeBlock(1536, 1791, "ARABIC", "Arabic");
        public static final UnicodeBlock SYRIAC = new UnicodeBlock(1792, 1871, "SYRIAC", "Syriac");
        public static final UnicodeBlock THAANA = new UnicodeBlock(1920, 1983, "THAANA", "Thaana");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock(2304, 2431, "DEVANAGARI", "Devanagari");
        public static final UnicodeBlock BENGALI = new UnicodeBlock(2432, 2559, "BENGALI", "Bengali");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock(2560, 2687, "GURMUKHI", "Gurmukhi");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock(2688, 2815, "GUJARATI", "Gujarati");
        public static final UnicodeBlock ORIYA = new UnicodeBlock(2816, 2943, "ORIYA", "Oriya");
        public static final UnicodeBlock TAMIL = new UnicodeBlock(2944, 3071, "TAMIL", "Tamil");
        public static final UnicodeBlock TELUGU = new UnicodeBlock(3072, 3199, "TELUGU", "Telugu");
        public static final UnicodeBlock KANNADA = new UnicodeBlock(3200, 3327, "KANNADA", "Kannada");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock(3328, 3455, "MALAYALAM", "Malayalam");
        public static final UnicodeBlock SINHALA = new UnicodeBlock(3456, 3583, "SINHALA", "Sinhala");
        public static final UnicodeBlock THAI = new UnicodeBlock(3584, 3711, "THAI", "Thai");
        public static final UnicodeBlock LAO = new UnicodeBlock(3712, 3839, "LAO", "Lao");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock(3840, 4095, "TIBETAN", "Tibetan");
        public static final UnicodeBlock MYANMAR = new UnicodeBlock(4096, 4255, "MYANMAR", "Myanmar");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock(4256, 4351, "GEORGIAN", "Georgian");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock(4352, 4607, "HANGUL_JAMO", "Hangul Jamo");
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock(4608, 4991, "ETHIOPIC", "Ethiopic");
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock(5024, 5119, "CHEROKEE", "Cherokee");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock(5120, 5759, "UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", "Unified Canadian Aboriginal Syllabics");
        public static final UnicodeBlock OGHAM = new UnicodeBlock(5760, 5791, "OGHAM", "Ogham");
        public static final UnicodeBlock RUNIC = new UnicodeBlock(5792, 5887, "RUNIC", "Runic");
        public static final UnicodeBlock TAGALOG = new UnicodeBlock(5888, 5919, "TAGALOG", "Tagalog");
        public static final UnicodeBlock HANUNOO = new UnicodeBlock(5920, 5951, "HANUNOO", "Hanunoo");
        public static final UnicodeBlock BUHID = new UnicodeBlock(5952, 5983, "BUHID", "Buhid");
        public static final UnicodeBlock TAGBANWA = new UnicodeBlock(5984, 6015, "TAGBANWA", "Tagbanwa");
        public static final UnicodeBlock KHMER = new UnicodeBlock(6016, 6143, "KHMER", "Khmer");
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock(6144, 6319, "MONGOLIAN", "Mongolian");
        public static final UnicodeBlock LIMBU = new UnicodeBlock(6400, 6479, "LIMBU", "Limbu");
        public static final UnicodeBlock TAI_LE = new UnicodeBlock(6480, 6527, "TAI_LE", "Tai Le");
        public static final UnicodeBlock KHMER_SYMBOLS = new UnicodeBlock(6624, 6655, "KHMER_SYMBOLS", "Khmer Symbols");
        public static final UnicodeBlock PHONETIC_EXTENSIONS = new UnicodeBlock(7424, 7551, "PHONETIC_EXTENSIONS", "Phonetic Extensions");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock(7680, 7935, "LATIN_EXTENDED_ADDITIONAL", "Latin Extended Additional");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock(7936, 8191, "GREEK_EXTENDED", "Greek Extended");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock(8192, 8303, "GENERAL_PUNCTUATION", "General Punctuation");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock(8304, 8351, "SUPERSCRIPTS_AND_SUBSCRIPTS", "Superscripts and Subscripts");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock(8352, 8399, "CURRENCY_SYMBOLS", "Currency Symbols");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock(8400, 8447, "COMBINING_MARKS_FOR_SYMBOLS", "Combining Marks for Symbols");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock(8448, 8527, "LETTERLIKE_SYMBOLS", "Letterlike Symbols");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock(8528, 8591, "NUMBER_FORMS", "Number Forms");
        public static final UnicodeBlock ARROWS = new UnicodeBlock(8592, 8703, "ARROWS", "Arrows");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock(8704, 8959, "MATHEMATICAL_OPERATORS", "Mathematical Operators");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock(8960, 9215, "MISCELLANEOUS_TECHNICAL", "Miscellaneous Technical");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock(9216, 9279, "CONTROL_PICTURES", "Control Pictures");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock(9280, 9311, "OPTICAL_CHARACTER_RECOGNITION", "Optical Character Recognition");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock(9312, 9471, "ENCLOSED_ALPHANUMERICS", "Enclosed Alphanumerics");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock(9472, 9599, "BOX_DRAWING", "Box Drawing");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock(9600, 9631, "BLOCK_ELEMENTS", "Block Elements");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock(9632, 9727, "GEOMETRIC_SHAPES", "Geometric Shapes");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock(9728, 9983, "MISCELLANEOUS_SYMBOLS", "Miscellaneous Symbols");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock(9984, 10175, "DINGBATS", "Dingbats");
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = new UnicodeBlock(10176, 10223, "MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", "Miscellaneous Mathematical Symbols-A");
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_A = new UnicodeBlock(10224, 10239, "SUPPLEMENTAL_ARROWS_A", "Supplemental Arrows-A");
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock(10240, 10495, "BRAILLE_PATTERNS", "Braille Patterns");
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_B = new UnicodeBlock(10496, 10623, "SUPPLEMENTAL_ARROWS_B", "Supplemental Arrows-B");
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = new UnicodeBlock(10624, 10751, "MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", "Miscellaneous Mathematical Symbols-B");
        public static final UnicodeBlock SUPPLEMENTAL_MATHEMATICAL_OPERATORS = new UnicodeBlock(10752, 11007, "SUPPLEMENTAL_MATHEMATICAL_OPERATORS", "Supplemental Mathematical Operators");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_ARROWS = new UnicodeBlock(11008, 11263, "MISCELLANEOUS_SYMBOLS_AND_ARROWS", "Miscellaneous Symbols and Arrows");
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock(11904, 12031, "CJK_RADICALS_SUPPLEMENT", "CJK Radicals Supplement");
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock(12032, 12255, "KANGXI_RADICALS", "Kangxi Radicals");
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock(12272, 12287, "IDEOGRAPHIC_DESCRIPTION_CHARACTERS", "Ideographic Description Characters");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock(12288, 12351, "CJK_SYMBOLS_AND_PUNCTUATION", "CJK Symbols and Punctuation");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock(12352, 12447, "HIRAGANA", "Hiragana");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock(12448, 12543, "KATAKANA", "Katakana");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock(12544, 12591, "BOPOMOFO", "Bopomofo");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock(12592, 12687, "HANGUL_COMPATIBILITY_JAMO", "Hangul Compatibility Jamo");
        public static final UnicodeBlock KANBUN = new UnicodeBlock(12688, 12703, "KANBUN", "Kanbun");
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock(12704, 12735, "BOPOMOFO_EXTENDED", "Bopomofo Extended");
        public static final UnicodeBlock KATAKANA_PHONETIC_EXTENSIONS = new UnicodeBlock(12784, 12799, "KATAKANA_PHONETIC_EXTENSIONS", "Katakana Phonetic Extensions");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock(12800, 13055, "ENCLOSED_CJK_LETTERS_AND_MONTHS", "Enclosed CJK Letters and Months");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock(13056, 13311, "CJK_COMPATIBILITY", "CJK Compatibility");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock(13312, 19903, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", "CJK Unified Ideographs Extension A");
        public static final UnicodeBlock YIJING_HEXAGRAM_SYMBOLS = new UnicodeBlock(19904, 19967, "YIJING_HEXAGRAM_SYMBOLS", "Yijing Hexagram Symbols");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock(19968, 40959, "CJK_UNIFIED_IDEOGRAPHS", "CJK Unified Ideographs");
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock(40960, 42127, "YI_SYLLABLES", "Yi Syllables");
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock(42128, 42191, "YI_RADICALS", "Yi Radicals");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock(44032, 55215, "HANGUL_SYLLABLES", "Hangul Syllables");
        public static final UnicodeBlock HIGH_SURROGATES = new UnicodeBlock(55296, 56191, "HIGH_SURROGATES", "High Surrogates");
        public static final UnicodeBlock HIGH_PRIVATE_USE_SURROGATES = new UnicodeBlock(56192, 56319, "HIGH_PRIVATE_USE_SURROGATES", "High Private Use Surrogates");
        public static final UnicodeBlock LOW_SURROGATES = new UnicodeBlock(56320, 57343, "LOW_SURROGATES", "Low Surrogates");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock(57344, 63743, "PRIVATE_USE_AREA", "Private Use Area");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock(63744, 64255, "CJK_COMPATIBILITY_IDEOGRAPHS", "CJK Compatibility Ideographs");
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock(64256, 64335, "ALPHABETIC_PRESENTATION_FORMS", "Alphabetic Presentation Forms");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock(64336, 65023, "ARABIC_PRESENTATION_FORMS_A", "Arabic Presentation Forms-A");
        public static final UnicodeBlock VARIATION_SELECTORS = new UnicodeBlock(65024, 65039, "VARIATION_SELECTORS", "Variation Selectors");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock(65056, 65071, "COMBINING_HALF_MARKS", "Combining Half Marks");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock(65072, 65103, "CJK_COMPATIBILITY_FORMS", "CJK Compatibility Forms");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock(65104, 65135, "SMALL_FORM_VARIANTS", "Small Form Variants");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock(65136, 65279, "ARABIC_PRESENTATION_FORMS_B", "Arabic Presentation Forms-B");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock(65280, 65519, "HALFWIDTH_AND_FULLWIDTH_FORMS", "Halfwidth and Fullwidth Forms");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock(65520, 65535, "SPECIALS", "Specials");
        public static final UnicodeBlock LINEAR_B_SYLLABARY = new UnicodeBlock(65536, 65663, "LINEAR_B_SYLLABARY", "Linear B Syllabary");
        public static final UnicodeBlock LINEAR_B_IDEOGRAMS = new UnicodeBlock(65664, 65791, "LINEAR_B_IDEOGRAMS", "Linear B Ideograms");
        public static final UnicodeBlock AEGEAN_NUMBERS = new UnicodeBlock(65792, 65855, "AEGEAN_NUMBERS", "Aegean Numbers");
        public static final UnicodeBlock OLD_ITALIC = new UnicodeBlock(66304, 66351, "OLD_ITALIC", "Old Italic");
        public static final UnicodeBlock GOTHIC = new UnicodeBlock(66352, 66383, "GOTHIC", "Gothic");
        public static final UnicodeBlock UGARITIC = new UnicodeBlock(66432, 66463, "UGARITIC", "Ugaritic");
        public static final UnicodeBlock DESERET = new UnicodeBlock(66560, 66639, "DESERET", "Deseret");
        public static final UnicodeBlock SHAVIAN = new UnicodeBlock(66640, 66687, "SHAVIAN", "Shavian");
        public static final UnicodeBlock OSMANYA = new UnicodeBlock(66688, 66735, "OSMANYA", "Osmanya");
        public static final UnicodeBlock CYPRIOT_SYLLABARY = new UnicodeBlock(67584, 67647, "CYPRIOT_SYLLABARY", "Cypriot Syllabary");
        public static final UnicodeBlock BYZANTINE_MUSICAL_SYMBOLS = new UnicodeBlock(118784, 119039, "BYZANTINE_MUSICAL_SYMBOLS", "Byzantine Musical Symbols");
        public static final UnicodeBlock MUSICAL_SYMBOLS = new UnicodeBlock(119040, 119295, "MUSICAL_SYMBOLS", "Musical Symbols");
        public static final UnicodeBlock TAI_XUAN_JING_SYMBOLS = new UnicodeBlock(119552, 119647, "TAI_XUAN_JING_SYMBOLS", "Tai Xuan Jing Symbols");
        public static final UnicodeBlock MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeBlock(119808, 120831, "MATHEMATICAL_ALPHANUMERIC_SYMBOLS", "Mathematical Alphanumeric Symbols");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeBlock(131072, 173791, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", "CJK Unified Ideographs Extension B");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = new UnicodeBlock(194560, 195103, "CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", "CJK Compatibility Ideographs Supplement");
        public static final UnicodeBlock TAGS = new UnicodeBlock(917504, 917631, "TAGS", "Tags");
        public static final UnicodeBlock VARIATION_SELECTORS_SUPPLEMENT = new UnicodeBlock(917760, 917999, "VARIATION_SELECTORS_SUPPLEMENT", "Variation Selectors Supplement");
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_A = new UnicodeBlock(983040, 1048575, "SUPPLEMENTARY_PRIVATE_USE_AREA_A", "Supplementary Private Use Area-A");
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_B = new UnicodeBlock(0x100000, 0x10FFFF, "SUPPLEMENTARY_PRIVATE_USE_AREA_B", "Supplementary Private Use Area-B");
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock(55296, 57343, "SURROGATES_AREA", "Surrogates Area");
        private static final UnicodeBlock[] sets = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, CYRILLIC_SUPPLEMENTARY, ARMENIAN, HEBREW, ARABIC, SYRIAC, THAANA, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, TAGALOG, HANUNOO, BUHID, TAGBANWA, KHMER, MONGOLIAN, LIMBU, TAI_LE, KHMER_SYMBOLS, PHONETIC_EXTENSIONS, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, SUPPLEMENTAL_ARROWS_A, BRAILLE_PATTERNS, SUPPLEMENTAL_ARROWS_B, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, SUPPLEMENTAL_MATHEMATICAL_OPERATORS, MISCELLANEOUS_SYMBOLS_AND_ARROWS, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, KATAKANA_PHONETIC_EXTENSIONS, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, YIJING_HEXAGRAM_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, HANGUL_SYLLABLES, HIGH_SURROGATES, HIGH_PRIVATE_USE_SURROGATES, LOW_SURROGATES, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, VARIATION_SELECTORS, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS, LINEAR_B_SYLLABARY, LINEAR_B_IDEOGRAMS, AEGEAN_NUMBERS, OLD_ITALIC, GOTHIC, UGARITIC, DESERET, SHAVIAN, OSMANYA, CYPRIOT_SYLLABARY, BYZANTINE_MUSICAL_SYMBOLS, MUSICAL_SYMBOLS, TAI_XUAN_JING_SYMBOLS, MATHEMATICAL_ALPHANUMERIC_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, TAGS, VARIATION_SELECTORS_SUPPLEMENT, SUPPLEMENTARY_PRIVATE_USE_AREA_A, SUPPLEMENTARY_PRIVATE_USE_AREA_B};

        UnicodeBlock(int n, int n2, String string, String string2) {
            super(string);
            this.start = n;
            this.end = n2;
            this.canonicalName = string2;
        }

        public static UnicodeBlock of(char c) {
            return UnicodeBlock.of((int)c);
        }

        public static UnicodeBlock of(int n) {
            if (n > 0x10FFFF) {
                throw new IllegalArgumentException("The supplied integer value is too large to be a codepoint.");
            }
            int n2 = 0;
            int n3 = sets.length - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >> 1;
                UnicodeBlock unicodeBlock = sets[n4];
                if (n < unicodeBlock.start) {
                    n3 = n4 - 1;
                    continue;
                }
                if (n > unicodeBlock.end) {
                    n2 = n4 + 1;
                    continue;
                }
                return unicodeBlock;
            }
            return null;
        }

        public static final UnicodeBlock forName(String string) {
            int n = string.indexOf(32) != -1 ? 0 : (string.indexOf(95) != -1 ? 2 : 1);
            Collator collator = Collator.getInstance(Locale.US);
            collator.setStrength(0);
            switch (n) {
                case 0: {
                    if (collator.compare(string, "Surrogates Area") != 0) break;
                    return SURROGATES_AREA;
                }
                case 1: {
                    if (collator.compare(string, "SurrogatesArea") != 0) break;
                    return SURROGATES_AREA;
                }
                case 2: {
                    if (collator.compare(string, "SURROGATES_AREA") != 0) break;
                    return SURROGATES_AREA;
                }
            }
            int n2 = sets.length;
            switch (n) {
                case 0: {
                    for (int i = 0; i < n2; ++i) {
                        UnicodeBlock unicodeBlock = sets[i];
                        if (collator.compare(string, unicodeBlock.canonicalName) != 0) continue;
                        return unicodeBlock;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < n2; ++i) {
                        UnicodeBlock unicodeBlock = sets[i];
                        String string2 = unicodeBlock.canonicalName.replaceAll(" ", "");
                        if (collator.compare(string, string2) != 0) continue;
                        return unicodeBlock;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n2; ++i) {
                        UnicodeBlock unicodeBlock = sets[i];
                        if (collator.compare(string, unicodeBlock.toString()) != 0) continue;
                        return unicodeBlock;
                    }
                    break;
                }
            }
            throw new IllegalArgumentException("No Unicode block found for " + string + ".");
        }
    }

    public static class Subset {
        private final String name;

        protected Subset(String string) {
            this.name = string.toString();
        }

        public final boolean equals(Object object) {
            return object == this;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }
}

