/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.NullOutputStream;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import gnu.java.security.provider.Gnu;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.VMObjectStreamClass;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectStreamClass
implements Serializable {
    static final Class[] noArgs = new Class[0];
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Hashtable classLookupTable = new Hashtable();
    private static final NullOutputStream nullOutputStream = new NullOutputStream();
    private static final Comparator interfaceComparator = new InterfaceComparator();
    private static final Comparator memberComparator = new MemberComparator();
    private static final Class[] writeMethodArgTypes = new Class[]{ObjectStreamClass.class$("java.io.ObjectOutputStream")};
    private ObjectStreamClass superClass;
    private Class clazz;
    private String name;
    private long uid;
    private byte flags;
    ObjectStreamField[] fields;
    int primFieldSize;
    int objectFieldCount;
    Method readObjectMethod;
    Method readResolveMethod;
    Method writeReplaceMethod;
    Method writeObjectMethod;
    boolean realClassIsSerializable;
    boolean realClassIsExternalizable;
    ObjectStreamField[] fieldMapping;
    Constructor firstNonSerializableParentConstructor;
    private Constructor constructor;
    boolean isProxyClass;
    private static final long serialVersionUID = -6120832682080437368L;

    private /* synthetic */ void finit$() {
        this.primFieldSize = -1;
        this.isProxyClass = false;
    }

    public static ObjectStreamClass lookup(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (!ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(clazz)) {
            return null;
        }
        return ObjectStreamClass.lookupForClassObject(clazz);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ObjectStreamClass lookupForClassObject(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)classLookupTable.get(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass;
        }
        objectStreamClass = new ObjectStreamClass(clazz);
        classLookupTable.put(clazz, objectStreamClass);
        return objectStreamClass;
    }

    public String getName() {
        return this.name;
    }

    public Class forClass() {
        return this.clazz;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
        System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
        return objectStreamFieldArray;
    }

    public ObjectStreamField getField(String string) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equals(string)) continue;
            return this.fields[i];
        }
        return null;
    }

    public String toString() {
        return "java.io.ObjectStreamClass< " + this.name + ", " + this.uid + " >";
    }

    boolean hasWriteMethod() {
        return (this.flags & 1) != 0;
    }

    boolean isSerializable() {
        return (this.flags & 2) != 0;
    }

    boolean isExternalizable() {
        return (this.flags & 4) != 0;
    }

    ObjectStreamClass getSuper() {
        return this.superClass;
    }

    static ObjectStreamClass[] getObjectStreamClasses(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass == null) {
            return new ObjectStreamClass[0];
        }
        Vector vector = new Vector();
        while (objectStreamClass != null) {
            vector.addElement(objectStreamClass);
            objectStreamClass = objectStreamClass.getSuper();
        }
        int n = vector.size();
        ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[n];
        for (int i = n - 1; i >= 0; --i) {
            objectStreamClassArray[n - i - 1] = (ObjectStreamClass)vector.elementAt(i);
        }
        return objectStreamClassArray;
    }

    int getFlags() {
        return this.flags;
    }

    ObjectStreamClass(String string, long l, byte by, ObjectStreamField[] objectStreamFieldArray) {
        this.finit$();
        this.name = string;
        this.uid = l;
        this.flags = by;
        this.fields = objectStreamFieldArray;
    }

    void setClass(Class clazz, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        this.clazz = clazz;
        this.cacheMethods();
        long l = this.getClassUID(clazz);
        if (this.uid == 0L) {
            this.uid = l;
        } else if (this.uid != l) {
            String string = clazz + ": Local class not compatible: stream serialVersionUID=" + this.uid + ", local serialVersionUID=" + l;
            throw new InvalidClassException(string);
        }
        this.isProxyClass = this.clazz != null && Proxy.isProxyClass(this.clazz);
        this.superClass = objectStreamClass;
        this.calculateOffsets();
        try {
            Object[] objectArray = this.getSerialPersistentFields(this.clazz);
            if (objectArray == null) {
                return;
            }
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[objectArray.length + this.fields.length];
            Arrays.sort(objectArray);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this.fields.length && n2 < objectArray.length) {
                int n4 = this.fields[n].compareTo(objectArray[n2]);
                if (n4 < 0) {
                    objectStreamFieldArray[n3] = this.fields[n];
                    this.fields[n].setPersistent(false);
                    this.fields[n].setToSet(false);
                    ++n;
                } else if (n4 > 0) {
                    objectStreamFieldArray[n3] = objectArray[n2];
                    objectStreamFieldArray[n3].setPersistent(true);
                    objectStreamFieldArray[n3].setToSet(false);
                    try {
                        objectStreamFieldArray[n3].lookupField(this.clazz);
                        objectStreamFieldArray[n3].checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    ++n2;
                } else {
                    try {
                        ((ObjectStreamField)objectArray[n2]).lookupField(this.clazz);
                        ((ObjectStreamField)objectArray[n2]).checkFieldType();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    if (!this.fields[n].getType().equals(((ObjectStreamField)objectArray[n2]).getType())) {
                        throw new InvalidClassException("serialPersistentFields must be compatible with imported fields (about " + this.fields[n].getName() + ")");
                    }
                    objectStreamFieldArray[n3] = this.fields[n];
                    this.fields[n].setPersistent(true);
                    ++n;
                    ++n2;
                }
                ++n3;
            }
            if (n < this.fields.length) {
                while (n < this.fields.length) {
                    this.fields[n].setPersistent(false);
                    this.fields[n].setToSet(false);
                    objectStreamFieldArray[n3] = this.fields[n];
                    ++n;
                    ++n3;
                }
            } else if (n2 < objectArray.length) {
                while (n2 < objectArray.length) {
                    ((ObjectStreamField)objectArray[n2]).setPersistent(true);
                    ((ObjectStreamField)objectArray[n2]).setToSet(false);
                    objectStreamFieldArray[n3] = objectArray[n2];
                    ++n2;
                    ++n3;
                }
            }
            this.fields = new ObjectStreamField[n3];
            System.arraycopy(objectStreamFieldArray, 0, this.fields, 0, n3);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }

    void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superClass = objectStreamClass;
    }

    void calculateOffsets() {
        ObjectStreamField objectStreamField;
        int n;
        this.primFieldSize = 0;
        int n2 = this.fields.length;
        block6: for (n = 0; n < n2 && (objectStreamField = this.fields[n]).isPrimitive(); ++n) {
            objectStreamField.setOffset(this.primFieldSize);
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primFieldSize;
                    continue block6;
                }
                case 'C': 
                case 'S': {
                    this.primFieldSize += 2;
                    continue block6;
                }
                case 'F': 
                case 'I': {
                    this.primFieldSize += 4;
                    continue block6;
                }
                case 'D': 
                case 'J': {
                    this.primFieldSize += 8;
                }
            }
        }
        this.objectFieldCount = 0;
        while (n < n2) {
            this.fields[n].setOffset(this.objectFieldCount++);
            ++n;
        }
    }

    private Method findMethod(Method[] methodArray, String string, Class[] classArray, Class clazz, boolean bl) {
        block0: for (int i = 0; i < methodArray.length; ++i) {
            Class[] classArray2;
            Method method = methodArray[i];
            int n = method.getModifiers();
            if (Modifier.isStatic(n) || bl && !Modifier.isPrivate(n) || !method.getName().equals(string) || method.getReturnType() != clazz || (classArray2 = method.getParameterTypes()).length != classArray.length) continue;
            for (int j = 0; j < classArray2.length; ++j) {
                if (classArray2[j] != classArray[j]) continue block0;
            }
            AccessController.doPrivileged(new SetAccessibleAction(method));
            return method;
        }
        return null;
    }

    private static boolean inSamePackage(Class clazz, Class clazz2) {
        String string = clazz.getName();
        String string2 = clazz2.getName();
        int n = string.lastIndexOf(46);
        int n2 = string2.lastIndexOf(46);
        if (n == -1 || n2 == -1) {
            return n == n2;
        }
        String string3 = string.substring(0, n);
        String string4 = string2.substring(0, n2);
        return string3.equals(string4);
    }

    private static Method findAccessibleMethod(String string, Class clazz) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                Method method = clazz2.getDeclaredMethod(string, noArgs);
                int n = method.getModifiers();
                if (clazz2 != clazz && !Modifier.isProtected(n) && !Modifier.isPublic(n) && (Modifier.isPrivate(n) || !ObjectStreamClass.inSamePackage(clazz2, clazz))) continue;
                AccessController.doPrivileged(new SetAccessibleAction(method));
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private void cacheMethods() {
        Method[] methodArray = this.forClass().getDeclaredMethods();
        this.readObjectMethod = this.findMethod(methodArray, "readObject", new Class[]{ObjectStreamClass.class$("java.io.ObjectInputStream")}, Void.TYPE, true);
        this.writeObjectMethod = this.findMethod(methodArray, "writeObject", new Class[]{ObjectStreamClass.class$("java.io.ObjectOutputStream")}, Void.TYPE, true);
        this.readResolveMethod = ObjectStreamClass.findAccessibleMethod("readResolve", this.forClass());
        this.writeReplaceMethod = ObjectStreamClass.findAccessibleMethod("writeReplace", this.forClass());
    }

    private ObjectStreamClass(Class clazz) {
        this.finit$();
        this.uid = 0L;
        this.flags = 0;
        this.isProxyClass = Proxy.isProxyClass(clazz);
        this.clazz = clazz;
        this.cacheMethods();
        this.name = clazz.getName();
        this.setFlags(clazz);
        this.setFields(clazz);
        if (ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(clazz) && !this.isProxyClass) {
            this.uid = this.getClassUID(clazz);
        }
        this.superClass = ObjectStreamClass.lookup(clazz.getSuperclass());
    }

    private void setFlags(Class clazz) {
        if (ObjectStreamClass.class$("java.io.Externalizable").isAssignableFrom(clazz)) {
            this.flags = (byte)(this.flags | 4);
        } else if (ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(clazz)) {
            this.flags = (byte)(this.flags | 2);
        }
        if (this.writeObjectMethod != null) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    private void setFields(Class clazz) {
        int n;
        SetAccessibleAction setAccessibleAction = new SetAccessibleAction();
        if (!this.isSerializable() || this.isExternalizable()) {
            this.fields = NO_FIELDS;
            return;
        }
        try {
            Field field = clazz.getDeclaredField("serialPersistentFields");
            setAccessibleAction.setMember(field);
            AccessController.doPrivileged(setAccessibleAction);
            int n2 = field.getModifiers();
            if (Modifier.isStatic(n2) && Modifier.isFinal(n2) && Modifier.isPrivate(n2)) {
                this.fields = this.getSerialPersistentFields(clazz);
                if (this.fields != null) {
                    Arrays.sort(this.fields);
                    for (int i = 0; i < this.fields.length; ++i) {
                        try {
                            this.fields[i].lookupField(clazz);
                            continue;
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            this.fields[i].setToSet(false);
                        }
                    }
                    this.calculateOffsets();
                    return;
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        int n3 = 0;
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            int n4 = fieldArray[n].getModifiers();
            if (Modifier.isTransient(n4) || Modifier.isStatic(n4)) {
                fieldArray[n] = null;
                continue;
            }
            ++n3;
        }
        this.fields = new ObjectStreamField[n3];
        n = 0;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i] == null) continue;
            Field field = fieldArray[i];
            setAccessibleAction.setMember(field);
            AccessController.doPrivileged(setAccessibleAction);
            this.fields[n] = new ObjectStreamField(fieldArray[i]);
            ++n;
        }
        Arrays.sort(this.fields);
        for (n = 1; n < this.fields.length; ++n) {
            if (!this.fields[n - 1].getName().equals(this.fields[n].getName())) continue;
            throw new InternalError("Duplicate field " + this.fields[n].getName() + " in class " + clazz.getName());
        }
        this.calculateOffsets();
    }

    private long getClassUID(Class clazz) {
        Object object;
        Object object2;
        try {
            object2 = clazz.getDeclaredField("serialVersionUID");
            object = new SetAccessibleAction((AccessibleObject)object2);
            AccessController.doPrivileged((PrivilegedAction)object);
            int n = ((Field)object2).getModifiers();
            if (Modifier.isStatic(n) && Modifier.isFinal(n) && ((Field)object2).getType() == Long.TYPE) {
                return ((Field)object2).getLong(null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            Object[] objectArray;
            try {
                object2 = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Gnu gnu = new Gnu();
                Security.addProvider(gnu);
                object2 = MessageDigest.getInstance("SHA");
            }
            object = new DigestOutputStream(nullOutputStream, (MessageDigest)object2);
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            dataOutputStream.writeUTF(clazz.getName());
            int n = clazz.getModifiers();
            dataOutputStream.writeInt(n &= 0x611);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, interfaceComparator);
                for (int i = 0; i < objectArray.length; ++i) {
                    dataOutputStream.writeUTF(((Class)objectArray[i]).getName());
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, memberComparator);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = objectArray[i];
                n = ((Field)object3).getModifiers();
                if (Modifier.isPrivate(n) && (Modifier.isStatic(n) || Modifier.isTransient(n))) continue;
                dataOutputStream.writeUTF(((Field)object3).getName());
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(TypeSignature.getEncodingOfClass(((Field)object3).getType()));
            }
            if (VMObjectStreamClass.hasClassInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            Object[] objectArray2 = clazz.getDeclaredConstructors();
            Arrays.sort(objectArray2, memberComparator);
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object4 = objectArray2[i];
                n = ((Constructor)object4).getModifiers();
                if (Modifier.isPrivate(n)) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(TypeSignature.getEncodingOfConstructor((Constructor)object4).replace('/', '.'));
            }
            Object[] objectArray3 = clazz.getDeclaredMethods();
            Arrays.sort(objectArray3, memberComparator);
            for (int i = 0; i < objectArray3.length; ++i) {
                Object object5 = objectArray3[i];
                n = ((Method)object5).getModifiers();
                if (Modifier.isPrivate(n)) continue;
                dataOutputStream.writeUTF(((Method)object5).getName());
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(TypeSignature.getEncodingOfMethod((Method)object5).replace('/', '.'));
            }
            dataOutputStream.close();
            byte[] byArray = ((MessageDigest)object2).digest();
            long l = 0L;
            int n2 = byArray.length < 8 ? byArray.length : 8;
            for (int i = 0; i < n2; ++i) {
                l += ((long)byArray[i] & (long)255) << (8 * i & 0x3F);
            }
            return l;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("The SHA algorithm was not found to use in computing the Serial Version UID for class " + clazz.getName(), noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private ObjectStreamField[] getSerialPersistentFields(Class clazz) throws NoSuchFieldException, IllegalAccessException {
        ObjectStreamField[] objectStreamFieldArray = null;
        Field field = clazz.getDeclaredField("serialPersistentFields");
        field.setAccessible(true);
        int n = field.getModifiers();
        if (!(Modifier.isStatic(n) && Modifier.isFinal(n) && Modifier.isPrivate(n))) {
            return null;
        }
        ObjectStreamField[] objectStreamFieldArray2 = (ObjectStreamField[])field.get(null);
        if (objectStreamFieldArray2 == null) {
            return null;
        }
        objectStreamFieldArray = new ObjectStreamField[objectStreamFieldArray2.length];
        System.arraycopy(objectStreamFieldArray2, 0, objectStreamFieldArray, 0, objectStreamFieldArray2.length);
        return objectStreamFieldArray;
    }

    Externalizable newInstance() throws InvalidClassException {
        Object object;
        ObjectStreamClass objectStreamClass = this;
        synchronized (objectStreamClass) {
            try {
                if (this.constructor == null) {
                    try {
                        object = this.clazz.getConstructor(new Class[0]);
                        AccessController.doPrivileged(new PrivilegedAction(this, (Constructor)object){
                            private /* synthetic */ ObjectStreamClass this$0;
                            private /* synthetic */ Constructor val$c;
                            {
                                this.this$0 = objectStreamClass;
                                this.finit$(constructor);
                            }

                            private /* synthetic */ void finit$(Constructor constructor) {
                                this.val$c = constructor;
                            }

                            public Object run() {
                                this.val$c.setAccessible(true);
                                return null;
                            }
                        });
                        this.constructor = object;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new InvalidClassException(this.clazz.getName(), "No public zero-argument constructor");
                    }
                }
                object = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
        try {
            object = (Externalizable)this.constructor.newInstance(null);
            return object;
        }
        catch (Exception exception) {
            throw (InvalidClassException)new InvalidClassException(this.clazz.getName(), "Unable to instantiate").initCause(exception);
        }
    }

    private static final class MemberComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Member member = (Member)object;
            Member member2 = (Member)object2;
            int n = member.getName().compareTo(member2.getName());
            if (n == 0) {
                return TypeSignature.getEncodingOfMember(member).compareTo(TypeSignature.getEncodingOfMember(member2));
            }
            return n;
        }

        MemberComparator() {
        }
    }

    private static final class InterfaceComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((Class)object).getName().compareTo(((Class)object2).getName());
        }

        InterfaceComparator() {
        }
    }
}

