/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.channels.FileChannelImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private FileChannelImpl ch;

    public FileInputStream(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public FileInputStream(File file) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(file.getPath());
        }
        this.ch = new FileChannelImpl(file, 1);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.ch = (FileChannelImpl)fileDescriptor.channel;
    }

    FileInputStream(FileChannelImpl fileChannelImpl) {
        this.ch = fileChannelImpl;
    }

    public int available() throws IOException {
        return this.ch.available();
    }

    public void close() throws IOException {
        this.ch.close();
    }

    protected void finalize() throws IOException {
    }

    public final FileDescriptor getFD() throws IOException {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            try {
                if (this.fd == null) {
                    this.fd = new FileDescriptor(this.ch);
                }
                FileDescriptor fileDescriptor = this.fd;
                Object var3_3 = null;
                return fileDescriptor;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        return this.ch.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.ch.read(byArray, n, n2);
    }

    public synchronized long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Can't skip negative bytes: " + l);
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = this.ch.position();
        this.ch.position(l2 + l);
        return this.ch.position() - l2;
    }

    public synchronized FileChannel getChannel() {
        return this.ch;
    }
}

