/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 512);
    }

    public BufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.buf = new byte[n];
    }

    public synchronized void flush() throws IOException {
        if (this.count == 0) {
            return;
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
        this.out.flush();
    }

    public synchronized void write(int n) throws IOException {
        if (this.count == this.buf.length) {
            this.flush();
        }
        this.buf[this.count] = (byte)n & 0xFFFFFFFF;
        ++this.count;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < this.buf.length - this.count) {
            System.arraycopy(byArray, n, this.buf, this.count, n2);
            this.count += n2;
        } else {
            this.flush();
            this.out.write(byArray, n, n2);
        }
    }
}

