/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    private /* synthetic */ void finit$() {
        this.canFilterIndexColorModel = false;
    }

    public RGBImageFilter() {
        this.finit$();
    }

    public void setColorModel(ColorModel colorModel) {
        this.origmodel = colorModel;
        this.newmodel = colorModel;
        if (colorModel instanceof IndexColorModel && this.canFilterIndexColorModel) {
            this.newmodel = this.filterIndexColorModel((IndexColorModel)colorModel);
            if (this.consumer != null) {
                this.consumer.setColorModel(this.newmodel);
            }
        } else if (this.consumer != null) {
            this.consumer.setColorModel(ColorModel.getRGBdefault());
        }
    }

    public void substituteColorModel(ColorModel colorModel, ColorModel colorModel2) {
        this.origmodel = colorModel;
        this.newmodel = colorModel2;
    }

    public IndexColorModel filterIndexColorModel(IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        indexColorModel.getAlphas(byArray4);
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < n; ++i) {
            int n2 = this.filterRGB(-1, -1, this.makeColor(byArray4[i], byArray[i], byArray2[i], byArray3[i]));
            byArray4[i] = (byte)((0xFF000000 & n2) >> 24);
            byArray[i] = (byte)((0xFF0000 & n2) >> 16);
            byArray2[i] = (byte)((0xFF00 & n2) >> 8);
            byArray3[i] = (byte)n2 & 0xFFFFFFFF;
        }
        return new IndexColorModel(indexColorModel.getPixelSize(), n, byArray, byArray2, byArray3, byArray4);
    }

    private int makeColor(byte by, byte by2, byte by3, byte by4) {
        return 0xFF000000 & by << 24 | 0xFF0000 & by2 << 16 | 0xFF00 & by3 << 8 | 0xFF & by4;
    }

    public void filterRGBPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray[n5 + j] = this.filterRGB(j + n, i + n2, nArray[n5 + j]);
            }
            n5 += n6;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        if (colorModel == this.origmodel && colorModel instanceof IndexColorModel && this.canFilterIndexColorModel) {
            if (this.consumer != null) {
                this.consumer.setPixels(n, n2, n3, n4, this.newmodel, byArray, n5, n6);
            }
        } else {
            int[] nArray = this.convertColorModelToDefault(n, n2, n3, n4, colorModel, byArray, n5, n6);
            this.filterRGBPixels(n, n2, n3, n4, nArray, n5, n6);
            if (this.consumer != null) {
                this.consumer.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
            }
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == this.origmodel && colorModel instanceof IndexColorModel && this.canFilterIndexColorModel) {
            if (this.consumer != null) {
                this.consumer.setPixels(n, n2, n3, n4, this.newmodel, nArray, n5, n6);
            }
        } else {
            this.convertColorModelToDefault(n, n2, n3, n4, colorModel, nArray, n5, n6);
            this.filterRGBPixels(n, n2, n3, n4, nArray, n5, n6);
            if (this.consumer != null) {
                this.consumer.setPixels(n, n2, n3, n4, ColorModel.getRGBdefault(), nArray, n5, n6);
            }
        }
    }

    private int[] convertColorModelToDefault(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = this.makeColorbyDefaultCM(colorModel, byArray[i]);
        }
        return nArray;
    }

    private void convertColorModelToDefault(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.makeColorbyDefaultCM(colorModel, nArray[i]);
        }
    }

    private int makeColorbyDefaultCM(ColorModel colorModel, byte by) {
        return this.makeColor(colorModel.getAlpha(by) * 4, colorModel.getRed(by) * 4, colorModel.getGreen(by) * 4, colorModel.getBlue(by) * 4);
    }

    private int makeColorbyDefaultCM(ColorModel colorModel, int n) {
        return this.makeColor(colorModel.getAlpha(n), colorModel.getRed(n), colorModel.getGreen(n), colorModel.getBlue(n));
    }

    private int makeColor(int n, int n2, int n3, int n4) {
        return 0xFF000000 & n << 24 | 0xFF0000 & n2 << 16 | 0xFF00 & n3 << 8 | 0xFF & n4;
    }

    public abstract int filterRGB(int var1, int var2, int var3);
}

