/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    public static final int TYPE_BILINEAR = 2;
    public static final int TYPE_BICUBIC = 3;
    private AffineTransform transform;
    private RenderingHints hints;

    public AffineTransformOp(AffineTransform affineTransform, int n) {
        this.transform = affineTransform;
        if (affineTransform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
        switch (n) {
            case 2: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, "Bilinear image interpolation mode");
                break;
            }
            case 3: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, "Bicubic image interpolation mode");
                break;
            }
            default: {
                this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, "Nearest Neighbor image interpolation mode");
            }
        }
    }

    public AffineTransformOp(AffineTransform affineTransform, RenderingHints renderingHints) {
        this.transform = affineTransform;
        this.hints = renderingHints;
        if (affineTransform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        if (colorModel == null) {
            colorModel = bufferedImage.getColorModel();
        }
        return new BufferedImage(colorModel, this.createCompatibleDestRaster(bufferedImage.getRaster()), bufferedImage.isAlphaPremultiplied(), null);
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        Rectangle rectangle = (Rectangle)this.getBounds2D(raster);
        if (rectangle.getWidth() == 0.0 || rectangle.getHeight() == 0.0) {
            throw new RasterFormatException("width or height is 0");
        }
        return raster.createCompatibleWritableRaster((int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage2 == bufferedImage) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHints(this.hints);
        graphics2D.drawImage(bufferedImage, this.transform, null);
        return bufferedImage2;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (writableRaster == raster) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        if (raster.getNumBands() != writableRaster.getNumBands()) {
            throw new IllegalArgumentException("src and dst must have same number of bands");
        }
        double[] dArray = new double[writableRaster.getWidth() * 2];
        double[] dArray2 = new double[writableRaster.getWidth() * 2];
        for (int i = 0; i < writableRaster.getWidth(); ++i) {
            dArray[2 * i] = i + writableRaster.getMinX();
            dArray[2 * i + 1] = i;
        }
        Rectangle rectangle = raster.getBounds();
        if (this.hints.containsValue("Nearest Neighbor image interpolation mode")) {
            for (int i = writableRaster.getMinY(); i < writableRaster.getMinY() + writableRaster.getHeight(); ++i) {
                try {
                    this.transform.inverseTransform(dArray, 0, dArray2, 0, writableRaster.getWidth() * 2);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    noninvertibleTransformException.printStackTrace();
                }
                for (int j = 0; j < writableRaster.getWidth(); ++j) {
                    if (!rectangle.contains(dArray2[2 * j], dArray2[2 * j + 1])) continue;
                    writableRaster.setDataElements(j + writableRaster.getMinX(), i, raster.getDataElements((int)dArray2[2 * j], (int)dArray2[2 * j + 1], null));
                }
            }
        } else if (this.hints.containsValue("Bilinear image interpolation mode")) {
            double[] dArray3 = new double[4 * raster.getNumBands()];
            for (int i = writableRaster.getMinY(); i < writableRaster.getMinY() + writableRaster.getHeight(); ++i) {
                try {
                    this.transform.inverseTransform(dArray, 0, dArray2, 0, writableRaster.getWidth() * 2);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    noninvertibleTransformException.printStackTrace();
                }
                for (int j = 0; j < writableRaster.getWidth(); ++j) {
                    if (!rectangle.contains(dArray2[2 * j], dArray2[2 * j + 1])) continue;
                    int n = (int)dArray2[2 * j];
                    int n2 = (int)dArray2[2 * j + 1];
                    double d = dArray2[2 * j] - (double)n;
                    double d2 = dArray2[2 * j + 1] - (double)n2;
                    if (n == raster.getMinX() + raster.getWidth() - 1 || n2 == raster.getMinY() + raster.getHeight() - 1) {
                        Arrays.fill(dArray3, 0.0);
                        raster.getPixel(n, n2, dArray3);
                    } else {
                        raster.getPixels(n, n2, 2, 2, dArray3);
                        for (int k = 0; k < raster.getNumBands(); ++k) {
                            dArray3[k] = d * d2 * dArray3[k] + (1.0 - d) * d2 * dArray3[k + raster.getNumBands()] + d * (1.0 - d2) * dArray3[k + 2 * raster.getNumBands()] + (1.0 - d) * (1.0 - d2) * dArray3[k + 3 * raster.getNumBands()];
                        }
                    }
                    writableRaster.setPixel(j, i, dArray3);
                }
            }
        } else {
            throw new UnsupportedOperationException("not implemented yet");
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        double d = (double)raster.getWidth() + (double)raster.getMinX();
        double d2 = (double)raster.getHeight() + (double)raster.getMinY();
        Point2D point2D = this.getPoint2D(new Point2D.Double(d, d2), null);
        Rectangle rectangle = new Rectangle(0, 0, (int)point2D.getX(), (int)point2D.getY());
        return ((RectangularShape)rectangle).getBounds();
    }

    public final int getInterpolationType() {
        if (this.hints.containsValue("Bilinear image interpolation mode")) {
            return 2;
        }
        return 1;
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return this.transform.transform(point2D, point2D2);
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final AffineTransform getTransform() {
        return this.transform;
    }
}

