/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class DataFlavor
implements Externalizable,
Cloneable {
    static final long serialVersionUID = 8367026044764648243L;
    public static final DataFlavor plainTextFlavor;
    public static final DataFlavor stringFlavor;
    public static final DataFlavor javaFileListFlavor;
    public static final DataFlavor imageFlavor;
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private final String mimeType;
    private final Class representationClass;
    private String humanPresentableName;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final Class tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            throw new ClassNotFoundException(string);
        }
    }

    public DataFlavor() {
        this.mimeType = null;
        this.representationClass = null;
        this.humanPresentableName = null;
    }

    private DataFlavor(Class clazz, String string, String string2) {
        this.representationClass = clazz;
        this.mimeType = string;
        this.humanPresentableName = string2 != null ? string2 : string;
    }

    public DataFlavor(Class clazz, String string) {
        this(clazz, "application/x-java-serialized-object; class=" + clazz.getName(), string);
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        this(DataFlavor.getRepresentationClassFromMime(string, classLoader), string, string2);
    }

    private static Class getRepresentationClassFromMime(String string, ClassLoader classLoader) {
        String string2 = DataFlavor.getParameter("class", string);
        if (string2 != null) {
            try {
                return DataFlavor.tryToLoadClass(string2, classLoader);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("classname: " + exception.getMessage());
            }
        }
        return DataFlavor.class$("java.io.InputStream");
    }

    public DataFlavor(String string, String string2) {
        this(DataFlavor.getRepresentationClassFromMime(string, null), string, string2);
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        this(string, null);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getPrimaryType() {
        int n = this.mimeType.indexOf("/");
        if (n == -1) {
            return this.mimeType;
        }
        return this.mimeType.substring(0, n);
    }

    public String getSubType() {
        int n = this.mimeType.indexOf("/");
        if (n == -1) {
            return "";
        }
        int n2 = this.mimeType.indexOf(";", n + 1);
        if (n2 == -1) {
            return this.mimeType.substring(n + 1);
        }
        return this.mimeType.substring(n + 1, n2);
    }

    private static String getParameter(String string, String string2) {
        int n = string2.indexOf(string + "=");
        if (n == -1) {
            return null;
        }
        String string3 = string2.substring(n + string.length() + 1);
        if ((n = string3.indexOf(" ")) == -1) {
            return string3;
        }
        return string3.substring(0, n);
    }

    public String getParameter(String string) {
        if ("humanPresentableName".equals(string)) {
            return this.getHumanPresentableName();
        }
        return DataFlavor.getParameter(string, this.mimeType);
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean isMimeTypeEqual(String string) {
        String string2 = this.getMimeType();
        int n = string2.indexOf(";");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string.indexOf(";")) != -1) {
            string = string.substring(0, n);
        }
        return string2.equals(string);
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.getMimeType());
    }

    public boolean isMimeTypeSerializedObject() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassInputStream() {
        return this.representationClass.getName().equals("java.io.InputStream");
    }

    public boolean isRepresentationClassSerializable() {
        Class[] classArray = this.representationClass.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals("java.io.Serializable")) continue;
            return true;
        }
        return false;
    }

    public boolean isRepresentationClassRemote() {
        return DataFlavor.class$("java.rmi.Remote").isAssignableFrom(this.representationClass);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.mimeType.startsWith(javaSerializedObjectMimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.mimeType.startsWith(javaRemoteObjectMimeType);
    }

    public boolean isFlavorJavaFileListType() {
        return this.mimeType.equals(DataFlavor.javaFileListFlavor.mimeType) && this.representationClass.equals(DataFlavor.javaFileListFlavor.representationClass);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (!this.mimeType.toLowerCase().equals(dataFlavor.mimeType.toLowerCase())) {
            return false;
        }
        return this.representationClass.equals(dataFlavor.representationClass);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataFlavor)) {
            return false;
        }
        return this.equals((DataFlavor)object);
    }

    public boolean equals(String string) {
        return this.isMimeTypeEqual(string);
    }

    public int hashCode() {
        return this.mimeType.toLowerCase().hashCode() ^ this.representationClass.hashCode();
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string + "=" + string2;
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public String toString() {
        return this.getClass().getName() + "[representationClass=" + this.getRepresentationClass().getName() + ",mimeType=" + this.getMimeType() + ",humanPresentableName=" + this.getHumanPresentableName() + "]";
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        return plainTextFlavor;
    }

    public final Class getDefaultRepresentationClass() {
        return DataFlavor.class$("java.io.InputStream");
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            Class clazz = dataFlavor.representationClass;
            if (DataFlavor.class$("java.io.Reader").isAssignableFrom(clazz) || DataFlavor.class$("java.lang.String").isAssignableFrom(clazz)) {
                return dataFlavor;
            }
            if (!DataFlavor.class$("java.io.InputStream").isAssignableFrom(clazz) || !"text".equals(dataFlavor.getPrimaryType())) continue;
            String string = dataFlavorArray[i].getParameter("charset");
            if (string == null) {
                string = "us-ascii";
            }
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (inputStreamReader == null) continue;
            return dataFlavor;
        }
        return null;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (!transferable.isDataFlavorSupported(this)) {
            throw new UnsupportedFlavorException(this);
        }
        if (DataFlavor.class$("java.io.Reader").isAssignableFrom(this.representationClass)) {
            return (Reader)transferable.getTransferData(this);
        }
        if (DataFlavor.class$("java.lang.String").isAssignableFrom(this.representationClass)) {
            return new StringReader((String)transferable.getTransferData(this));
        }
        if (DataFlavor.class$("java.io.InputStream").isAssignableFrom(this.representationClass) && "text".equals(this.getPrimaryType())) {
            InputStream inputStream = (InputStream)transferable.getTransferData(this);
            String string = this.getParameter("charset");
            if (string == null) {
                string = "us-ascii";
            }
            return new InputStreamReader(inputStream, string);
        }
        throw new UnsupportedFlavorException(this);
    }

    public boolean isRepresentationClassByteBuffer() {
        return DataFlavor.class$("java.nio.ByteBuffer").isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        return DataFlavor.class$("java.nio.CharBuffer").isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        return DataFlavor.class$("java.io.Reader").isAssignableFrom(this.representationClass);
    }

    static {
        javaSerializedObjectMimeType = javaSerializedObjectMimeType;
        javaJVMLocalObjectMimeType = javaJVMLocalObjectMimeType;
        javaRemoteObjectMimeType = javaRemoteObjectMimeType;
        plainTextFlavor = new DataFlavor(DataFlavor.class$("java.io.InputStream"), "text/plain; charset=unicode", "plain unicode text");
        stringFlavor = new DataFlavor(DataFlavor.class$("java.lang.String"), "Java Unicode String");
        javaFileListFlavor = new DataFlavor(DataFlavor.class$("java.util.List"), "application/x-java-file-list; class=java.util.List", "Java File List");
        imageFlavor = new DataFlavor(DataFlavor.class$("java.awt.Image"), "Java Image");
    }
}

