/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferStrategy;
import java.awt.peer.WindowPeer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class Window
extends Container
implements Accessible {
    private static final long serialVersionUID = 4497834738069338734L;
    private String warningString;
    private int windowSerializedDataVersion;
    private int state;
    private boolean focusableWindowState;
    private transient Vector ownedWindows;
    private transient WindowListener windowListener;
    private transient WindowFocusListener windowFocusListener;
    private transient WindowStateListener windowStateListener;
    private transient GraphicsConfiguration graphicsConfiguration;
    private transient boolean shown;
    transient Component windowFocusOwner;
    private static transient long next_window_number;

    private /* synthetic */ void finit$() {
        this.warningString = null;
        this.windowSerializedDataVersion = 0;
        this.state = 0;
        this.focusableWindowState = true;
        this.ownedWindows = new Vector();
    }

    Window() {
        this.finit$();
        this.visible = false;
        this.focusCycleRoot = true;
        this.setLayout(new BorderLayout());
        this.addWindowFocusListener(new WindowAdapter(this){
            private /* synthetic */ Window this$0;
            {
                this.this$0 = window;
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (this.this$0.windowFocusOwner != null) {
                    EventQueue eventQueue;
                    EventQueue eventQueue2 = eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    synchronized (eventQueue2) {
                        KeyboardFocusManager keyboardFocusManager;
                        block5: {
                            try {
                                keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                Component component = keyboardFocusManager.getGlobalPermanentFocusOwner();
                                if (component != null) {
                                    eventQueue.postEvent(new FocusEvent(component, 1005, false, this.this$0.windowFocusOwner));
                                    eventQueue.postEvent(new FocusEvent(this.this$0.windowFocusOwner, 1004, false, component));
                                    break block5;
                                }
                                eventQueue.postEvent(new FocusEvent(this.this$0.windowFocusOwner, 1004, false));
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                throw throwable;
                            }
                        }
                        keyboardFocusManager = null;
                    }
                }
            }
        });
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    Window(GraphicsConfiguration graphicsConfiguration) {
        this();
        this.graphicsConfiguration = graphicsConfiguration;
    }

    public Window(Frame frame) {
        this(frame, frame.getGraphicsConfiguration());
    }

    public Window(Window window) {
        this(window, window.getGraphicsConfiguration());
    }

    public Window(Window window, GraphicsConfiguration graphicsConfiguration) {
        this();
        Object object = this.getTreeLock();
        synchronized (object) {
            SecurityManager securityManager;
            try {
                if (window == null) {
                    throw new IllegalArgumentException("owner must not be null");
                }
                this.parent = window;
                window.ownedWindows.add(new WeakReference(this));
            }
            finally {
                securityManager = null;
            }
            securityManager = System.getSecurityManager();
            if (securityManager != null && !securityManager.checkTopLevelWindow(this)) {
                this.warningString = System.getProperty("awt.appletWarning");
            }
            if (graphicsConfiguration != null && graphicsConfiguration.getDevice().getType() != 0) {
                throw new IllegalArgumentException("gc must be from a screen device");
            }
            this.graphicsConfiguration = graphicsConfiguration == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration() : graphicsConfiguration;
            return;
        }
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        return super.getGraphicsConfigurationImpl();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator iterator;
            block9: {
                try {
                    Object object2;
                    if (this.parent != null && !this.parent.isDisplayable()) {
                        this.parent.addNotify();
                    }
                    if (this.peer == null) {
                        this.addNotify();
                    }
                    iterator = this.ownedWindows.iterator();
                    while (iterator.hasNext()) {
                        object2 = (Window)((Reference)iterator.next()).get();
                        if (object2 != null) {
                            if (!((Component)object2).isVisible()) continue;
                            ((Component)object2).getPeer().setVisible(true);
                            continue;
                        }
                        iterator.remove();
                    }
                    this.validate();
                    super.show();
                    this.toFront();
                    object2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    ((KeyboardFocusManager)object2).setGlobalFocusedWindow(this);
                    if (this.shown) break block9;
                    FocusTraversalPolicy focusTraversalPolicy = this.getFocusTraversalPolicy();
                    Component component = null;
                    if (focusTraversalPolicy != null) {
                        component = focusTraversalPolicy.getInitialComponent(this);
                    }
                    if (component != null) {
                        component.requestFocusInWindow();
                    }
                    this.shown = true;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            iterator = null;
        }
    }

    public void hide() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Iterator iterator = this.ownedWindows.iterator();
                while (iterator.hasNext()) {
                    Window window = (Window)((Reference)iterator.next()).get();
                    if (window != null) {
                        if (!window.isVisible() || window.getPeer() == null) continue;
                        window.getPeer().setVisible(false);
                        continue;
                    }
                    iterator.remove();
                }
                iterator = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
        super.hide();
    }

    public void dispose() {
        this.hide();
        Object object = this.getTreeLock();
        synchronized (object) {
            Iterator iterator;
            try {
                iterator = this.ownedWindows.iterator();
                while (iterator.hasNext()) {
                    Window window = (Window)((Reference)iterator.next()).get();
                    if (window != null) {
                        window.dispose();
                        continue;
                    }
                    iterator.remove();
                }
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].removeNotify();
                }
                this.removeNotify();
                WindowEvent windowEvent = new WindowEvent(this, 202);
                this.getToolkit().getSystemEventQueue().postEvent(windowEvent);
            }
            finally {
                iterator = null;
            }
            return;
        }
    }

    public void toBack() {
        if (this.peer != null) {
            WindowPeer windowPeer = (WindowPeer)this.peer;
            windowPeer.toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            WindowPeer windowPeer = (WindowPeer)this.peer;
            windowPeer.toFront();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    public Window[] getOwnedWindows() {
        Window[] windowArray;
        Window[] windowArray2;
        Object object = this.getTreeLock();
        synchronized (object) {
            block6: {
                try {
                    windowArray2 = new Window[this.ownedWindows.size()];
                    Iterator iterator = this.ownedWindows.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        Window window = (Window)((Reference)iterator.next()).get();
                        if (window != null) {
                            windowArray2[n++] = window;
                            continue;
                        }
                        iterator.remove();
                    }
                    if (n != windowArray2.length) {
                        windowArray = new Window[n];
                        System.arraycopy(windowArray2, 0, windowArray, 0, n);
                        break block6;
                    }
                    windowArray = windowArray2;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    throw throwable;
                }
            }
            windowArray2 = null;
        }
        windowArray2 = windowArray;
        return windowArray2;
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        return (WindowListener[])AWTEventMulticaster.getListeners(this.windowListener, Window.class$("java.awt.event.WindowListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        return (WindowFocusListener[])AWTEventMulticaster.getListeners(this.windowFocusListener, Window.class$("java.awt.event.WindowFocusListener"));
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        return (WindowStateListener[])AWTEventMulticaster.getListeners(this.windowStateListener, Window.class$("java.awt.event.WindowStateListener"));
    }

    public void addWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, windowFocusListener);
    }

    public void addWindowStateListener(WindowStateListener windowStateListener) {
        this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, windowStateListener);
    }

    public void removeWindowFocusListener(WindowFocusListener windowFocusListener) {
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, windowFocusListener);
    }

    public void removeWindowStateListener(WindowStateListener windowStateListener) {
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, windowStateListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Window.class$("java.awt.event.WindowListener")) {
            return this.getWindowListeners();
        }
        return super.getListeners(clazz);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 209 && aWTEvent.id >= 200 && (this.windowListener != null || this.windowFocusListener != null || this.windowStateListener != null || (this.eventMask & (long)64) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id == 101) {
            this.validate();
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        int n = windowEvent.getID();
        if (n == 207 || n == 208) {
            this.processWindowFocusEvent(windowEvent);
        } else if (n == 209) {
            this.processWindowStateEvent(windowEvent);
        } else if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                    break;
                }
            }
        }
    }

    public boolean isActive() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getActiveWindow() == this;
    }

    public boolean isFocused() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return keyboardFocusManager.getFocusedWindow() == this;
    }

    public Component getFocusOwner() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = keyboardFocusManager.getActiveWindow();
        if (window == this) {
            return keyboardFocusManager.getFocusOwner();
        }
        return null;
    }

    public Component getMostRecentFocusOwner() {
        return this.windowFocusOwner;
    }

    void setFocusOwner(Component component) {
        this.windowFocusOwner = component;
    }

    public boolean postEvent(Event event) {
        return this.handleEvent(event);
    }

    public boolean isShowing() {
        return this.isVisible();
    }

    public void setLocationRelativeTo(Component component) {
        int n = 0;
        int n2 = 0;
        if (component == null || !component.isShowing()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Point point = graphicsEnvironment.getCenterPoint();
            n = point.x - this.width / 2;
            n2 = point.y - this.height / 2;
        } else {
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            Dimension dimension = this.getToolkit().getScreenSize();
            n = component.getLocationOnScreen().x;
            n2 = component.getLocationOnScreen().y;
            if (n2 + n4 > dimension.height) {
                n = dimension.width / 2 - n <= 0 ? (n - this.width >= 0 ? (n -= this.width) : 0) : (n + n3 + this.width <= dimension.width ? (n += n3) : dimension.width - this.width);
                n2 = dimension.height - this.height;
            } else if (n3 > this.width || n4 > this.height) {
                n = n + this.width > dimension.width ? dimension.width - this.width : (n < 0 ? 0 : (n += (n3 - this.width) / 2));
                n2 += (n4 - this.height) / 2;
            } else {
                n = n + this.width > dimension.width ? dimension.width - this.width : (n < 0 || n - (this.width - n3) / 2 < 0 ? 0 : (n -= (this.width - n3) / 2));
                n2 = n2 - (this.height - n4) / 2 > 0 ? (n2 -= (this.height - n4) / 2) : 0;
            }
        }
        this.setLocation(n, n2);
    }

    public void createBufferStrategy(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (!this.isDisplayable()) {
            throw new IllegalStateException("Window.createBufferStrategy: window is not displayable");
        }
        BufferStrategy bufferStrategy = null;
        try {
            bufferStrategy = new WindowFlipBufferStrategy(this, n);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        if (bufferStrategy == null) {
            bufferStrategy = new WindowBltBufferStrategy(this, n, true);
        }
        this.bufferStrategy = bufferStrategy;
    }

    public void createBufferStrategy(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n < 1) {
            throw new IllegalArgumentException("Window.createBufferStrategy: number of buffers is less than one");
        }
        if (bufferCapabilities == null) {
            throw new IllegalArgumentException("Window.createBufferStrategy: capabilities object is null");
        }
        this.bufferStrategy = bufferCapabilities.isPageFlipping() ? new WindowFlipBufferStrategy(this, n) : new WindowBltBufferStrategy(this, n, true);
    }

    public BufferStrategy getBufferStrategy() {
        return this.bufferStrategy;
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) {
        throw new Error("Not implemented");
    }

    public void applyResourceBundle(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault(), ClassLoader.getSystemClassLoader());
        if (resourceBundle != null) {
            this.applyResourceBundle(resourceBundle);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTWindow(this);
        }
        return this.accessibleContext;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        if (this.peer != null) {
            return this.peer.getGraphicsConfiguration();
        }
        return null;
    }

    protected void processWindowFocusEvent(WindowEvent windowEvent) {
        if (this.windowFocusListener != null) {
            switch (windowEvent.getID()) {
                case 207: {
                    this.windowFocusListener.windowGainedFocus(windowEvent);
                    break;
                }
                case 208: {
                    this.windowFocusListener.windowLostFocus(windowEvent);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent windowEvent) {
        if (this.windowStateListener != null && windowEvent.getID() == 209) {
            this.windowStateListener.windowStateChanged(windowEvent);
        }
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        return this instanceof Dialog || this instanceof Frame;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    public void setFocusableWindowState(boolean bl) {
        this.focusableWindowState = bl;
    }

    String generateName() {
        return "win" + Window.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_window_number++;
    }

    private class WindowFlipBufferStrategy
    extends Component.FlipBufferStrategy {
        private /* synthetic */ Window this$0;

        WindowFlipBufferStrategy(Window window, int n) throws AWTException {
            this.this$0 = window;
            super(window, n, new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED));
        }
    }

    private class WindowBltBufferStrategy
    extends Component.BltBufferStrategy {
        private /* synthetic */ Window this$0;

        WindowBltBufferStrategy(Window window, int n, boolean bl) {
            this.this$0 = window;
            super(window, n, new BufferCapabilities(new ImageCapabilities(bl), new ImageCapabilities(bl), BufferCapabilities.FlipContents.COPIED));
        }
    }

    protected class AccessibleAWTWindow
    extends Container.AccessibleAWTContainer {
        private /* synthetic */ Window this$0;
        private static final long serialVersionUID = 4215068635060671780L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.WINDOW;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.isActive()) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        protected AccessibleAWTWindow(Window window) {
            this.this$0 = window;
            super(window);
        }
    }
}

