/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.MenuItemPeer;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

public class MenuItem
extends MenuComponent
implements Serializable,
Accessible {
    private static final long serialVersionUID = -21757335363267194L;
    String actionCommand;
    boolean enabled;
    long eventMask;
    String label;
    private MenuShortcut shortcut;
    private transient ActionListener action_listeners;

    private /* synthetic */ void finit$() {
        this.enabled = true;
        this.label = "";
    }

    public MenuItem() {
        this.finit$();
    }

    public MenuItem(String string) {
        this.finit$();
        this.label = string;
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.finit$();
        this.label = string;
        this.shortcut = menuShortcut;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        if (this.peer != null) {
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            menuItemPeer.setLabel(string);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable(boolean bl) {
        if (bl) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(true);
        }
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        if (this.peer != null) {
            ((MenuItemPeer)this.peer).setEnabled(false);
        }
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        this.shortcut = menuShortcut;
    }

    public void deleteShortcut() {
        this.shortcut = null;
    }

    public String getActionCommand() {
        if (this.actionCommand == null) {
            return this.label;
        }
        return this.actionCommand;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ (long)-1;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createMenuItem(this);
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, actionListener);
        this.enableEvents(128);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, actionListener);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])AWTEventMulticaster.getListeners(this.action_listeners, MenuItem.class$("java.awt.event.ActionListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == MenuItem.class$("java.awt.event.ActionListener")) {
            return this.getActionListeners();
        }
        return (EventListener[])Array.newInstance(clazz, 0);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 1001 && aWTEvent.id >= 1001 && (this.action_listeners != null || (this.eventMask & (long)128) != 0L)) {
            this.processEvent(aWTEvent);
        }
        if (!aWTEvent.isConsumed()) {
            ((Menu)this.getParent()).processEvent(aWTEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.action_listeners != null) {
            actionEvent.setSource(this);
            this.action_listeners.actionPerformed(actionEvent);
        }
    }

    public String paramString() {
        return "label=" + this.label + ",enabled=" + this.enabled + ",actionCommand=" + this.actionCommand + "," + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuItem(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTMenuItem
    extends MenuComponent.AccessibleAWTMenuComponent
    implements AccessibleAction,
    AccessibleValue {
        private /* synthetic */ MenuItem this$0;
        private static final long serialVersionUID = -217847831945965825L;

        public AccessibleAWTMenuItem(MenuItem menuItem) {
            this.this$0 = menuItem;
            super(menuItem);
        }

        public String getAccessibleName() {
            return this.this$0.label;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public String getAccessibleActionDescription(int n) {
            if (n == 0) {
                return this.this$0.label;
            }
            return null;
        }

        public boolean doAccessibleAction(int n) {
            if (n != 0) {
                return false;
            }
            this.this$0.processActionEvent(new ActionEvent(this, 1001, this.this$0.actionCommand));
            return true;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return this.this$0.enabled ? new Integer(1) : new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            boolean bl = number.intValue() != 0;
            this.setEnabled(bl);
            return bl;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(0);
        }
    }
}

