/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.peer.MenuBarPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class MenuBar
extends MenuComponent
implements MenuContainer,
Serializable,
Accessible {
    private static final long serialVersionUID = -4930327919388951260L;
    private Menu helpMenu;
    private Vector menus;
    private transient AccessibleContext accessibleContext;

    private /* synthetic */ void finit$() {
        this.menus = new Vector();
    }

    public MenuBar() {
        this.finit$();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public synchronized void setHelpMenu(Menu menu) {
        if (this.helpMenu != null) {
            this.helpMenu.removeNotify();
            this.helpMenu.parent = null;
        }
        this.helpMenu = menu;
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        MenuBarPeer menuBarPeer = (MenuBarPeer)this.getPeer();
        if (menuBarPeer != null) {
            menu.addNotify();
            menuBarPeer.addHelpMenu(menu);
        }
    }

    public synchronized Menu add(Menu menu) {
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        this.menus.addElement(menu);
        if (this.peer != null) {
            menu.addNotify();
        }
        return menu;
    }

    public synchronized void remove(int n) {
        Menu menu = (Menu)this.menus.get(n);
        this.menus.remove(n);
        menu.removeNotify();
        menu.parent = null;
        if (this.peer != null) {
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            menuBarPeer.delMenu(n);
        }
    }

    public void remove(MenuComponent menuComponent) {
        int n = this.menus.indexOf(menuComponent);
        if (n == -1) {
            return;
        }
        this.remove(n);
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        return this.menus.size() + (this.getHelpMenu() == null ? 0 : 1);
    }

    public Menu getMenu(int n) {
        return (Menu)this.menus.elementAt(n);
    }

    public void addNotify() {
        if (this.getPeer() == null) {
            this.setPeer(this.getToolkit().createMenuBar(this));
        }
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            menu.addNotify();
        }
        if (this.helpMenu != null) {
            this.helpMenu.addNotify();
            ((MenuBarPeer)this.peer).addHelpMenu(this.helpMenu);
        }
    }

    public void removeNotify() {
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            menu.removeNotify();
        }
        super.removeNotify();
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            if (menu.getShortcut() == null) continue;
            vector.addElement(menu.getShortcut());
        }
        return vector.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        Enumeration enumeration = this.menus.elements();
        while (enumeration.hasMoreElements()) {
            Menu menu = (Menu)enumeration.nextElement();
            MenuShortcut menuShortcut2 = menu.getShortcut();
            if (menuShortcut2 == null || !menuShortcut2.equals(menuShortcut)) continue;
            return menu;
        }
        return null;
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        MenuItem menuItem;
        while ((menuItem = this.getShortcutMenuItem(menuShortcut)) != null) {
            menuItem.deleteShortcut();
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        private /* synthetic */ MenuBar this$0;
        private static final long serialVersionUID = -8577604491830083815L;

        protected AccessibleAWTMenuBar(MenuBar menuBar) {
            this.this$0 = menuBar;
            super(menuBar);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

