/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Menu
extends MenuItem
implements MenuContainer,
Serializable {
    private static final long serialVersionUID = -8809584163345499784L;
    private Vector items;
    private boolean tearOff;
    private boolean isHelpMenu;
    private int menuSerializedDataVersion;
    static final transient String separatorLabel = "-";

    private /* synthetic */ void finit$() {
        this.items = new Vector();
        this.menuSerializedDataVersion = 1;
    }

    public Menu() {
        this.finit$();
    }

    public Menu(String string) {
        this(string, false);
    }

    public Menu(String string, boolean bl) {
        super(string);
        this.finit$();
        this.tearOff = bl;
        if (string.equals("Help")) {
            this.isHelpMenu = true;
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public MenuItem getItem(int n) {
        return (MenuItem)this.items.elementAt(n);
    }

    public MenuItem add(MenuItem menuItem) {
        this.items.addElement(menuItem);
        if (menuItem.parent != null) {
            menuItem.parent.remove(menuItem);
        }
        menuItem.parent = this;
        if (this.peer != null) {
            MenuPeer menuPeer = (MenuPeer)this.peer;
            menuPeer.addItem(menuItem);
        }
        return menuItem;
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    public void insert(MenuItem menuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Index is less than zero");
        }
        MenuPeer menuPeer = (MenuPeer)this.getPeer();
        if (menuPeer == null) {
            return;
        }
        int n2 = this.getItemCount();
        if (n >= n2) {
            menuPeer.addItem(menuItem);
        } else {
            int n3;
            for (n3 = n2 - 1; n3 >= n; --n3) {
                menuPeer.delItem(n3);
            }
            menuPeer.addItem(menuItem);
            for (n3 = n; n3 < n2; ++n3) {
                menuPeer.addItem((MenuItem)this.items.elementAt(n3));
            }
        }
        this.items.insertElementAt(menuItem, n);
    }

    public void insert(String string, int n) {
        this.insert(new MenuItem(string), n);
    }

    public void addSeparator() {
        this.add(new MenuItem(separatorLabel));
    }

    public void insertSeparator(int n) {
        this.insert(new MenuItem(separatorLabel), n);
    }

    public synchronized void remove(int n) {
        this.items.removeElementAt(n);
        MenuPeer menuPeer = (MenuPeer)this.getPeer();
        if (menuPeer != null) {
            menuPeer.delItem(n);
        }
    }

    public void remove(MenuComponent menuComponent) {
        int n = this.items.indexOf(menuComponent);
        if (n == -1) {
            return;
        }
        this.remove(n);
    }

    public synchronized void removeAll() {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            this.remove(0);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createMenu(this);
        }
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            menuItem.addNotify();
        }
        super.addNotify();
    }

    public void removeNotify() {
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            menuItem.removeNotify();
        }
        super.removeNotify();
    }

    public String paramString() {
        return ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        private /* synthetic */ Menu this$0;
        private static final long serialVersionUID = 5228160894980069094L;

        protected AccessibleAWTMenu(Menu menu) {
            this.this$0 = menu;
            super(menu);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

