/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class KeyboardFocusManager
implements KeyEventDispatcher,
KeyEventPostProcessor {
    public static final int FORWARD_TRAVERSAL_KEYS = 0;
    public static final int BACKWARD_TRAVERSAL_KEYS = 1;
    public static final int UP_CYCLE_TRAVERSAL_KEYS = 2;
    public static final int DOWN_CYCLE_TRAVERSAL_KEYS = 3;
    private static final Set DEFAULT_FORWARD_KEYS;
    private static final Set DEFAULT_BACKWARD_KEYS;
    private static Map currentKeyboardFocusManagers;
    private static Map currentFocusOwners;
    private static Map currentPermanentFocusOwners;
    private static Map currentFocusedWindows;
    private static Map currentActiveWindows;
    private static Map currentFocusCycleRoots;
    private FocusTraversalPolicy defaultPolicy;
    private Set[] defaultFocusKeys;
    private final PropertyChangeSupport propertyChangeSupport;
    private final VetoableChangeSupport vetoableChangeSupport;
    private final ArrayList keyEventDispatchers;
    private final ArrayList keyEventPostProcessors;

    private /* synthetic */ void finit$() {
        this.defaultFocusKeys = new Set[]{DEFAULT_FORWARD_KEYS, DEFAULT_BACKWARD_KEYS, Collections.EMPTY_SET, Collections.EMPTY_SET};
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.vetoableChangeSupport = new VetoableChangeSupport(this);
        this.keyEventDispatchers = new ArrayList();
        this.keyEventPostProcessors = new ArrayList();
    }

    public KeyboardFocusManager() {
        this.finit$();
    }

    public static KeyboardFocusManager getCurrentKeyboardFocusManager() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        if (currentKeyboardFocusManagers.get(threadGroup) == null) {
            KeyboardFocusManager.setCurrentKeyboardFocusManager(null);
        }
        return (KeyboardFocusManager)currentKeyboardFocusManagers.get(threadGroup);
    }

    public static void setCurrentKeyboardFocusManager(KeyboardFocusManager keyboardFocusManager) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("replaceKeyboardFocusManager"));
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        KeyboardFocusManager keyboardFocusManager2 = keyboardFocusManager == null ? new DefaultKeyboardFocusManager() : keyboardFocusManager;
        currentKeyboardFocusManagers.put(threadGroup, keyboardFocusManager2);
    }

    public Component getFocusOwner() {
        Component component = (Component)this.getObject(currentFocusOwners);
        if (component == null) {
            component = (Component)this.getObject(currentPermanentFocusOwners);
        }
        return component;
    }

    protected Component getGlobalFocusOwner() {
        Component component = (Component)this.getGlobalObject(currentFocusOwners);
        if (component == null) {
            return this.getGlobalPermanentFocusOwner();
        }
        return component;
    }

    protected void setGlobalFocusOwner(Component component) {
        if (component == null || component.focusable) {
            this.setGlobalObject(currentFocusOwners, component, "focusOwner");
        }
    }

    public void clearGlobalFocusOwner() {
        Map map = currentFocusOwners;
        synchronized (map) {
            Component component;
            block6: {
                try {
                    EventQueue eventQueue;
                    component = this.getGlobalFocusOwner();
                    Component component2 = this.getGlobalPermanentFocusOwner();
                    this.setGlobalFocusOwner(null);
                    this.setGlobalPermanentFocusOwner(null);
                    if (component != null) {
                        eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        if (component != component2) {
                            eventQueue.postEvent(new FocusEvent(component, 1005, true));
                        } else {
                            eventQueue.postEvent(new FocusEvent(component, 1005, false));
                        }
                    }
                    if (component == component2) break block6;
                    eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    eventQueue.postEvent(new FocusEvent(component2, 1005, false));
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            component = null;
        }
    }

    public Component getPermanentFocusOwner() {
        return (Component)this.getObject(currentPermanentFocusOwners);
    }

    protected Component getGlobalPermanentFocusOwner() {
        return (Component)this.getGlobalObject(currentPermanentFocusOwners);
    }

    protected void setGlobalPermanentFocusOwner(Component component) {
        if (component == null || component.focusable) {
            this.setGlobalObject(currentPermanentFocusOwners, component, "permanentFocusOwner");
        }
    }

    public Window getFocusedWindow() {
        return (Window)this.getObject(currentFocusedWindows);
    }

    protected Window getGlobalFocusedWindow() {
        return (Window)this.getGlobalObject(currentFocusedWindows);
    }

    protected void setGlobalFocusedWindow(Window window) {
        if (window == null || window.focusable) {
            this.setGlobalObject(currentFocusedWindows, window, "focusedWindow");
        }
    }

    public Window getActiveWindow() {
        return (Window)this.getObject(currentActiveWindows);
    }

    protected Window getGlobalActiveWindow() {
        return (Window)this.getGlobalObject(currentActiveWindows);
    }

    protected void setGlobalActiveWindow(Window window) {
        this.setGlobalObject(currentActiveWindows, window, "activeWindow");
    }

    public FocusTraversalPolicy getDefaultFocusTraversalPolicy() {
        if (this.defaultPolicy == null) {
            this.defaultPolicy = new DefaultFocusTraversalPolicy();
        }
        return this.defaultPolicy;
    }

    public void setDefaultFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        if (focusTraversalPolicy == null) {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("defaultFocusTraversalPolicy", this.defaultPolicy, focusTraversalPolicy);
        this.defaultPolicy = focusTraversalPolicy;
    }

    public void setDefaultFocusTraversalKeys(int n, Set set) {
        String string;
        Set set2;
        Set set3;
        Set set4;
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException();
        }
        if (set == null) {
            throw new IllegalArgumentException();
        }
        switch (n) {
            case 0: {
                set4 = this.defaultFocusKeys[1];
                set3 = this.defaultFocusKeys[2];
                set2 = this.defaultFocusKeys[3];
                string = "forwardDefaultFocusTraversalKeys";
                break;
            }
            case 1: {
                set4 = this.defaultFocusKeys[0];
                set3 = this.defaultFocusKeys[2];
                set2 = this.defaultFocusKeys[3];
                string = "backwardDefaultFocusTraversalKeys";
                break;
            }
            case 2: {
                set4 = this.defaultFocusKeys[0];
                set3 = this.defaultFocusKeys[1];
                set2 = this.defaultFocusKeys[3];
                string = "upCycleDefaultFocusTraversalKeys";
                break;
            }
            case 3: {
                set4 = this.defaultFocusKeys[0];
                set3 = this.defaultFocusKeys[1];
                set2 = this.defaultFocusKeys[2];
                string = "downCycleDefaultFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int n2 = set.size();
        Iterator iterator = set.iterator();
        while (--n2 >= 0) {
            Object object = iterator.next();
            if (object instanceof AWTKeyStroke && !set4.contains(object) && !set3.contains(object) && !set2.contains(object) && ((AWTKeyStroke)object).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        set = Collections.unmodifiableSet(new HashSet(set));
        this.firePropertyChange(string, this.defaultFocusKeys[n], set);
        this.defaultFocusKeys[n] = set;
    }

    public Set getDefaultFocusTraversalKeys(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException();
        }
        return this.defaultFocusKeys[n];
    }

    public Container getCurrentFocusCycleRoot() {
        return (Container)this.getObject(currentFocusCycleRoots);
    }

    protected Container getGlobalCurrentFocusCycleRoot() {
        return (Container)this.getGlobalObject(currentFocusCycleRoots);
    }

    public void setGlobalCurrentFocusCycleRoot(Container container) {
        this.setGlobalObject(currentFocusCycleRoots, container, "currentFocusCycleRoot");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.propertyChangeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.addVetoableChangeListener(string, vetoableChangeListener);
        }
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(string, vetoableChangeListener);
        }
    }

    public VetoableChangeListener[] getVetoableChangeListeners(String string) {
        return this.vetoableChangeSupport.getVetoableChangeListeners(string);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public void addKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        if (keyEventDispatcher != null) {
            this.keyEventDispatchers.add(keyEventDispatcher);
        }
    }

    public void removeKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        this.keyEventDispatchers.remove(keyEventDispatcher);
    }

    protected List getKeyEventDispatchers() {
        return (List)this.keyEventDispatchers.clone();
    }

    public void addKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        if (keyEventPostProcessor != null) {
            this.keyEventPostProcessors.add(keyEventPostProcessor);
        }
    }

    public void removeKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        this.keyEventPostProcessors.remove(keyEventPostProcessor);
    }

    protected List getKeyEventPostProcessors() {
        return (List)this.keyEventPostProcessors.clone();
    }

    public abstract boolean dispatchEvent(AWTEvent var1);

    public final void redispatchEvent(Component component, AWTEvent aWTEvent) {
        AWTEvent aWTEvent2 = aWTEvent;
        synchronized (aWTEvent2) {
            try {
                aWTEvent.setSource(component);
                component.dispatchEvent(aWTEvent);
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }

    public abstract boolean dispatchKeyEvent(KeyEvent var1);

    public abstract boolean postProcessKeyEvent(KeyEvent var1);

    public abstract void processKeyEvent(Component var1, KeyEvent var2);

    protected abstract void enqueueKeyEvents(long var1, Component var3);

    protected abstract void dequeueKeyEvents(long var1, Component var3);

    protected abstract void discardKeyEvents(Component var1);

    public abstract void focusNextComponent(Component var1);

    public abstract void focusPreviousComponent(Component var1);

    public abstract void upFocusCycle(Component var1);

    public abstract void downFocusCycle(Container var1);

    public final void focusNextComponent() {
        this.focusNextComponent(null);
    }

    public final void focusPreviousComponent() {
        this.focusPreviousComponent(null);
    }

    public final void upFocusCycle() {
        this.upFocusCycle(null);
    }

    public final void downFocusCycle() {
        Component component = this.getGlobalFocusOwner();
        if (component instanceof Container && ((Container)component).isFocusCycleRoot()) {
            this.downFocusCycle((Container)component);
        }
    }

    private Object getObject(Map map) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        return map.get(threadGroup);
    }

    private Object getGlobalObject(Map map) {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        KeyboardFocusManager keyboardFocusManager = (KeyboardFocusManager)currentKeyboardFocusManagers.get(threadGroup);
        if (this != keyboardFocusManager) {
            throw new SecurityException("Attempted to retrieve an object from a keyboard focus manager that isn't associated with the current thread group.");
        }
        Map map2 = map;
        synchronized (map2) {
            try {
                Collection collection = map.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Component component = (Component)iterator.next();
                    if (component == null) continue;
                    Component component2 = component;
                    Object var9_10 = null;
                    return component2;
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                throw throwable;
            }
            Object var9_11 = null;
        }
        Object var8_9 = null;
        return var8_9;
    }

    private void setGlobalObject(Map map, Object object, String string) {
        Map map2 = map;
        synchronized (map2) {
            try {
                ThreadGroup threadGroup;
                Object object2 = this.getGlobalObject(map);
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    threadGroup = (ThreadGroup)iterator.next();
                    if (map.get(threadGroup) == null) continue;
                    map.put(threadGroup, null);
                    break;
                }
                threadGroup = Thread.currentThread().getThreadGroup();
                this.firePropertyChange(string, object2, object);
                try {
                    this.fireVetoableChange(string, object2, object);
                    map.put(threadGroup, object);
                }
                catch (PropertyVetoException propertyVetoException) {
                }
                object2 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    static {
        HashSet hashSet = new HashSet();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        DEFAULT_FORWARD_KEYS = Collections.unmodifiableSet(hashSet);
        hashSet = new HashSet();
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        hashSet.add(AWTKeyStroke.getAWTKeyStroke(9, 192));
        DEFAULT_BACKWARD_KEYS = Collections.unmodifiableSet(hashSet);
        currentKeyboardFocusManagers = new HashMap();
        currentFocusOwners = new HashMap();
        currentPermanentFocusOwners = new HashMap();
        currentFocusedWindows = new HashMap();
        currentActiveWindows = new HashMap();
        currentFocusCycleRoots = new HashMap();
    }
}

