/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public abstract class Graphics {
    protected Graphics() {
    }

    public abstract Graphics create();

    public Graphics create(int n, int n2, int n3, int n4) {
        Graphics graphics = this.create();
        graphics.translate(n, n2);
        graphics.clipRect(0, 0, n3, n4);
        return graphics;
    }

    public abstract void translate(int var1, int var2);

    public abstract Color getColor();

    public abstract void setColor(Color var1);

    public abstract void setPaintMode();

    public abstract void setXORMode(Color var1);

    public abstract Font getFont();

    public abstract void setFont(Font var1);

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract Rectangle getClipBounds();

    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    public abstract void clipRect(int var1, int var2, int var3, int var4);

    public abstract void setClip(int var1, int var2, int var3, int var4);

    public abstract Shape getClip();

    public abstract void setClip(Shape var1);

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void fillRect(int var1, int var2, int var3, int var4);

    public void drawRect(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        int n8 = n2 + n4;
        this.drawLine(n5, n6, n7, n6);
        this.drawLine(n7, n6, n7, n8);
        this.drawLine(n7, n8, n5, n8);
        this.drawLine(n5, n8, n5, n6);
    }

    public abstract void clearRect(int var1, int var2, int var3, int var4);

    public abstract void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Color color = this.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        if (!bl) {
            Color color4 = color2;
            color2 = color3;
            color3 = color4;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        int n8 = n2 + n4;
        this.setColor(color2);
        this.drawLine(n5, n6, n7, n6);
        this.drawLine(n5, n8, n5, n6);
        this.setColor(color3);
        this.drawLine(n7, n6, n7, n8);
        this.drawLine(n7, n8, n5, n8);
        this.setColor(color);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.fillRect(n, n2, n3, n4);
        this.draw3DRect(n, n2, n3 - 1, n4 - 1, bl);
    }

    public abstract void drawOval(int var1, int var2, int var3, int var4);

    public abstract void fillOval(int var1, int var2, int var3, int var4);

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawPolyline(int[] var1, int[] var2, int var3);

    public abstract void drawPolygon(int[] var1, int[] var2, int var3);

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void fillPolygon(int[] var1, int[] var2, int var3);

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void drawString(String var1, int var2, int var3);

    public abstract void drawString(AttributedCharacterIterator var1, int var2, int var3);

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.drawString(new String(cArray, n, n2), n3, n4);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        String string = new String(byArray, n, n2);
        this.drawString(string, n3, n4);
    }

    public abstract boolean drawImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, ImageObserver var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, Color var4, ImageObserver var5);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, Color var6, ImageObserver var7);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, ImageObserver var10);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10, ImageObserver var11);

    public abstract void dispose();

    public void finalize() {
        this.dispose();
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        return this.getClip().intersects(n, n2, n3, n4);
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        Rectangle rectangle2 = this.getClipBounds();
        if (rectangle == null) {
            return rectangle2;
        }
        rectangle.x = rectangle2.x;
        rectangle.y = rectangle2.y;
        rectangle.width = rectangle2.width;
        rectangle.height = rectangle2.height;
        return rectangle;
    }
}

