/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;

class EventDispatchThread
extends Thread {
    private static int dispatchThreadNum;
    private EventQueue queue;

    EventDispatchThread(EventQueue eventQueue) {
        this.setName("AWT-EventQueue-" + ++dispatchThreadNum);
        this.queue = eventQueue;
        this.setPriority(6);
    }

    public void run() {
        while (true) {
            try {
                AWTEvent aWTEvent = this.queue.getNextEvent();
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (keyboardFocusManager.dispatchEvent(aWTEvent)) continue;
                this.queue.dispatchEvent(aWTEvent);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Throwable throwable) {
                System.err.println("Exception during event dispatch:");
                throwable.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

