/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.Serializable;

public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    static final long serialVersionUID = 486933713763926351L;
    private boolean implicitDownCycleTraversal;

    private /* synthetic */ void finit$() {
        this.implicitDownCycleTraversal = true;
    }

    public ContainerOrderFocusTraversalPolicy() {
        this.finit$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getComponentAfter(Container container, Component component) {
        Container container2;
        if (container == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (component == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container container3 = container2 = component.getFocusCycleRootAncestor();
        while (container2 != container) {
            container2 = component.getFocusCycleRootAncestor();
            if (container2 == container3) {
                if (container2 == container) break;
                throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
            }
            container3 = container2;
        }
        if (container == component) {
            container = component.getFocusCycleRootAncestor();
        }
        if (component instanceof Window) {
            return this.getFirstComponent((Container)component);
        }
        Container container4 = component.getParent();
        Object object = container4.getTreeLock();
        synchronized (object) {
            try {
                int n;
                Component[] componentArray = container4.getComponents();
                int n2 = 0;
                int n3 = container4.getComponentCount();
                for (n = 0; n < n3; ++n) {
                    if (componentArray[n] != component) continue;
                    n2 = n;
                }
                n = n2 + 1;
                while (n < n3) {
                    Component component2;
                    if (this.accept(componentArray[n])) {
                        return componentArray[n];
                    }
                    if (componentArray[n] instanceof Container && (component2 = this.getFirstComponent((Container)componentArray[n])) != null && this.implicitDownCycleTraversal) {
                        return component2;
                    }
                    ++n;
                }
                Component component3 = this.getComponentAfter(container, container4);
                return component3;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getComponentBefore(Container container, Component component) {
        Container container2;
        if (container == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (component == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!container.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container container3 = container2 = component.getFocusCycleRootAncestor();
        while (container2 != container) {
            container2 = component.getFocusCycleRootAncestor();
            if (container2 == container3) {
                if (container2 == container) break;
                throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
            }
            container3 = container2;
        }
        if (container == component) {
            container = component.getFocusCycleRootAncestor();
        }
        if (component instanceof Window) {
            return this.getLastComponent((Container)component);
        }
        Container container4 = component.getParent();
        Object object = container4.getTreeLock();
        synchronized (object) {
            try {
                int n;
                Component[] componentArray = container4.getComponents();
                int n2 = 0;
                int n3 = container4.getComponentCount();
                for (n = 0; n < n3; ++n) {
                    if (componentArray[n] != component) continue;
                    n2 = n;
                }
                n = n2 - 1;
                while (n >= 0) {
                    Component component2;
                    if (this.accept(componentArray[n])) {
                        return componentArray[n];
                    }
                    if (componentArray[n] instanceof Container && (component2 = this.getLastComponent((Container)componentArray[n])) != null) {
                        return component2;
                    }
                    --n;
                }
                Component component3 = this.getComponentBefore(container, container4);
                return component3;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                throw throwable;
            }
        }
    }

    public Component getFirstComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException();
        }
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        if (this.accept(container)) {
            return container;
        }
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component;
            Component component2 = componentArray[i];
            if (this.accept(component2)) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = this.getFirstComponent((Container)component2)) == null) continue;
            return component;
        }
        return null;
    }

    public Component getLastComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException();
        }
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        if (this.accept(container)) {
            return container;
        }
        Component[] componentArray = container.getComponents();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            Component component;
            Component component2 = componentArray[i];
            if (this.accept(component2)) {
                return component2;
            }
            if (!(component2 instanceof Container) || (component = this.getLastComponent((Container)component2)) == null) continue;
            return component;
        }
        return null;
    }

    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public void setImplicitDownCycleTraversal(boolean bl) {
        this.implicitDownCycleTraversal = bl;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected boolean accept(Component component) {
        return component.visible && component.isDisplayable() && component.enabled && component.focusable;
    }
}

